/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.api.StringUtils;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.view.ExFormattedTextField;
import com.intel.stl.ui.common.view.SafeTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigInteger;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HexField<E extends Number>
extends JPanel {
    private static final long serialVersionUID = 7780981211073008225L;
    private final String name;
    protected JFormattedTextField field;
    private E lastValue;

    public HexField(String name, E defaultValue) {
        this.name = name;
        this.lastValue = defaultValue;
        this.setName(name);
        this.initComponent();
        this.setValue(defaultValue);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void initComponent() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(2, 2, 2, 2);
        gc.fill = 2;
        if (this.name != null) {
            gc.gridwidth = 1;
            gc.weightx = 0.0;
            JLabel label = new JLabel(this.name);
            this.add((Component)label, gc);
        }
        gc.gridwidth = 0;
        gc.weightx = 1.0;
        this.field = this.createTextField();
        this.add((Component)this.field, gc);
    }

    protected JFormattedTextField createTextField() {
        HexFormatter formatter = new HexFormatter(this, this.lastValue);
        ExFormattedTextField res = new ExFormattedTextField(formatter);
        formatter.setParent(res);
        return res;
    }

    public void setValue(E val) {
        this.field.setValue(val);
    }

    public E getValue() {
        this.lastValue = (Number)this.field.getValue();
        return this.lastValue;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.field.setEditable(enabled);
    }

    public void setEditable(boolean b) {
        this.field.setEditable(b);
    }

    public boolean isEditValid() {
        return this.field.isEditValid();
    }

    public static class HexFormatter<N extends Number>
    extends SafeTextField.SafeStringFormatter {
        private static final long serialVersionUID = -233085733398543484L;
        final /* synthetic */ HexField this$0;

        public HexFormatter(N defaultValue) {
            this.this$0 = var1_1;
            super(true);
            if (defaultValue != null) {
                this.setValueClass(defaultValue.getClass());
            }
            this.setValidCharacters("0123456789abcdefxABCDEFX");
        }

        @Override
        public Object stringToValue(String txt) throws ParseException {
            this.checkEmpty(txt);
            this.checkLength(txt);
            this.checkValidChar(txt);
            try {
                Class<?> type = this.getValueClass();
                if (type == Long.class) {
                    BigInteger bi;
                    this.setValidationTooltip(UILabels.STL81021_RANGE1_VALIDATION.getDescription("0x0", "0xFFFFFFFFFFFFFFFF"));
                    int radix = 10;
                    if (txt.startsWith("0x") || txt.startsWith("0X")) {
                        txt = txt.substring(2, txt.length());
                        radix = 16;
                    }
                    if ((bi = new BigInteger(txt, radix)).bitLength() > 64) {
                        throw new IllegalArgumentException("Invalid range");
                    }
                    return bi.longValue();
                }
                if (type == Integer.class) {
                    this.setValidationTooltip(UILabels.STL81021_RANGE1_VALIDATION.getDescription("0x0", "0xFFFFFFFF"));
                    long val = Long.decode(txt);
                    if (val > -1L || val < Integer.MIN_VALUE) {
                        throw new IllegalArgumentException("Invalid range");
                    }
                    return (int)val;
                }
                if (type == Short.class) {
                    this.setValidationTooltip(UILabels.STL81021_RANGE1_VALIDATION.getDescription("0x0", "0xFFFF"));
                    int val = Integer.decode(txt);
                    if (val > 65535 || val < Short.MIN_VALUE) {
                        throw new IllegalArgumentException("Invalid range");
                    }
                    return (short)val;
                }
                if (type == Byte.class) {
                    this.setValidationTooltip(UILabels.STL81021_RANGE1_VALIDATION.getDescription("0x0", "0xFF"));
                    short val = Short.decode(txt);
                    if (val > 255 || val < -128) {
                        throw new IllegalArgumentException("Invalid range");
                    }
                    return (byte)val;
                }
                throw new UnsupportedOperationException();
            }
            catch (Exception e) {
                throw new ParseException(e.getMessage(), 0);
            }
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            if (value == null) {
                return null;
            }
            if (value instanceof Long) {
                return StringUtils.longHexString((Long)value);
            }
            if (value instanceof Integer) {
                return StringUtils.intHexString((Integer)value);
            }
            if (value instanceof Short) {
                return StringUtils.shortHexString((Short)value);
            }
            if (value instanceof Byte) {
                return StringUtils.byteHexString((Byte)value);
            }
            return null;
        }
    }
}

