/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.view.ComponentFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;

public class IntelComboBoxUI
extends BasicComboBoxUI {
    private String arrowButtonTooltip;
    private Border arrowButtonBorder = BorderFactory.createLineBorder(UIConstants.INTEL_GRAY);
    private Border editorBorder = BorderFactory.createMatteBorder(1, 1, 1, 0, UIConstants.INTEL_GRAY);
    private Border rendererBorder = BorderFactory.createCompoundBorder(this.editorBorder, BorderFactory.createEmptyBorder(0, 2, 0, 2));
    private final Border emptyBorder = new EmptyBorder(1, 3, 1, 3);
    protected int horizontalAlignment = 2;
    private Object oldValue;

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.comboBox.setForeground(UIConstants.INTEL_DARK_GRAY);
        this.comboBox.setBackground(UIConstants.INTEL_WHITE);
        this.comboBox.setBorder(BorderFactory.createEmptyBorder());
    }

    @Override
    protected JButton createArrowButton() {
        JButton button = ComponentFactory.getImageButton(UIImages.DOWN_ICON.getImageIcon());
        button.setToolTipText(this.arrowButtonTooltip);
        if (this.arrowButtonBorder == null) {
            button.setBorderPainted(false);
        } else {
            button.setBorderPainted(true);
            button.setBorder(this.arrowButtonBorder);
        }
        return button;
    }

    public void setArrowButtonTooltip(String tooltip) {
        this.arrowButtonTooltip = tooltip;
        if (this.arrowButton != null) {
            this.arrowButton.setToolTipText(tooltip);
        }
    }

    public void setArrowButtonBorder(Border border) {
        this.arrowButtonBorder = border;
        if (this.arrowButton != null) {
            if (border == null) {
                this.arrowButton.setBorderPainted(false);
            } else {
                this.arrowButton.setBorderPainted(true);
                this.arrowButton.setBorder(border);
            }
        }
    }

    public void setEditorBorder(Border border) {
        this.editorBorder = border;
        this.rendererBorder = BorderFactory.createCompoundBorder(this.editorBorder, BorderFactory.createEmptyBorder(0, 2, 0, 2));
    }

    protected ListCellRenderer createRenderer() {
        return new BasicComboBoxRenderer.UIResource(){
            private static final long serialVersionUID = 4146544528251981068L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                label.setText(IntelComboBoxUI.this.getValueString(value));
                label.setToolTipText(IntelComboBoxUI.this.getValueTooltip(value));
                label.setHorizontalAlignment(IntelComboBoxUI.this.horizontalAlignment);
                if (index == -1) {
                    label.setBorder(IntelComboBoxUI.this.rendererBorder);
                } else {
                    label.setBorder(IntelComboBoxUI.this.emptyBorder);
                }
                return label;
            }
        };
    }

    protected ComboBoxEditor createEditor2() {
        ComboBoxEditor editor = new ComboBoxEditor(){
            private final JLabel label = ComponentFactory.getH5Label("", 0);
            {
                this.label.setForeground(UIConstants.INTEL_DARK_GRAY);
                this.label.setToolTipText(IntelComboBoxUI.this.comboBox.getToolTipText());
                this.label.setHorizontalAlignment(IntelComboBoxUI.this.horizontalAlignment);
            }

            @Override
            public Component getEditorComponent() {
                return this.label;
            }

            @Override
            public void setItem(Object anObject) {
                this.label.setText(IntelComboBoxUI.this.getValueString(anObject));
                this.label.setToolTipText(IntelComboBoxUI.this.getValueTooltip(anObject));
            }

            @Override
            public Object getItem() {
                return null;
            }

            @Override
            public void selectAll() {
            }

            @Override
            public void addActionListener(ActionListener l) {
            }

            @Override
            public void removeActionListener(ActionListener l) {
            }
        };
        return editor;
    }

    @Override
    protected ComboBoxEditor createEditor() {
        BasicComboBoxEditor.UIResource editor = new BasicComboBoxEditor.UIResource(){

            @Override
            public Component getEditorComponent() {
                JTextField editor = (JTextField)super.getEditorComponent();
                editor.setForeground(UIConstants.INTEL_DARK_GRAY);
                editor.setBorder(IntelComboBoxUI.this.editorBorder);
                editor.setToolTipText(IntelComboBoxUI.this.comboBox.getToolTipText());
                return editor;
            }

            @Override
            public void setItem(Object anObject) {
                if (anObject != null) {
                    this.editor.setText(IntelComboBoxUI.this.getValueString(anObject));
                    this.editor.setToolTipText(IntelComboBoxUI.this.getValueTooltip(anObject));
                    IntelComboBoxUI.this.oldValue = anObject;
                } else {
                    this.editor.setText("");
                    this.editor.setToolTipText(null);
                }
            }

            @Override
            public Object getItem() {
                String newValue = this.editor.getText();
                if (IntelComboBoxUI.this.oldValue != null && !(IntelComboBoxUI.this.oldValue instanceof String)) {
                    if (newValue.equals(IntelComboBoxUI.this.getValueString(IntelComboBoxUI.this.oldValue))) {
                        return IntelComboBoxUI.this.oldValue;
                    }
                    return IntelComboBoxUI.this.getValueByString(this.editor.getText());
                }
                return newValue;
            }
        };
        return editor;
    }

    protected String getValueString(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    protected String getValueTooltip(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    protected Object getValueByString(String text) {
        Class<?> cls = this.oldValue.getClass();
        try {
            Method method = cls.getMethod("valueOf", String.class);
            return method.invoke(this.oldValue, text);
        }
        catch (Exception exception) {
            return text;
        }
    }

    @Override
    protected ComboPopup createPopup() {
        ComboPopup res = super.createPopup();
        ((JComponent)((Object)res)).setBorder(BorderFactory.createLineBorder(UIConstants.INTEL_BORDER_GRAY));
        return res;
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        Color oldListBkg = this.listBox.getSelectionBackground();
        Color oldListFgd = this.listBox.getSelectionForeground();
        this.listBox.setSelectionBackground(this.comboBox.getBackground());
        this.listBox.setSelectionForeground(this.comboBox.getForeground());
        super.paintCurrentValue(g, bounds, hasFocus);
        this.listBox.setSelectionBackground(oldListBkg);
        this.listBox.setSelectionForeground(oldListFgd);
    }
}

