/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class JLabelBar
extends JLabel {
    private static final long serialVersionUID = 5644031069268625217L;
    private double normalizedBarValue;
    private Color barColor;
    private int barSize = 5;
    private int barPosition;
    private Insets barInsets = new Insets(0, 5, 0, 0);
    private Border outerBorder;

    public JLabelBar(Icon image, int horizontalAlignment, double normalizedBarValue, Color barColor, int barPosition) {
        super(image, horizontalAlignment);
        this.initBar(normalizedBarValue, barColor, barPosition);
    }

    public JLabelBar(String text, int horizontalAlignment, double normalizedBarValue, Color barColor, int barPosition) {
        super(text, horizontalAlignment);
        this.initBar(normalizedBarValue, barColor, barPosition);
    }

    protected void initBar(double normalizedBarValue, Color barColor, int barPosition) {
        if (normalizedBarValue < 0.0 || normalizedBarValue > 1.0) {
            throw new IllegalArgumentException("normalizedBarValue (" + normalizedBarValue + ") in not in range [0, 1]");
        }
        if (barPosition != 1 && barPosition != 3 && barPosition != 2 && barPosition != 4) {
            throw new IllegalArgumentException("Invalid barPosition (" + barPosition + "). It must be TOP, BOTTOM, LEFT or RIGHT.");
        }
        this.normalizedBarValue = normalizedBarValue;
        this.barColor = barColor;
        this.barPosition = barPosition;
    }

    public void setBarSize(int barSize) {
        this.barSize = barSize;
        this.setBorder(this.outerBorder);
        this.repaint();
    }

    public Insets getBarInsets() {
        return this.barInsets;
    }

    public void setBarInsets(Insets barInsets) {
        this.barInsets = barInsets;
        this.setBorder(this.outerBorder);
        this.repaint();
    }

    @Override
    public void setBorder(Border border) {
        this.outerBorder = border;
        Border innerBorder = null;
        int horizontalBarSpace = this.barInsets.top + this.barInsets.bottom + this.barSize;
        int verticalBarSpace = this.barInsets.left + this.barInsets.right + this.barSize;
        switch (this.barPosition) {
            case 1: {
                innerBorder = BorderFactory.createEmptyBorder(horizontalBarSpace, 0, 0, 0);
                break;
            }
            case 3: {
                innerBorder = BorderFactory.createEmptyBorder(0, 0, horizontalBarSpace, 0);
                break;
            }
            case 2: {
                innerBorder = BorderFactory.createEmptyBorder(0, verticalBarSpace, 0, 0);
                break;
            }
            case 4: {
                innerBorder = BorderFactory.createEmptyBorder(0, 0, 0, verticalBarSpace);
            }
        }
        CompoundBorder newBorder = BorderFactory.createCompoundBorder(border, innerBorder);
        super.setBorder(newBorder);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        switch (this.barPosition) {
            case 1: {
                this.drawTopBar(g);
                break;
            }
            case 3: {
                this.drawBottomBar(g);
                break;
            }
            case 2: {
                this.drawLeftBar(g);
                break;
            }
            case 4: {
                this.drawRightBar(g);
            }
        }
    }

    protected void drawTopBar(Graphics g) {
        Insets insets = this.getInsets();
        int w = (int)((double)(this.getWidth() - insets.left - insets.right - this.barInsets.left - this.barInsets.right) * this.normalizedBarValue);
        int h = this.barSize;
        int x = insets.left + this.barInsets.left;
        int y = insets.top - this.barInsets.bottom - this.barSize;
        if (y < 0) {
            y = 0;
        }
        g.setColor(this.barColor);
        g.fillRect(x, y, w, h);
    }

    protected void drawBottomBar(Graphics g) {
        Insets insets = this.getInsets();
        int w = (int)((double)(this.getWidth() - insets.left - insets.right - this.barInsets.left - this.barInsets.right) * this.normalizedBarValue);
        int h = this.barSize;
        int x = insets.left + this.barInsets.left;
        int y = this.getHeight() - insets.bottom + this.barInsets.top;
        if (y < 0) {
            y = 0;
        }
        g.setColor(this.barColor);
        g.fillRect(x, y, w, h);
    }

    protected void drawLeftBar(Graphics g) {
        int y;
        Insets insets = this.getInsets();
        int w = this.barSize;
        int h = (int)((double)(this.getHeight() - insets.top - insets.bottom - this.barInsets.top - this.barInsets.bottom) * this.normalizedBarValue);
        int x = insets.left - this.barInsets.right - this.barSize;
        if (x < 0) {
            x = 0;
        }
        if ((y = this.getHeight() - insets.bottom - this.barInsets.bottom - h) < 0) {
            y = 0;
        }
        g.setColor(this.barColor);
        g.fillRect(x, y, w, h);
    }

    protected void drawRightBar(Graphics g) {
        int y;
        Insets insets = this.getInsets();
        int w = this.barSize;
        int h = (int)((double)(this.getHeight() - insets.top - insets.bottom - this.barInsets.top - this.barInsets.bottom) * this.normalizedBarValue);
        int x = this.getWidth() - insets.right + this.barInsets.left;
        if (x < 0) {
            x = 0;
        }
        if ((y = this.getHeight() - insets.bottom - this.barInsets.bottom - h) < 0) {
            y = 0;
        }
        g.setColor(this.barColor);
        g.fillRect(x, y, w, h);
    }
}

