/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.view.SafeTextField;
import java.text.ParseException;

public class SafeNameField
extends SafeTextField {
    private static final long serialVersionUID = 5250530579368568787L;

    public SafeNameField(boolean allowEmpty) {
        super(new SafeNameFormatter(allowEmpty));
    }

    public SafeNameField(boolean allowEmpty, int maxLength) {
        super(new SafeNameFormatter(allowEmpty, maxLength));
    }

    public static class SafeNameFormatter
    extends SafeTextField.SafeStringFormatter {
        private static final long serialVersionUID = 7301310953156564571L;

        public SafeNameFormatter(boolean allowEmpty) {
            this(allowEmpty, 64);
        }

        public SafeNameFormatter(boolean allowEmpty, int maxLength) {
            super(allowEmpty, maxLength);
            this.setValidCharacters("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqsrtuvwxyz .-=_");
        }

        @Override
        protected void verify(String value) throws ParseException {
            super.verify(value);
            this.checkSpace(value);
            this.chectDigits(value);
        }

        protected void checkSpace(String value) throws ParseException {
            if (value.trim().length() != value.length()) {
                this.setValidationTooltip(UILabels.STL50098_TEXT_FIELD_INVALID_SPACES.getDescription());
                throw new ParseException("Cannot start or end with space", 0);
            }
        }

        protected void chectDigits(String value) throws ParseException {
            if (!value.isEmpty() && Character.isDigit(value.charAt(0))) {
                this.setValidationTooltip(UILabels.STL50099_TEXT_FIELD_INVALID_DIGITS.getDescription());
                throw new ParseException("Cannot start with digits", 0);
            }
        }
    }
}

