/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.view.ExFormattedTextField;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;

public class SafeTextField
extends ExFormattedTextField {
    private static final long serialVersionUID = 1494207078500818852L;

    public SafeTextField(boolean allowEmpty) {
        this(allowEmpty, 64);
    }

    public SafeTextField(boolean allowEmpty, int maxLength) {
        super(new SafeStringFormatter(allowEmpty, maxLength));
        ((SafeStringFormatter)this.getFormatter()).setParent(this);
    }

    public SafeTextField(JFormattedTextField.AbstractFormatter formatter) {
        super(formatter);
        if (formatter instanceof SafeStringFormatter) {
            ((SafeStringFormatter)formatter).setParent(this);
        }
    }

    public void setValidChars(String validChars) {
        ((SafeStringFormatter)this.getFormatter()).setValidCharacters(validChars);
    }

    public static class SafeStringFormatter
    extends DefaultFormatter {
        private static final long serialVersionUID = -7294298916477068437L;
        protected static final int DEFAULT_MAX_LENGTH = 64;
        public static final String VALID_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqsrtuvwxyz!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~ ";
        private ExFormattedTextField parent;
        private String validCharacters;
        private boolean allowEmpty = true;
        private int maxLength = 64;

        public SafeStringFormatter(boolean allowEmpty) {
            this(allowEmpty, 64);
        }

        public SafeStringFormatter(boolean allowEmpty, int maxLength) {
            this.allowEmpty = allowEmpty;
            if (maxLength > 0) {
                this.maxLength = maxLength;
            }
            this.setValidCharacters(VALID_CHARS);
            this.setCommitsOnValidEdit(true);
        }

        public void setMaxLength(int maxLength) {
            this.maxLength = maxLength;
        }

        public void setParent(ExFormattedTextField parent) {
            this.parent = parent;
        }

        public String getValidCharacters() {
            return this.validCharacters;
        }

        public void setValidCharacters(String validCharacters) {
            this.validCharacters = validCharacters;
        }

        @Override
        public Object stringToValue(String value) throws ParseException {
            this.verify(value);
            return super.stringToValue(value);
        }

        protected void verify(String value) throws ParseException {
            this.checkEmpty(value);
            this.checkLength(value);
            this.checkValidChar(value);
        }

        protected void checkEmpty(String value) throws ParseException {
            if (this.parent != null && this.parent.hasFocus() && !this.allowEmpty && value.isEmpty()) {
                this.setValidationTooltip(UILabels.STL50084_CANT_BE_BLANK.getDescription());
                throw new ParseException("Cannot be empty", 0);
            }
        }

        protected void checkLength(String value) throws ParseException {
            if (value.length() > this.maxLength) {
                this.setValidationTooltip(UILabels.STL50095_TEXT_FIELD_LIMIT.getDescription(this.maxLength));
                throw new ParseException("Exceed maximum length " + this.maxLength, 0);
            }
        }

        protected void checkValidChar(String value) throws ParseException {
            for (int i = 0; i < value.length(); ++i) {
                if (this.isValidCharacter(value.charAt(i))) continue;
                this.setValidationTooltip(UILabels.STL50096_TEXT_FIELD_INVALID_CHAR.getDescription(Character.valueOf(value.charAt(i))));
                throw new ParseException("Invalid char '" + value.charAt(i) + "'", 0);
            }
        }

        protected boolean isValidCharacter(char aChar) {
            String filter = this.getValidCharacters();
            return filter == null || filter.indexOf(aChar) != -1;
        }

        protected void setValidationTooltip(String tooltip) {
            if (this.parent != null) {
                this.parent.setValidationTooltip(tooltip);
            }
        }
    }
}

