/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.configuration.IConfigurationApi;
import com.intel.stl.api.performance.IPerformanceApi;
import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.LinkRecordBean;
import com.intel.stl.api.subnet.NodeInfoBean;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.api.subnet.PortInfoBean;
import com.intel.stl.api.subnet.PortRecordBean;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.api.subnet.SwitchInfoBean;
import com.intel.stl.api.subnet.SwitchRecordBean;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryProcessorContext
implements ICategoryProcessorContext {
    private static final Logger log = LoggerFactory.getLogger(CategoryProcessorContext.class);
    private FVResourceNode resourceNode;
    private final Context context;
    private NodeRecordBean node;
    private NodeInfoBean nodeInfo;
    private SwitchRecordBean switchBean;
    private SwitchInfoBean switchInfo;
    private PortRecordBean portBean;
    private PortInfoBean portInfo;
    private LinkRecordBean linkBean;
    private NodeRecordBean neighbor;
    private boolean endPort;

    public CategoryProcessorContext(FVResourceNode node, Context context) {
        this.resourceNode = node;
        this.context = context;
        try {
            switch (node.getType()) {
                case SWITCH: {
                    this.setupForSwitch();
                    break;
                }
                case HFI: {
                    this.setupForNode();
                    break;
                }
                case PORT: {
                    this.setupForPort();
                    break;
                }
                case ACTIVE_PORT: {
                    this.setupForPort();
                    break;
                }
                case INACTIVE_PORT: {
                    break;
                }
            }
        }
        catch (SubnetDataNotFoundException e) {
            RuntimeException re = new RuntimeException(e.getMessage());
            re.initCause(e);
            throw re;
        }
    }

    public CategoryProcessorContext(int lid, Context context) {
        this.context = context;
        try {
            this.setupForNode(lid);
        }
        catch (SubnetDataNotFoundException e) {
            RuntimeException re = new RuntimeException(e.getMessage());
            re.initCause(e);
            throw re;
        }
    }

    public CategoryProcessorContext(int lid, short port, Context context) {
        this.context = context;
        try {
            this.setupForPort(lid, port);
        }
        catch (SubnetDataNotFoundException e) {
            RuntimeException re = new RuntimeException(e.getMessage());
            re.initCause(e);
            throw re;
        }
    }

    @Override
    public FVResourceNode getResourceNode() {
        return this.resourceNode;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public ISubnetApi getSubnetApi() {
        return this.context.getSubnetApi();
    }

    @Override
    public IConfigurationApi getConfigurationApi() {
        return this.context.getConfigurationApi();
    }

    @Override
    public IPerformanceApi getPerformanceApi() {
        return this.context.getPerformanceApi();
    }

    @Override
    public NodeRecordBean getNode() {
        return this.node;
    }

    @Override
    public NodeInfoBean getNodeInfo() {
        return this.nodeInfo;
    }

    @Override
    public SwitchRecordBean getSwitch() {
        return this.switchBean;
    }

    @Override
    public SwitchInfoBean getSwitchInfo() {
        return this.switchInfo;
    }

    @Override
    public PortRecordBean getPort() {
        return this.portBean;
    }

    @Override
    public PortInfoBean getPortInfo() {
        return this.portInfo;
    }

    @Override
    public LinkRecordBean getLink() {
        return this.linkBean;
    }

    @Override
    public NodeRecordBean getNeighbor() {
        return this.neighbor;
    }

    @Override
    public boolean isEndPort() {
        return this.endPort;
    }

    private void setupForNode() throws SubnetDataNotFoundException {
        int lid = this.resourceNode.getId();
        this.node = this.getNode(lid);
        this.nodeInfo = null;
        if (this.node != null) {
            this.nodeInfo = this.node.getNodeInfo();
        }
    }

    protected void setupForNode(int lid) throws SubnetDataNotFoundException {
        this.node = this.getNode(lid);
        this.nodeInfo = null;
        if (this.node != null) {
            this.nodeInfo = this.node.getNodeInfo();
        }
    }

    private void setupForSwitch() throws SubnetDataNotFoundException {
        int lid = this.resourceNode.getId();
        this.node = this.getNode(lid);
        this.switchBean = this.getSubnetApi().getSwitch(lid);
        this.nodeInfo = null;
        this.switchInfo = null;
        if (this.node != null) {
            this.nodeInfo = this.node.getNodeInfo();
        }
        if (this.switchBean != null) {
            this.switchInfo = this.switchBean.getSwitchInfo();
        }
    }

    private void setupForPort() throws SubnetDataNotFoundException {
        FVResourceNode parent = this.resourceNode.getParent();
        TreeNodeType type = parent.getType();
        int lid = parent.getId();
        int portNum = this.resourceNode.getId();
        this.node = this.getNode(lid);
        this.portBean = type == TreeNodeType.SWITCH ? this.getSubnetApi().getPortByPortNum(lid, (short)portNum) : this.getSubnetApi().getPortByLocalPortNum(lid, (short)portNum);
        this.nodeInfo = null;
        this.portInfo = null;
        this.linkBean = null;
        this.neighbor = null;
        this.endPort = false;
        if (this.node != null) {
            this.nodeInfo = this.node.getNodeInfo();
            NodeType parentType = this.nodeInfo.getNodeTypeEnum();
            if (parentType != NodeType.SWITCH || parentType == NodeType.SWITCH && portNum == 0) {
                this.endPort = true;
            }
        }
        if (this.portBean != null) {
            this.portInfo = this.portBean.getPortInfo();
        }
        if (this.portBean != null) {
            this.linkBean = null;
            if (type != TreeNodeType.SWITCH) {
                this.linkBean = this.getSubnetApi().getLinkBySource(lid, (short)1);
            } else if (portNum != 0) {
                this.linkBean = this.getSubnetApi().getLinkBySource(lid, (short)portNum);
            }
            if (this.linkBean != null) {
                this.neighbor = this.getNode(this.linkBean.getToLID());
            }
        }
    }

    protected void setupForPort(int lid, short portNum) throws SubnetDataNotFoundException {
        this.node = this.getNode(lid);
        this.portBean = this.getPort(lid, portNum);
        this.nodeInfo = null;
        this.portInfo = null;
        this.linkBean = null;
        this.neighbor = null;
        this.endPort = false;
        if (this.node != null) {
            this.nodeInfo = this.node.getNodeInfo();
            NodeType parentType = this.nodeInfo.getNodeTypeEnum();
            if (parentType != NodeType.SWITCH || parentType == NodeType.SWITCH && portNum == 0) {
                this.endPort = true;
            }
        }
        if (this.portBean != null) {
            this.portInfo = this.portBean.getPortInfo();
        }
        if (this.portBean != null) {
            this.linkBean = null;
            if (portNum != 0) {
                this.linkBean = this.getSubnetApi().getLinkBySource(lid, portNum);
            }
            if (this.linkBean != null) {
                this.neighbor = this.getNode(this.linkBean.getToLID());
            }
        }
    }

    private NodeRecordBean getNode(int lid) throws SubnetDataNotFoundException {
        NodeRecordBean node = this.getSubnetApi().getNode(lid);
        return node;
    }

    protected PortRecordBean getPort(int lid, short portNum) {
        PortRecordBean portBean = null;
        try {
            portBean = this.getSubnetApi().getPortByPortNum(lid, portNum);
        }
        catch (SubnetDataNotFoundException e) {
            log.error(e.getMessage());
        }
        return portBean;
    }

    @Override
    public boolean isHFI() {
        FVResourceNode node = this.getResourceNode();
        return node.getParent().getType() == TreeNodeType.HFI;
    }

    @Override
    public boolean isExternalSWPort() {
        FVResourceNode node = this.getResourceNode();
        PortRecordBean portBean = this.getPort();
        if (portBean != null) {
            return portBean.getPortNum() != 0 && node.getParent().getType() == TreeNodeType.SWITCH;
        }
        return false;
    }

    @Override
    public boolean isBaseSWPort0() {
        FVResourceNode node = this.getResourceNode();
        PortRecordBean portBean = this.getPort();
        return portBean.getPortNum() == 0 && node.getParent().getType() == TreeNodeType.SWITCH;
    }

    @Override
    public boolean isEnhSWPort0() {
        SwitchInfoBean switchinfo = this.getSwitchInfo();
        FVResourceNode node = this.getResourceNode();
        PortRecordBean portBean = this.getPort();
        return switchinfo.isEnhancedPort0() && portBean.getPortNum() == 0 && node.getParent().getType() == TreeNodeType.SWITCH;
    }
}

