/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.FlitControlBean;
import com.intel.stl.api.subnet.PortInfoBean;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;

public class FlitControlPreemptionProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        PortInfoBean portInfo = context.getPortInfo();
        if (portInfo == null) {
            this.getEmptyFlitControlPreemption(category);
            return;
        }
        FlitControlBean flitInfo = portInfo.getFlitControl();
        if (flitInfo == null) {
            this.getEmptyFlitControlPreemption(category);
            return;
        }
        FlitControlPreemptionProcessor.addProperty(category, DeviceProperty.MIN_INITIAL, FlitControlPreemptionProcessor.dec((long)flitInfo.getMinInitial() * 8L));
        FlitControlPreemptionProcessor.addProperty(category, DeviceProperty.MIN_TAIL, FlitControlPreemptionProcessor.dec((long)flitInfo.getMinTail() * 8L));
        FlitControlPreemptionProcessor.addProperty(category, DeviceProperty.LARGE_PKT_LIMIT, FlitControlPreemptionProcessor.hex(flitInfo.getLargePktLimit()));
        FlitControlPreemptionProcessor.addProperty(category, DeviceProperty.SMALL_PKT_LIMIT, FlitControlPreemptionProcessor.hex(flitInfo.getSmallPktLimit()));
        FlitControlPreemptionProcessor.addProperty(category, DeviceProperty.MAX_SMALL_PKT_LIMIT, FlitControlPreemptionProcessor.hex(flitInfo.getMaxSmallPktLimit()));
        FlitControlPreemptionProcessor.addProperty(category, DeviceProperty.PREEMPTION_LIMIT, FlitControlPreemptionProcessor.hex(flitInfo.getPreemptionLimit()));
    }

    private void getEmptyFlitControlPreemption(DevicePropertyCategory category) {
        FlitControlPreemptionProcessor.addProperty(category, DeviceProperty.MIN_INITIAL, "");
        FlitControlPreemptionProcessor.addProperty(category, DeviceProperty.MIN_TAIL, "");
        FlitControlPreemptionProcessor.addProperty(category, DeviceProperty.LARGE_PKT_LIMIT, "");
        FlitControlPreemptionProcessor.addProperty(category, DeviceProperty.SMALL_PKT_LIMIT, "");
        FlitControlPreemptionProcessor.addProperty(category, DeviceProperty.MAX_SMALL_PKT_LIMIT, "");
        FlitControlPreemptionProcessor.addProperty(category, DeviceProperty.PREEMPTION_LIMIT, "");
    }
}

