/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.SwitchInfoBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;

public class ForwardingInfoProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        String falseStr;
        SwitchInfoBean switchInfo = context.getSwitchInfo();
        if (switchInfo == null) {
            this.getEmptySwitchForwardingInfo(category);
            return;
        }
        ForwardingInfoProcessor.addProperty(category, DeviceProperty.LINEAR_FDB_CAP, ForwardingInfoProcessor.dec(switchInfo.getLinearFDBCap()));
        ForwardingInfoProcessor.addProperty(category, DeviceProperty.LINEAR_FDB_TOP, ForwardingInfoProcessor.hex(switchInfo.getLinearFDBTop()));
        ForwardingInfoProcessor.addProperty(category, DeviceProperty.MULTICAST_FDB_CAP, ForwardingInfoProcessor.dec(switchInfo.getMulticastFDBCap()));
        ForwardingInfoProcessor.addProperty(category, DeviceProperty.MULTICAST_FDB_TOP, ForwardingInfoProcessor.hex(switchInfo.getMulticastFDBTop()));
        int cap = switchInfo.getPortGroupFDBCap();
        if (cap != 0) {
            ForwardingInfoProcessor.addProperty(category, DeviceProperty.PORT_GROUP_FDB_CAP, ForwardingInfoProcessor.dec(switchInfo.getPortGroupFDBCap()));
        }
        String trueStr = STLConstants.K0385_TRUE.getValue();
        String value = falseStr = STLConstants.K0386_FALSE.getValue();
        if (switchInfo.isAddrRangeConfigSupported()) {
            value = trueStr;
        }
        ForwardingInfoProcessor.addProperty(category, DeviceProperty.PORT_ADRR_RANGE_CONFIG, value);
    }

    private void getEmptySwitchForwardingInfo(DevicePropertyCategory category) {
        ForwardingInfoProcessor.addProperty(category, DeviceProperty.LINEAR_FDB_CAP, "");
        ForwardingInfoProcessor.addProperty(category, DeviceProperty.LINEAR_FDB_TOP, "");
        ForwardingInfoProcessor.addProperty(category, DeviceProperty.MULTICAST_FDB_CAP, "");
        ForwardingInfoProcessor.addProperty(category, DeviceProperty.MULTICAST_FDB_TOP, "");
        ForwardingInfoProcessor.addProperty(category, DeviceProperty.PORT_GROUP_FDB_CAP, "");
        ForwardingInfoProcessor.addProperty(category, DeviceProperty.PORT_ADRR_RANGE_CONFIG, "");
    }
}

