/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.configuration.PropertyCategory;
import com.intel.stl.api.configuration.PropertyGroup;
import com.intel.stl.api.configuration.UserSettings;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.configuration.CategoryProcessorContext;
import com.intel.stl.ui.framework.AbstractTask;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.model.DeviceProperties;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.DevicePropertyGroup;
import com.intel.stl.ui.model.PropertyGroupViz;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import java.util.List;

public class GetDevicePropertiesTask
extends AbstractTask<DeviceProperties, Void, Void> {
    private final FVResourceNode node;
    private final IProgressObserver observer;

    public GetDevicePropertiesTask(DeviceProperties model, FVResourceNode node, IProgressObserver observer) {
        super(model);
        this.node = node;
        this.observer = observer;
    }

    @Override
    public Void processInBackground(Context context) throws Exception {
        UserSettings userSettings = context.getUserSettings();
        List<PropertyGroup> groups = null;
        if (userSettings != null) {
            groups = userSettings.getPropertiesDisplayOptions().get((Object)((DeviceProperties)this.model).getResourceType());
        }
        CategoryProcessorContext categoryCtx = new CategoryProcessorContext(this.node, context);
        if (groups != null) {
            for (PropertyGroup group : groups) {
                if (!group.isDisplayed()) continue;
                DevicePropertyGroup pageGroup = this.createGroup(group);
                for (PropertyCategory category : group.getCategories()) {
                    ((DeviceProperties)this.model).addCategory(category);
                    pageGroup.addCategory(category.getResourceCategory());
                }
                ((DeviceProperties)this.model).addPropertyGroup(pageGroup);
            }
        }
        for (DevicePropertyCategory pageCategory : ((DeviceProperties)this.model).getCategories()) {
            pageCategory.populate(categoryCtx);
        }
        return null;
    }

    @Override
    public void onTaskSuccess(Void result) {
    }

    @Override
    public void onTaskFailure(Throwable caught) {
        caught.printStackTrace();
    }

    @Override
    public void onFinally() {
        if (this.observer != null) {
            this.observer.onFinish();
        }
    }

    @Override
    public void processIntermediateResults(List<Void> intermediateResults) {
    }

    protected DevicePropertyGroup createGroup(PropertyGroup propertyGroup) {
        DevicePropertyGroup group = new DevicePropertyGroup();
        String title = propertyGroup.getTitle();
        if (title == null || title.length() == 0) {
            String groupName = propertyGroup.getName();
            title = PropertyGroupViz.getPropertyGroupViz(groupName).getTitle();
        }
        group.setGroupName(title);
        return group;
    }
}

