/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.LFTRecordBean;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.DevicePropertyItem;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import java.util.List;

public class LFTTableProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        int lid;
        FVResourceNode node = context.getResourceNode();
        ISubnetApi subnetApi = context.getContext().getSubnetApi();
        List<LFTRecordBean> lftRecs = subnetApi.getLFT(lid = node.getId());
        if (lftRecs == null) {
            return;
        }
        for (LFTRecordBean lft : lftRecs) {
            lid = lft.getBlockNum() * 64;
            byte[] retPts = lft.getLinearFdbData();
            int i = 0;
            while (i < retPts.length) {
                if (retPts[i] != -1) {
                    DevicePropertyItem property = new DevicePropertyItem(DeviceProperty.LFT_TABLE, LFTTableProcessor.hex(lid), (Object)LFTTableProcessor.dec((short)(retPts[i] & 0xFF)));
                    category.addPropertyItem(property);
                }
                ++i;
                ++lid;
            }
        }
    }
}

