/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.LinkRecordBean;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.PortInfoBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;

public class LinkConnectedToProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        LinkRecordBean linkBean = context.getLink();
        NodeRecordBean neighbor = context.getNeighbor();
        PortInfoBean portInfo = context.getPortInfo();
        String na = STLConstants.K0383_NA.getValue();
        if (linkBean != null && neighbor != null) {
            LinkConnectedToProcessor.addProperty(category, DeviceProperty.NODE_DESCRIPTION, neighbor.getNodeDesc());
        } else {
            LinkConnectedToProcessor.addProperty(category, DeviceProperty.NODE_DESCRIPTION, na);
        }
        if (linkBean != null && portInfo != null) {
            LinkConnectedToProcessor.addProperty(category, DeviceProperty.NEIGHBOR_GUID, LinkConnectedToProcessor.hex(portInfo.getNeighborNodeGUID()));
        } else {
            LinkConnectedToProcessor.addProperty(category, DeviceProperty.NEIGHBOR_GUID, na);
        }
        if (linkBean != null) {
            LinkConnectedToProcessor.addProperty(category, DeviceProperty.PORT_INDEX, LinkConnectedToProcessor.dec(linkBean.getToPortIndex()));
        } else {
            LinkConnectedToProcessor.addProperty(category, DeviceProperty.PORT_INDEX, na);
        }
    }
}

