/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.PortInfoBean;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.PortLinkModeViz;

public class LinkModeProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        PortInfoBean portInfo = context.getPortInfo();
        if (portInfo == null) {
            this.getEmptyPortLinkMode(category);
            return;
        }
        LinkModeProcessor.addProperty(category, DeviceProperty.PORT_LINK_MODE_ACT, PortLinkModeViz.getPortLinkModeStr(portInfo.getPlmActive()));
        LinkModeProcessor.addProperty(category, DeviceProperty.PORT_LINK_MODE_SUP, PortLinkModeViz.getPortLinkModeStr(portInfo.getPlmSupported()));
        LinkModeProcessor.addProperty(category, DeviceProperty.PORT_LINK_MODE_ENA, PortLinkModeViz.getPortLinkModeStr(portInfo.getPlmEnabled()));
    }

    private void getEmptyPortLinkMode(DevicePropertyCategory category) {
        LinkModeProcessor.addProperty(category, DeviceProperty.PORT_LINK_MODE_ACT, "");
        LinkModeProcessor.addProperty(category, DeviceProperty.PORT_LINK_MODE_SUP, "");
        LinkModeProcessor.addProperty(category, DeviceProperty.PORT_LINK_MODE_ENA, "");
    }
}

