/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.PortInfoBean;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.PortLtpCrcModeViz;

public class LtpCrcModeProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        PortInfoBean portInfo = context.getPortInfo();
        if (portInfo == null) {
            this.getEmptyPortLtpCrcMode(category);
            return;
        }
        LtpCrcModeProcessor.addProperty(category, DeviceProperty.PORT_LTP_CRC_ACT, PortLtpCrcModeViz.getPortLtpCrcModeStr(portInfo.getPLTPCRCModeActive()));
        LtpCrcModeProcessor.addProperty(category, DeviceProperty.PORT_LTP_CRC_SUP, PortLtpCrcModeViz.getPortLtpCrcModeStr(portInfo.getPLTPCRCModeSupported()));
        LtpCrcModeProcessor.addProperty(category, DeviceProperty.PORT_LTP_CRC_ENA, PortLtpCrcModeViz.getPortLtpCrcModeStr(portInfo.getPLTPCRCModeEnabled()));
    }

    private void getEmptyPortLtpCrcMode(DevicePropertyCategory category) {
        LtpCrcModeProcessor.addProperty(category, DeviceProperty.PORT_LTP_CRC_ACT, "");
        LtpCrcModeProcessor.addProperty(category, DeviceProperty.PORT_LTP_CRC_SUP, "");
        LtpCrcModeProcessor.addProperty(category, DeviceProperty.PORT_LTP_CRC_ENA, "");
    }
}

