/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.NodeInfoBean;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.NodeTypeViz;

public class NodeInfoProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        NodeRecordBean nodeBean = context.getNode();
        NodeInfoBean nodeInfo = context.getNodeInfo();
        String nodeActive = STLConstants.K0322_PORT_LINK_ACTIVE.getValue();
        if (!nodeBean.isActive()) {
            nodeActive = STLConstants.K0524_INACTIVE.getValue();
        }
        NodeInfoProcessor.addProperty(category, DeviceProperty.NODE_STATE, nodeActive);
        if (nodeInfo == null) {
            this.getEmptyNodeDeviceInfo(category);
            return;
        }
        NodeInfoProcessor.addProperty(category, DeviceProperty.NODE_LID, NodeInfoProcessor.hex(nodeBean.getLid()));
        NodeInfoProcessor.addProperty(category, DeviceProperty.NODE_NAME, nodeBean.getNodeDesc());
        if (nodeInfo != null) {
            NodeTypeViz nodeTypeViz = NodeTypeViz.getNodeTypeViz(nodeInfo.getNodeTypeEnum());
            if (nodeTypeViz != null) {
                NodeInfoProcessor.addProperty(category, DeviceProperty.NODE_TYPE, nodeTypeViz.getName());
            }
            NodeInfoProcessor.addProperty(category, DeviceProperty.NODE_GUID, NodeInfoProcessor.hex(nodeInfo.getNodeGUID()));
            NodeInfoProcessor.addProperty(category, DeviceProperty.SYSTEM_IMAGE_GUID, NodeInfoProcessor.hex(nodeInfo.getSysImageGUID()));
            NodeInfoProcessor.addProperty(category, DeviceProperty.PARTITION_CAP, NodeInfoProcessor.dec(nodeInfo.getPartitionCap()));
            NodeInfoProcessor.addProperty(category, DeviceProperty.BASE_VERSION, NodeInfoProcessor.dec(nodeInfo.getBaseVersion()));
            NodeInfoProcessor.addProperty(category, DeviceProperty.SMA_VERSION, NodeInfoProcessor.dec(nodeInfo.getClassVersion()));
            NodeInfoProcessor.addProperty(category, DeviceProperty.DEVICE_ID, NodeInfoProcessor.hex(nodeInfo.getDeviceID()));
            NodeInfoProcessor.addProperty(category, DeviceProperty.VENDOR_ID, NodeInfoProcessor.hex(nodeInfo.getVendorID()));
            NodeInfoProcessor.addProperty(category, DeviceProperty.REVISION, NodeInfoProcessor.hex(nodeInfo.getRevision()));
        }
    }

    private void getEmptyNodeDeviceInfo(DevicePropertyCategory category) {
        NodeInfoProcessor.addProperty(category, DeviceProperty.NODE_LID, "");
        NodeInfoProcessor.addProperty(category, DeviceProperty.NODE_TYPE, "");
        NodeInfoProcessor.addProperty(category, DeviceProperty.NODE_NAME, "");
        NodeInfoProcessor.addProperty(category, DeviceProperty.NODE_GUID, "");
        NodeInfoProcessor.addProperty(category, DeviceProperty.SYSTEM_IMAGE_GUID, "");
        NodeInfoProcessor.addProperty(category, DeviceProperty.PARTITION_CAP, "");
        NodeInfoProcessor.addProperty(category, DeviceProperty.BASE_VERSION, "");
        NodeInfoProcessor.addProperty(category, DeviceProperty.SMA_VERSION, "");
        NodeInfoProcessor.addProperty(category, DeviceProperty.DEVICE_ID, "");
        NodeInfoProcessor.addProperty(category, DeviceProperty.VENDOR_ID, "");
        NodeInfoProcessor.addProperty(category, DeviceProperty.REVISION, "");
    }
}

