/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.PortInfoBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.DevicePropertyItem;
import com.intel.stl.ui.model.PortErrorActionViz;
import java.util.List;

public class PortErrorActionsProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        PortInfoBean portInfo = context.getPortInfo();
        if (portInfo == null) {
            DevicePropertyItem property = new DevicePropertyItem(DeviceProperty.PORT_ERROR_ACTION, (Object)STLConstants.K0383_NA.getValue());
            category.addPropertyItem(property);
            return;
        }
        List<PortErrorActionViz> errorActions = PortErrorActionViz.getPortErroActions(portInfo.getPortErrorAction());
        if (errorActions.size() == 0) {
            DevicePropertyItem property = new DevicePropertyItem(DeviceProperty.PORT_ERROR_ACTION, (Object)STLConstants.K0799_NO_ACTIONS.getValue());
            category.addPropertyItem(property);
            return;
        }
        for (PortErrorActionViz errorAction : errorActions) {
            DevicePropertyItem property = new DevicePropertyItem(DeviceProperty.PORT_ERROR_ACTION, errorAction.getGeneralReason(), (Object)errorAction.getSpecificReason());
            category.addPropertyItem(property);
        }
    }
}

