/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.configuration.MTUSize;
import com.intel.stl.api.configuration.PhysicalState;
import com.intel.stl.api.configuration.PortState;
import com.intel.stl.api.subnet.NodeInfoBean;
import com.intel.stl.api.subnet.PortInfoBean;
import com.intel.stl.api.subnet.PortRecordBean;
import com.intel.stl.api.subnet.PortStatesBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.LinkDownReasonViz;
import com.intel.stl.ui.model.LinkInitReasonViz;
import com.intel.stl.ui.model.MTUSizeViz;
import com.intel.stl.ui.model.OfflineDisabledReasonViz;
import com.intel.stl.ui.model.PhysicalStateViz;
import com.intel.stl.ui.model.PortStateViz;
import com.intel.stl.ui.model.PortTypeViz;

public class PortInfoProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        NodeInfoBean nodeInfo = context.getNodeInfo();
        PortRecordBean portBean = context.getPort();
        PortInfoBean portInfo = context.getPortInfo();
        boolean isHFI = context.isHFI();
        boolean isExternalSWPort = context.isExternalSWPort();
        if (nodeInfo == null || portInfo == null) {
            this.getEmptyPortDeviceInfo(category);
            return;
        }
        String trueStr = STLConstants.K0385_TRUE.getValue();
        String falseStr = STLConstants.K0386_FALSE.getValue();
        String unknownStr = STLConstants.K0387_UNKNOWN.getValue();
        String value = falseStr;
        PortInfoProcessor.addProperty(category, DeviceProperty.PORT_LID, PortInfoProcessor.dec(portBean.getEndPortLID()));
        PortInfoProcessor.addProperty(category, DeviceProperty.PORT_NUMBER, PortInfoProcessor.dec(portBean.getPortNum()));
        PortInfoProcessor.addProperty(category, DeviceProperty.PORT_LOCAL_NUM, PortInfoProcessor.dec(portInfo.getLocalPortNum()));
        PortStatesBean psBean = portInfo.getPortStates();
        if (psBean != null) {
            PortState portState = psBean.getPortState();
            value = unknownStr;
            if (portState != null) {
                value = PortStateViz.getPortStateStr(portState);
            }
            PortInfoProcessor.addProperty(category, DeviceProperty.PORT_STATE, value);
            PortInfoProcessor.addProperty(category, DeviceProperty.LINK_INIT_REASON, LinkInitReasonViz.getLinkInitReasonStr(portInfo.getLinkInitReason()));
            PhysicalState physState = psBean.getPortPhysicalState();
            value = unknownStr;
            if (physState != null) {
                value = PhysicalStateViz.getPhysicalStateStr(physState);
            }
            PortInfoProcessor.addProperty(category, DeviceProperty.PORT_PHYSICAL_STATE, value);
            value = OfflineDisabledReasonViz.getOfflineDisabledReasonStr(psBean.getOfflineReason());
            if (value == null) {
                value = unknownStr;
            }
            PortInfoProcessor.addProperty(category, DeviceProperty.OFFLINE_DISABLED_REASON, value);
            value = falseStr;
            if (isExternalSWPort || isHFI) {
                if (psBean.isLedEnabled()) {
                    value = trueStr;
                }
                PortInfoProcessor.addProperty(category, DeviceProperty.PORT_LED_ENABLED, value);
            } else {
                PortInfoProcessor.addProperty(category, DeviceProperty.PORT_LED_ENABLED, STLConstants.K0383_NA.getValue());
            }
            value = falseStr;
            if (psBean.isSMConfigurationStarted()) {
                value = trueStr;
            }
            PortInfoProcessor.addProperty(category, DeviceProperty.PORT_SM_CONFIG_START, value);
            value = falseStr;
            if (isExternalSWPort || isHFI) {
                if (psBean.isNeighborNormal()) {
                    value = trueStr;
                }
                PortInfoProcessor.addProperty(category, DeviceProperty.PORT_NEIGHBOR_NORMAL, value);
            } else {
                PortInfoProcessor.addProperty(category, DeviceProperty.PORT_NEIGHBOR_NORMAL, STLConstants.K0383_NA.getValue());
            }
        } else {
            PortInfoProcessor.addProperty(category, DeviceProperty.PORT_STATE, "");
            PortInfoProcessor.addProperty(category, DeviceProperty.PORT_PHYSICAL_STATE, "");
            PortInfoProcessor.addProperty(category, DeviceProperty.OFFLINE_DISABLED_REASON, "");
            PortInfoProcessor.addProperty(category, DeviceProperty.PORT_SM_CONFIG_START, "");
            PortInfoProcessor.addProperty(category, DeviceProperty.PORT_NEIGHBOR_NORMAL, "");
        }
        PortInfoProcessor.addProperty(category, DeviceProperty.BASE_LID, PortInfoProcessor.hex(portInfo.getLid()));
        PortInfoProcessor.addProperty(category, DeviceProperty.LMC, PortInfoProcessor.dec(portInfo.getLmc()));
        PortInfoProcessor.addProperty(category, DeviceProperty.PORT_TYPE, PortTypeViz.getPortTypeStr(portInfo.getPortType()));
        PortInfoProcessor.addProperty(category, DeviceProperty.NODE_GUID, PortInfoProcessor.hex(nodeInfo.getNodeGUID()));
        PortInfoProcessor.addProperty(category, DeviceProperty.LINK_DOWN_REASON, LinkDownReasonViz.getLinkDownReasonStr(portInfo.getLinkDownReason()));
        PortInfoProcessor.addProperty(category, DeviceProperty.NEIGHBOR_LINK_DOWN_REASON, LinkDownReasonViz.getLinkDownReasonStr(portInfo.getNeighborLinkDownReason()));
        if (isExternalSWPort) {
            PortInfoProcessor.addProperty(category, DeviceProperty.GID_PREFIX, STLConstants.K0383_NA.getValue());
        } else {
            PortInfoProcessor.addProperty(category, DeviceProperty.GID_PREFIX, PortInfoProcessor.hex(portInfo.getSubnetPrefix()));
        }
        PortInfoProcessor.addProperty(category, DeviceProperty.UNI_DIAG_CODE, PortInfoProcessor.dec(portInfo.getUniversalDiagCode()));
        PortInfoProcessor.addProperty(category, DeviceProperty.VENDOR_DIAG_CODE, PortInfoProcessor.dec(portInfo.getVendorDiagCode()));
        MTUSize mtuCap = portInfo.getMtuCap();
        if (mtuCap != null) {
            PortInfoProcessor.addProperty(category, DeviceProperty.MAX_MTU_SIZE, MTUSizeViz.getMTUSizeStr(mtuCap));
        } else {
            PortInfoProcessor.addProperty(category, DeviceProperty.MAX_MTU_SIZE, STLConstants.K0387_UNKNOWN.getValue());
        }
    }

    private void getEmptyPortDeviceInfo(DevicePropertyCategory category) {
        PortInfoProcessor.addProperty(category, DeviceProperty.PORT_LID, "");
        PortInfoProcessor.addProperty(category, DeviceProperty.PORT_NUMBER, "");
        PortInfoProcessor.addProperty(category, DeviceProperty.PORT_STATE, "");
        PortInfoProcessor.addProperty(category, DeviceProperty.PORT_PHYSICAL_STATE, "");
        PortInfoProcessor.addProperty(category, DeviceProperty.OFFLINE_DISABLED_REASON, "");
        PortInfoProcessor.addProperty(category, DeviceProperty.PORT_SM_CONFIG_START, "");
        PortInfoProcessor.addProperty(category, DeviceProperty.PORT_NEIGHBOR_NORMAL, "");
        PortInfoProcessor.addProperty(category, DeviceProperty.BASE_LID, "");
        PortInfoProcessor.addProperty(category, DeviceProperty.LMC, "");
        PortInfoProcessor.addProperty(category, DeviceProperty.PORT_TYPE, "");
        PortInfoProcessor.addProperty(category, DeviceProperty.NODE_GUID, "");
        PortInfoProcessor.addProperty(category, DeviceProperty.LINK_DOWN_REASON, "");
        PortInfoProcessor.addProperty(category, DeviceProperty.GID_PREFIX, "");
        PortInfoProcessor.addProperty(category, DeviceProperty.UNI_DIAG_CODE, "");
        PortInfoProcessor.addProperty(category, DeviceProperty.VENDOR_DIAG_CODE, "");
        PortInfoProcessor.addProperty(category, DeviceProperty.MAX_NEIGHBOR_MTU_SIZE, "");
        PortInfoProcessor.addProperty(category, DeviceProperty.MAX_MTU_SIZE, "");
    }
}

