/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.PortInfoBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.MKeyProtectViz;

public class PortManagementProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        PortInfoBean portInfo = context.getPortInfo();
        boolean isEndPort = context.isEndPort();
        boolean isExternalSWPort = context.isExternalSWPort();
        if (portInfo == null) {
            this.getEmptyManagement(category);
            return;
        }
        String na = STLConstants.K0383_NA.getValue();
        String unknown = STLConstants.K0387_UNKNOWN.getValue();
        portInfo.getRespTimeValue();
        String value = na;
        if (isEndPort) {
            value = PortManagementProcessor.hex(portInfo.getMKey());
        }
        PortManagementProcessor.addProperty(category, DeviceProperty.M_KEY, value);
        value = na;
        if (isEndPort) {
            value = PortManagementProcessor.hex(portInfo.getMasterSMLID());
        }
        PortManagementProcessor.addProperty(category, DeviceProperty.MASTER_SM_LID, value);
        value = na;
        if (isEndPort) {
            value = Integer.toString(portInfo.getMKeyLeasePeriod());
        }
        PortManagementProcessor.addProperty(category, DeviceProperty.M_KEY_LEASE_PERIOD, value);
        if (isExternalSWPort) {
            PortManagementProcessor.addProperty(category, DeviceProperty.M_KEY_PROTECT, na);
        } else {
            value = MKeyProtectViz.getMKeyProtectStr(portInfo.getMKeyProtectBits());
            if (value == null) {
                value = unknown;
            }
            PortManagementProcessor.addProperty(category, DeviceProperty.M_KEY_PROTECT, value);
        }
    }

    private void getEmptyManagement(DevicePropertyCategory category) {
        PortManagementProcessor.addProperty(category, DeviceProperty.M_KEY, "");
        PortManagementProcessor.addProperty(category, DeviceProperty.MASTER_SM_LID, "");
        PortManagementProcessor.addProperty(category, DeviceProperty.M_KEY_LEASE_PERIOD, "");
    }
}

