/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.PortRecordBean;
import com.intel.stl.api.subnet.SC2VLMTRecordBean;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.DevicePropertyItem;
import java.util.ArrayList;

public class SC2VLTMTProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        PortRecordBean portBean = context.getPort();
        ISubnetApi subnetApi = context.getContext().getSubnetApi();
        if (portBean == null || portBean.getEndPortLID() == 0) {
            return;
        }
        SC2VLMTRecordBean sc2vltmtRec = subnetApi.getSC2VLTMT(portBean.getEndPortLID(), portBean.getPortNum());
        if (sc2vltmtRec == null) {
            return;
        }
        this.getSC2VLTMT(category, sc2vltmtRec.getData());
    }

    private void getSC2VLTMT(DevicePropertyCategory category, byte[] sc2vlt) {
        ArrayList<Double> sc2vltSeries = new ArrayList<Double>();
        for (int i = 0; i < sc2vlt.length; ++i) {
            String doubleValue = SC2VLTMTProcessor.dec((short)(sc2vlt[i] & 0xFF));
            sc2vltSeries.add(Double.parseDouble(doubleValue));
        }
        double[] series = new double[sc2vltSeries.size()];
        for (int i = 0; i < sc2vltSeries.size(); ++i) {
            series[i] = (Double)sc2vltSeries.get(i);
        }
        DevicePropertyItem property = new DevicePropertyItem(DeviceProperty.VLT, (Object)series);
        category.addPropertyItem(property);
        DevicePropertyItem sc = new DevicePropertyItem(DeviceProperty.SC, (Object)new Integer(32));
        category.addPropertyItem(sc);
    }
}

