/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.PortInfoBean;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.DevicePropertyItem;
import java.util.ArrayList;

public class VLStallCountByVLProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        PortInfoBean portInfo = context.getPortInfo();
        if (portInfo != null) {
            this.getVLStallCount(category, portInfo.getVlStallCount());
        }
    }

    private void getVLStallCount(DevicePropertyCategory category, byte[] vlStallCount) {
        ArrayList<Double> vlStallSeries = new ArrayList<Double>();
        for (int i = 0; i < vlStallCount.length; ++i) {
            String doubleValue = VLStallCountByVLProcessor.dec((short)(vlStallCount[i] & 0xFF));
            vlStallSeries.add(Double.parseDouble(doubleValue));
        }
        double[] series = new double[vlStallSeries.size()];
        for (int i = 0; i < vlStallSeries.size(); ++i) {
            series[i] = (Double)vlStallSeries.get(i);
        }
        DevicePropertyItem property = new DevicePropertyItem(DeviceProperty.VL_STALL_COUNT, (Object)series);
        category.addPropertyItem(property);
        DevicePropertyItem numVLs = new DevicePropertyItem(DeviceProperty.NUM_VL, (Object)new Integer(32));
        category.addPropertyItem(numVLs);
    }
}

