/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration;

import com.intel.stl.api.subnet.NodeInfoBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.api.subnet.PortInfoBean;
import com.intel.stl.api.subnet.VirtualLaneBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.BaseCategoryProcessor;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;

public class VirtualLaneProcessor
extends BaseCategoryProcessor {
    @Override
    public void process(ICategoryProcessorContext context, DevicePropertyCategory category) {
        NodeInfoBean nodeInfo = context.getNodeInfo();
        PortInfoBean portInfo = context.getPortInfo();
        if (nodeInfo == null || portInfo == null) {
            this.getEmptyVirtualLane(category);
            return;
        }
        String unknown = STLConstants.K0387_UNKNOWN.getValue();
        String na = STLConstants.K0383_NA.getValue();
        VirtualLaneBean vlBean = portInfo.getVl();
        String value = unknown;
        byte cap = portInfo.getOperationalVL();
        value = VirtualLaneProcessor.hex(cap);
        VirtualLaneProcessor.addProperty(category, DeviceProperty.OPERATIONAL_VLS, value);
        cap = vlBean.getCap();
        value = VirtualLaneProcessor.hex(cap);
        VirtualLaneProcessor.addProperty(category, DeviceProperty.VL_CAP, value);
        VirtualLaneProcessor.addProperty(category, DeviceProperty.VL_HIGH_LIMIT, VirtualLaneProcessor.dec(vlBean.getHighLimit()));
        VirtualLaneProcessor.addProperty(category, DeviceProperty.VL_PREEMPT_CAP, VirtualLaneProcessor.dec(vlBean.getPreemptCap()));
        VirtualLaneProcessor.addProperty(category, DeviceProperty.VL_PREEMPTING_LIMIT, VirtualLaneProcessor.dec(vlBean.getPreemptingLimit()));
        if (nodeInfo.getNodeTypeEnum() == NodeType.SWITCH && context.getPort().getPortNum() > 0) {
            VirtualLaneProcessor.addProperty(category, DeviceProperty.FLOW_CONTROL_DISABLE_MASK, VirtualLaneProcessor.hex(portInfo.getFlowControlMask()));
        } else {
            VirtualLaneProcessor.addProperty(category, DeviceProperty.FLOW_CONTROL_DISABLE_MASK, na);
        }
        VirtualLaneProcessor.addProperty(category, DeviceProperty.VL_ARBITR_HIGH_CAP, Short.toString(vlBean.getArbitrationHighCap()));
        VirtualLaneProcessor.addProperty(category, DeviceProperty.VL_ARBITR_LOW_CAP, Short.toString(vlBean.getArbitrationLowCap()));
    }

    private void getEmptyVirtualLane(DevicePropertyCategory category) {
        VirtualLaneProcessor.addProperty(category, DeviceProperty.OPERATIONAL_VLS, "");
        VirtualLaneProcessor.addProperty(category, DeviceProperty.VL_CAP, "");
        VirtualLaneProcessor.addProperty(category, DeviceProperty.VL_HIGH_LIMIT, "");
        VirtualLaneProcessor.addProperty(category, DeviceProperty.VL_PREEMPT_CAP, "");
        VirtualLaneProcessor.addProperty(category, DeviceProperty.VL_PREEMPTING_LIMIT, "");
        VirtualLaneProcessor.addProperty(category, DeviceProperty.FLOW_CONTROL_DISABLE_MASK, "");
        VirtualLaneProcessor.addProperty(category, DeviceProperty.VL_ARBITR_HIGH_CAP, "");
        VirtualLaneProcessor.addProperty(category, DeviceProperty.VL_ARBITR_LOW_CAP, "");
        VirtualLaneProcessor.addProperty(category, DeviceProperty.VL_STALL_COUNT, "");
        VirtualLaneProcessor.addProperty(category, DeviceProperty.HOQLIFE_LABEL, "");
    }
}

