/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration.view;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.configuration.PropertyGroup;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.view.ButtonPopup;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.configuration.view.IPropertyListener;
import com.intel.stl.ui.model.PropertyGroupViz;
import com.intel.stl.ui.model.PropertySet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class PropertiesPanel<M extends PropertySet<?>>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private boolean enableOptionControl;
    private boolean enableStyleControl;
    private final int cardGap = 5;
    private int displayWidth;
    private List<Component> panels;
    private List<Integer> panelWidths;
    private int maxPanelWidth;
    private int totalWidth;
    private JToolBar toolBar;
    private JButton optionsBtn;
    private JPanel popupContent;
    private ButtonPopup popupOptions;
    private JButton borderBtn;
    private JButton alternationBtn;
    private JScrollPane scrollPane;
    private JPanel mainPanel;
    private IPropertyListener listener;
    private Map<String, Boolean> changedOptions;
    private Map<String, JCheckBox> options;

    public PropertiesPanel(boolean enableOptionControl, boolean enableStyleControl) {
        this.enableOptionControl = enableOptionControl;
        this.enableStyleControl = enableStyleControl;
        this.initComponents();
    }

    public PropertiesPanel() {
        this(true, true);
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        if (this.enableOptionControl || this.enableStyleControl) {
            this.add(this.getCtrlPanel(), "North");
        }
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.mainPanel);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.scrollPane.getViewport().setOpaque(false);
        this.add((Component)this.scrollPane, "Center");
    }

    public void setMainPanelBackground(Color clr) {
        this.mainPanel.setBackground(clr);
        this.toolBar.setBackground(clr);
    }

    public void clearPanel() {
        this.mainPanel.removeAll();
        this.displayWidth = this.getWidth() - 15;
        this.maxPanelWidth = 0;
        this.totalWidth = 0;
        this.panels = new ArrayList<Component>();
        this.panelWidths = new ArrayList<Integer>();
    }

    public void setStyleListener(IPropertyListener listener) {
        this.listener = listener;
    }

    public void addPropertyGroupPanel(Component groupPanel) {
        int width = groupPanel.getPreferredSize().width + 5;
        this.panels.add(groupPanel);
        if (width > this.maxPanelWidth) {
            this.maxPanelWidth = width;
        }
        this.panelWidths.add(width);
        this.totalWidth += width;
    }

    public void showError(Throwable caught) {
        String msg = UILabels.STL40001_ERROR_No_DATA.getDescription() + " (" + StringUtils.getErrorMessage(caught) + ")";
        this.showMessage(msg);
    }

    public void showMessage(String message) {
        this.mainPanel.removeAll();
        JLabel label = ComponentFactory.getH2Label(message, 0);
        label.setForeground(UIConstants.INTEL_BLUE);
        this.mainPanel.add(label);
        this.repaint();
        this.revalidate();
    }

    public void setModel(M model) {
        if (this.panels != null) {
            int numCols = this.getColumnNumber();
            int col = 0;
            for (Component panel : this.panels) {
                GridBagConstraints gc;
                if (col >= numCols) {
                    gc = this.createConstraints();
                    gc.weightx = 1.0;
                    gc.gridwidth = 0;
                    this.mainPanel.add(Box.createGlue(), gc);
                    col = 0;
                }
                gc = this.createConstraints();
                gc.weightx = 0.0;
                this.mainPanel.add(panel, gc);
                ++col;
            }
        }
        GridBagConstraints gc = this.createConstraints();
        gc.gridwidth = 0;
        gc.weightx = 1.0;
        this.mainPanel.add(Box.createGlue(), gc);
        gc = this.createConstraints();
        gc.gridwidth = 0;
        gc.weighty = 1.0;
        this.mainPanel.add(Box.createGlue(), gc);
        this.scrollPane.repaint();
        this.scrollPane.revalidate();
        this.panels = null;
    }

    private GridBagConstraints createConstraints() {
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(5, 0, 0, 5);
        gc.fill = 1;
        gc.anchor = 18;
        return gc;
    }

    private int getColumnNumber() {
        int numCols;
        if (this.maxPanelWidth >= this.displayWidth || this.panels.size() == 1) {
            return 1;
        }
        if (this.totalWidth < this.displayWidth) {
            return this.panels.size();
        }
        for (numCols = 2; numCols <= this.panels.size(); ++numCols) {
            int rowWidth = this.getRowWidth(this.panelWidths, numCols);
            if (rowWidth < this.displayWidth) continue;
            --numCols;
            break;
        }
        return numCols;
    }

    private int getRowWidth(List<Integer> widths, int numColumns) {
        int[] colWidth = new int[numColumns];
        int colIndex = 0;
        for (int i = 0; i < widths.size(); ++i) {
            int width = widths.get(i);
            if (width > colWidth[colIndex]) {
                colWidth[colIndex] = width;
            }
            if (++colIndex != numColumns) continue;
            colIndex = 0;
        }
        int rowWidth = 0;
        for (int width : colWidth) {
            rowWidth += width;
        }
        return rowWidth;
    }

    protected Component getCtrlPanel() {
        if (this.toolBar == null) {
            this.toolBar = new JToolBar();
            this.toolBar.setFloatable(false);
            if (this.enableOptionControl) {
                this.addOptionButton();
            }
            if (this.enableStyleControl) {
                this.addStyleButtons();
            }
        }
        return this.toolBar;
    }

    protected void addOptionButton() {
        this.optionsBtn = new JButton(STLConstants.K0210_SHOW_OPTIONS.getValue(), UIImages.OPTIONS_NOTSELECTED_ICON.getImageIcon());
        this.optionsBtn.setFocusable(false);
        this.optionsBtn.setOpaque(false);
        ActionListener usrOptionsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean selected;
                boolean bl = selected = PropertiesPanel.this.optionsBtn.getIcon() == UIImages.OPTIONS_NOTSELECTED_ICON.getImageIcon();
                if (selected) {
                    PropertiesPanel.this.optionsBtn.setIcon(UIImages.NORMAL_ICON.getImageIcon());
                    PropertiesPanel.this.optionsBtn.setText(STLConstants.K0211_APPLY_OPTIONS.getValue());
                    PropertiesPanel.this.popupOptions.show();
                } else {
                    PropertiesPanel.this.optionsBtn.setIcon(UIImages.OPTIONS_NOTSELECTED_ICON.getImageIcon());
                    PropertiesPanel.this.popupOptions.hide();
                    PropertiesPanel.this.optionsBtn.setText(STLConstants.K0210_SHOW_OPTIONS.getValue());
                }
            }
        };
        this.optionsBtn.addActionListener(usrOptionsListener);
        this.toolBar.add(this.optionsBtn);
        this.popupContent = new JPanel();
        this.popupContent.setLayout(new GridBagLayout());
        this.popupContent.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        this.popupOptions = new ButtonPopup(this.optionsBtn, this.popupContent){

            @Override
            public void onShow() {
            }

            @Override
            public void onHide() {
                switch (this.getHideReason()) {
                    case 0: {
                        if (PropertiesPanel.this.listener == null) break;
                        PropertiesPanel.this.listener.onDisplayChanged(PropertiesPanel.this.changedOptions);
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
            }
        };
    }

    protected void addStyleButtons() {
        this.borderBtn = new JButton(STLConstants.K0531_HIDE_BORDER.getValue(), UIImages.HIDE_BORDER.getImageIcon());
        this.borderBtn.setOpaque(false);
        this.borderBtn.setFocusable(false);
        this.borderBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isSelected = PropertiesPanel.this.borderBtn.getIcon() != UIImages.SHOW_BORDER.getImageIcon();
                PropertiesPanel.this.setShowBorder(isSelected);
                if (PropertiesPanel.this.listener != null) {
                    PropertiesPanel.this.listener.onShowBorder(isSelected);
                }
            }
        });
        this.toolBar.add(this.borderBtn);
        this.alternationBtn = new JButton(STLConstants.K0533_UNI_ROWS.getValue(), UIImages.UNI_ROWS.getImageIcon());
        this.alternationBtn.setOpaque(false);
        this.alternationBtn.setFocusable(false);
        this.alternationBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isSelected = PropertiesPanel.this.alternationBtn.getIcon() != UIImages.ALT_ROWS.getImageIcon();
                PropertiesPanel.this.setShowAlternation(isSelected);
                if (PropertiesPanel.this.listener != null) {
                    PropertiesPanel.this.listener.onShowAlternation(isSelected);
                }
            }
        });
        this.toolBar.add(this.alternationBtn);
    }

    protected void setShowBorder(boolean isSelected) {
        if (isSelected) {
            this.borderBtn.setIcon(UIImages.SHOW_BORDER.getImageIcon());
            this.borderBtn.setText(STLConstants.K0530_SHOW_BORDER.getValue());
        } else {
            this.borderBtn.setIcon(UIImages.HIDE_BORDER.getImageIcon());
            this.borderBtn.setText(STLConstants.K0531_HIDE_BORDER.getValue());
        }
    }

    protected void setShowAlternation(boolean isSelected) {
        if (isSelected) {
            this.alternationBtn.setIcon(UIImages.ALT_ROWS.getImageIcon());
            this.alternationBtn.setText(STLConstants.K0532_ALT_ROWS.getValue());
        } else {
            this.alternationBtn.setIcon(UIImages.UNI_ROWS.getImageIcon());
            this.alternationBtn.setText(STLConstants.K0533_UNI_ROWS.getValue());
        }
    }

    public void setInitialStyle(boolean showBorder, boolean showAlternation) {
        this.setShowBorder(showBorder);
        this.setShowAlternation(showAlternation);
    }

    public void initUserSettings(List<PropertyGroup> groups) {
        if (!this.enableOptionControl) {
            return;
        }
        this.options = new HashMap<String, JCheckBox>();
        this.changedOptions = new HashMap<String, Boolean>();
        this.popupContent.removeAll();
        GridBagConstraints gc = this.createConstraints(2, 0, 2, 0);
        gc.gridwidth = 0;
        JPanel panel = new JPanel(new GridLayout(1, 2, 5, 0));
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, UIConstants.INTEL_ORANGE), BorderFactory.createEmptyBorder(2, 2, 4, 2)));
        JButton selectAll = ComponentFactory.getIntelActionButton(STLConstants.K4004_SELECT_ALL.getValue());
        selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Map.Entry option : PropertiesPanel.this.options.entrySet()) {
                    ((JCheckBox)option.getValue()).setSelected(true);
                    PropertiesPanel.this.changedOptions.put(option.getKey(), true);
                }
            }
        });
        panel.add(selectAll);
        JButton unselectAll = ComponentFactory.getIntelActionButton(STLConstants.K4005_UNSELECT_ALL.getValue());
        unselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Map.Entry option : PropertiesPanel.this.options.entrySet()) {
                    ((JCheckBox)option.getValue()).setSelected(false);
                    PropertiesPanel.this.changedOptions.put(option.getKey(), false);
                }
            }
        });
        panel.add(unselectAll);
        this.popupContent.add((Component)panel, gc);
        int row = 1;
        for (PropertyGroup group : groups) {
            JCheckBox box = this.addPropertyGroup(this.popupContent, group, row);
            this.options.put(group.getName(), box);
            ++row;
        }
        gc = this.createConstraints(0, 5, 0, 0);
        gc.fill = 1;
        gc.anchor = 18;
        gc.weightx = 1.0;
        gc.gridwidth = 0;
        this.popupContent.add(Box.createGlue(), gc);
    }

    private GridBagConstraints createConstraints(int yPadTop, int xPadLeft, int yPadBtm, int xPadRight) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 21;
        gc.fill = 2;
        gc.insets = new Insets(yPadTop, xPadLeft, yPadBtm, xPadRight);
        gc.weightx = 1.0;
        return gc;
    }

    private JCheckBox addPropertyGroup(JComponent component, PropertyGroup group, int row) {
        GridBagConstraints gc = this.createConstraints(0, 5, 0, 0);
        gc.gridx = 0;
        gc.gridy = row;
        gc.gridwidth = 2;
        boolean isDisplayed = group.isDisplayed();
        final String groupName = group.getName();
        String title = group.getTitle();
        if (title == null || title.length() == 0) {
            title = PropertyGroupViz.getPropertyGroupViz(groupName).getTitle();
        }
        final JCheckBox checkbox = new JCheckBox(title);
        checkbox.setSelected(isDisplayed);
        checkbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesPanel.this.changedOptions.put(groupName, checkbox.isSelected());
            }
        });
        component.add((Component)checkbox, gc);
        return checkbox;
    }
}

