/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.configuration.view;

import com.intel.stl.ui.common.UIConstants;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class PropertyVizStyle {
    private boolean showBorder;
    private Color borderColor = UIConstants.INTEL_LIGHT_GRAY;
    private boolean alternateRows;
    private Color alternationColor = UIConstants.INTEL_BACKGROUND_GRAY;

    public PropertyVizStyle() {
    }

    public PropertyVizStyle(boolean showBorder, boolean alternateRows) {
        this.showBorder = showBorder;
        this.alternateRows = alternateRows;
    }

    public boolean isShowBorder() {
        return this.showBorder;
    }

    public void setShowBorder(boolean showBorder) {
        this.showBorder = showBorder;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public boolean isAlternatRows() {
        return this.alternateRows;
    }

    public void setAlternateRows(boolean alternateRows) {
        this.alternateRows = alternateRows;
    }

    public Color getAlternationColor() {
        return this.alternationColor;
    }

    public void setAlternationColor(Color alternationColor) {
        this.alternationColor = alternationColor;
    }

    public void decorateKey(JComponent comp, int row) {
        if (this.alternateRows && (row & 1) == 1) {
            comp.setOpaque(true);
            comp.setBackground(this.alternationColor);
        }
        if (this.showBorder) {
            comp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, this.borderColor), comp.getBorder()));
        } else {
            comp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), comp.getBorder()));
        }
    }

    public void decorateValue(JComponent comp, int row) {
        if (this.alternateRows && (row & 1) == 1) {
            comp.setOpaque(true);
            comp.setBackground(this.alternationColor);
        }
        if (this.showBorder) {
            comp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, this.borderColor), comp.getBorder()));
        } else {
            comp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 0, 1, 1), comp.getBorder()));
        }
    }

    public void decorateHeaderKey(JComponent comp, int row) {
        comp.setFont(comp.getFont().deriveFont(1));
    }

    public void decorateHeaderValue(JComponent comp) {
        comp.setFont(comp.getFont().deriveFont(1));
    }

    public String toString() {
        return "PropertyVizStyle [showBorder=" + this.showBorder + ", borderColor=" + this.borderColor + ", alternateRows=" + this.alternateRows + ", alternationColor=" + this.alternationColor + "]";
    }
}

