/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.console;

import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.ui.common.IPageController;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.PageWeight;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.console.IConsoleEventListener;
import com.intel.stl.ui.console.LoginBean;
import com.intel.stl.ui.console.view.ConsoleView;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.HelpAction;
import com.intel.stl.ui.main.view.IFabricView;
import java.awt.Component;
import javax.swing.ImageIcon;
import net.engio.mbassy.bus.MBassador;

public class ConsolePage
implements IPageController {
    private static final int SSH_PORT = 22;
    private final ConsoleView consoleView;
    private String helpID;
    private final IConsoleEventListener dispatchManager;
    private Context context;
    private LoginBean defaultLoginBean;

    public ConsolePage(ConsoleView consoleView, IFabricView owner, IConsoleEventListener dispatchManager, MBassador<IAppEvent> eventBus) {
        this.consoleView = consoleView;
        this.installHelp();
        this.dispatchManager = dispatchManager;
    }

    protected void installHelp() {
        String helpId = this.getHelpID();
        if (helpId != null) {
            this.consoleView.enableHelp(true);
            HelpAction helpAction = HelpAction.getInstance();
            helpAction.getHelpBroker().enableHelpOnButton((Component)this.consoleView.getHelpButton(), helpId, helpAction.getHelpSet());
        } else {
            this.consoleView.enableHelp(false);
        }
    }

    public String getHelpID() {
        return HelpAction.getInstance().getAdminConsole();
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        this.context = context;
        this.dispatchManager.setContext(context, observer);
    }

    @Override
    public void onRefresh(IProgressObserver observer) {
        observer.onFinish();
    }

    @Override
    public String getName() {
        return STLConstants.K2107_ADM_CONSOLE.getValue();
    }

    @Override
    public String getDescription() {
        return STLConstants.K2108_ADM_CONSOLE_DESC.getValue();
    }

    @Override
    public Component getView() {
        return this.consoleView;
    }

    @Override
    public ImageIcon getIcon() {
        return UIImages.CONSOLE_ICON.getImageIcon();
    }

    @Override
    public void cleanup() {
        this.dispatchManager.cleanup();
    }

    @Override
    public void onEnter() {
        if (this.dispatchManager.getNumConsoles(false) <= 0) {
            if (this.context != null) {
                SubnetDescription sd = this.context.getSubnetDescription();
                this.defaultLoginBean = new LoginBean(sd.getCurrentUser(), sd.getCurrentFE().getHost(), String.valueOf(22));
            }
            this.dispatchManager.addNewConsole(this.defaultLoginBean, true, null);
        }
    }

    @Override
    public void onExit() {
    }

    @Override
    public boolean canExit() {
        return true;
    }

    @Override
    public void clear() {
    }

    @Override
    public PageWeight getContextSwitchWeight() {
        return PageWeight.LOW;
    }

    @Override
    public PageWeight getRefreshWeight() {
        return PageWeight.LOW;
    }
}

