/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.console.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.console.IConsoleEventListener;
import com.intel.stl.ui.console.IConsoleLogin;
import com.intel.stl.ui.console.ITabListener;
import com.intel.stl.ui.console.LoginBean;
import com.intel.stl.ui.console.view.IConsoleLoginListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ConsoleLoginView
extends JPanel
implements IConsoleLogin {
    private static final long serialVersionUID = -8589239292130514515L;
    private JTextField txtFldUserName;
    private JPasswordField txtFldPassword;
    private JTextField txtFldHostName;
    private JTextField txtFldPortNum;
    private JTextArea txtAreaStatus;
    private JLabel lblStatusIcon;
    private JButton btnLogin;
    private JButton btnCancel;
    private DocumentListener setDirtyListener;
    private final IConsoleLoginListener loginListener;
    private IConsoleEventListener consoleEventListener;
    private final ITabListener tabListener;
    private LoginBean loginBean;
    private boolean newConsole;
    private int consoleId = 0;

    public ConsoleLoginView(IConsoleLoginListener parentDocListener, ITabListener tabListener) {
        this.loginListener = parentDocListener;
        this.tabListener = tabListener;
        this.createDocumentListener();
        this.initComponents();
    }

    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBackground(UIConstants.INTEL_WHITE);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(STLConstants.K1050_LOGIN.getValue()), BorderFactory.createEmptyBorder(5, 2, 5, 2)));
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(1, 10, 3, 2);
        gc.fill = 2;
        gc.ipadx = 10;
        gc.gridx = 0;
        gc.gridy = 0;
        JLabel lblUserName = ComponentFactory.getH5Label(STLConstants.K0602_USER_NAME.getValue() + ": ", 1);
        lblUserName.setHorizontalAlignment(4);
        this.add((Component)lblUserName, gc);
        gc.insets = new Insets(2, 2, 2, 2);
        gc.weightx = 1.0;
        ++gc.gridx;
        gc.gridy = 0;
        this.txtFldUserName = ComponentFactory.createTextField(null, true, 40, this.setDirtyListener);
        this.txtFldUserName.setColumns(10);
        this.txtFldUserName.setName(WidgetName.ADMIN_CONSOLE_LOGIN_USERNAME.name());
        this.add((Component)this.txtFldUserName, gc);
        gc.insets = new Insets(1, 3, 3, 2);
        gc.weightx = 0.0;
        ++gc.gridx;
        gc.gridy = 0;
        JLabel lblHostName = ComponentFactory.getH5Label(STLConstants.K0051_HOST.getValue() + ": ", 1);
        lblHostName.setHorizontalAlignment(4);
        this.add((Component)lblHostName, gc);
        gc.insets = new Insets(2, 2, 2, 2);
        gc.weightx = 1.0;
        ++gc.gridx;
        gc.gridy = 0;
        this.txtFldHostName = ComponentFactory.createTextField(null, true, 100, this.setDirtyListener);
        this.txtFldHostName.setColumns(10);
        this.txtFldHostName.setName(WidgetName.ADMIN_CONSOLE_LOGIN_HOST.name());
        this.add((Component)this.txtFldHostName, gc);
        gc.insets = new Insets(1, 15, 3, 2);
        gc.weightx = 0.0;
        ++gc.gridx;
        gc.gridy = 0;
        this.btnLogin = ComponentFactory.getIntelActionButton(STLConstants.K1050_LOGIN.getValue());
        this.btnLogin.setEnabled(true);
        this.btnLogin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleLoginView.this.onLogin();
            }
        });
        this.btnLogin.setName(WidgetName.ADMIN_CONSOLE_LOGIN_BUTTON.name());
        this.add((Component)this.btnLogin, gc);
        gc.insets = new Insets(2, 10, 2, 2);
        gc.gridx = 0;
        gc.gridy = 1;
        JLabel lblPasswordName = ComponentFactory.getH5Label(STLConstants.K1049_PASSWORD.getValue() + ": ", 1);
        lblPasswordName.setHorizontalAlignment(4);
        this.add((Component)lblPasswordName, gc);
        gc.insets = new Insets(2, 2, 2, 2);
        gc.weightx = 1.0;
        ++gc.gridx;
        gc.gridy = 1;
        this.txtFldPassword = ComponentFactory.createPasswordField(this.setDirtyListener);
        this.txtFldPassword.setInputVerifier(null);
        this.txtFldPassword.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    ConsoleLoginView.this.onLogin();
                }
            }
        });
        this.txtFldPassword.setName(WidgetName.ADMIN_CONSOLE_LOGIN_PASSWORD.name());
        this.add((Component)this.txtFldPassword, gc);
        gc.insets = new Insets(2, 3, 2, 2);
        gc.weightx = 0.0;
        ++gc.gridx;
        gc.gridy = 1;
        JLabel lblPortNum = ComponentFactory.getH5Label(STLConstants.K1035_CONFIGURATION_PORT.getValue() + ": ", 1);
        lblPortNum.setHorizontalAlignment(4);
        this.add((Component)lblPortNum, gc);
        gc.insets = new Insets(2, 2, 2, 2);
        gc.weightx = 1.0;
        ++gc.gridx;
        gc.gridy = 1;
        this.txtFldPortNum = ComponentFactory.createNumericTextField(65535, this.setDirtyListener);
        this.txtFldPortNum.setName(WidgetName.ADMIN_CONSOLE_LOGIN_PORT.name());
        this.add((Component)this.txtFldPortNum, gc);
        gc.insets = new Insets(2, 15, 2, 2);
        gc.weightx = 0.0;
        ++gc.gridx;
        gc.gridy = 1;
        this.btnCancel = ComponentFactory.getIntelActionButton(STLConstants.K0621_CANCEL.getValue());
        this.btnCancel.setEnabled(true);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConsoleLoginView.this.newConsole) {
                    ConsoleLoginView.this.tabListener.closeConsole(ConsoleLoginView.this.tabListener.getCurrentTabView());
                }
                ConsoleLoginView.this.killProgress();
                ConsoleLoginView.this.hideLogin();
                ConsoleLoginView.this.setDirty();
                ConsoleLoginView.this.loginListener.enableLock(false);
                ConsoleLoginView.this.setVisible(false);
            }
        });
        this.btnCancel.setName(WidgetName.ADMIN_CONSOLE_CANCEL_BUTTON.name());
        this.add((Component)this.btnCancel, gc);
        gc.insets = new Insets(2, 10, 2, 2);
        gc.gridx = 0;
        gc.gridy = 2;
        this.lblStatusIcon = new JLabel();
        this.lblStatusIcon.setIcon(UIImages.RUNNING.getImageIcon());
        this.lblStatusIcon.setVisible(false);
        this.lblStatusIcon.setName(WidgetName.ADMIN_CONSOLE_LOGIN_STATUS_ICON.name());
        this.add((Component)this.lblStatusIcon, gc);
        gc.insets = new Insets(2, 2, 2, 2);
        gc.weightx = 1.0;
        gc.gridy = 2;
        gc.gridwidth = 0;
        this.txtAreaStatus = new JTextArea();
        this.txtAreaStatus.setLineWrap(true);
        this.txtAreaStatus.setWrapStyleWord(true);
        this.txtAreaStatus.setOpaque(true);
        this.txtAreaStatus.setEditable(false);
        this.txtAreaStatus.setFont(UIConstants.H5_FONT);
        this.txtAreaStatus.setForeground(UIConstants.INTEL_DARK_GRAY);
        this.txtAreaStatus.setBackground(UIConstants.INTEL_BACKGROUND_GRAY);
        this.txtAreaStatus.setPreferredSize(new Dimension(1, 40));
        this.txtAreaStatus.setName(WidgetName.ADMIN_CONSOLE_LOGIN_TEXT_AREA.name());
        this.add((Component)this.txtAreaStatus, gc);
    }

    public void createDocumentListener() {
        this.setDirtyListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ConsoleLoginView.this.setDirty();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ConsoleLoginView.this.setDirty();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ConsoleLoginView.this.setDirty();
            }
        };
    }

    protected void onLogin() {
        this.txtAreaStatus.setText("");
        this.txtAreaStatus.setToolTipText(null);
        LoginBean loginBean = new LoginBean();
        loginBean.setUserName(this.getUserName());
        loginBean.setPassword(this.getPassword());
        loginBean.setHostName(this.getHostName());
        loginBean.setPortNum(this.getPortNum());
        this.startProgress();
        if (this.newConsole) {
            int id = this.consoleId;
            this.consoleEventListener.initializeConsoleThread(id, loginBean, null);
        } else if (this.consoleId > 0) {
            this.consoleEventListener.onUnlockThread(this.consoleId, this.getPassword());
        }
    }

    public LoginBean getLoginBean() {
        return this.loginBean;
    }

    public void setLoginBean(LoginBean loginBean) {
        this.loginBean = loginBean;
    }

    @Override
    public void showLogin(LoginBean loginBean) {
        if (loginBean != null) {
            this.setLoginBean(loginBean);
            this.txtFldHostName.setText(loginBean.getHostName());
            this.txtFldPortNum.setText(loginBean.getPortNum());
        }
        if (this.getUserName().length() == 0) {
            this.txtFldUserName.requestFocus();
        } else if (this.getPassword().length == 0) {
            this.txtFldPassword.requestFocus();
        } else if (this.getHostName().length() == 0) {
            this.txtFldHostName.requestFocus();
        } else if (this.getPortNum().length() == 0) {
            this.txtFldPortNum.requestFocus();
        }
        this.setVisible(true);
        this.setDirty();
    }

    @Override
    public void showLogin(LoginBean loginBean, boolean newConsole, int consoleId) {
        this.newConsole = newConsole;
        this.consoleId = consoleId;
        if (newConsole) {
            this.txtFldUserName.setEnabled(true);
            this.txtFldPassword.setEnabled(true);
            this.txtFldHostName.setEnabled(true);
            this.txtFldPortNum.setEnabled(true);
        } else {
            this.txtFldUserName.setEnabled(false);
            this.txtFldPassword.setEnabled(true);
            this.txtFldHostName.setEnabled(false);
            this.txtFldPortNum.setEnabled(false);
        }
        this.showLogin(loginBean);
    }

    @Override
    public void hideLogin() {
        Runnable hideIt = new Runnable(){

            @Override
            public void run() {
                ConsoleLoginView.this.txtFldPassword.getDocument().removeDocumentListener(ConsoleLoginView.this.setDirtyListener);
                ConsoleLoginView.this.txtFldPassword.setText("");
                ConsoleLoginView.this.txtFldPassword.getDocument().addDocumentListener(ConsoleLoginView.this.setDirtyListener);
                if (ConsoleLoginView.this.isVisible()) {
                    ConsoleLoginView.this.setVisible(false);
                }
            }
        };
        Util.runInEDT(hideIt);
    }

    @Override
    public void showMessage(String message) {
        this.txtAreaStatus.setText(message);
        this.txtAreaStatus.setToolTipText(message);
    }

    protected void setDirty() {
        this.killProgress();
        if (this.txtAreaStatus != null) {
            this.showMessage(null);
        }
        if (this.getHostName().length() > 0 && this.getPortNum().length() > 0) {
            this.btnLogin.setEnabled(true);
        } else {
            this.btnLogin.setEnabled(false);
        }
        this.loginListener.updateUIComponents(this.btnLogin.isEnabled());
    }

    @Override
    public void startProgress() {
        this.lblStatusIcon.setVisible(true);
    }

    @Override
    public void killProgress() {
        this.lblStatusIcon.setVisible(false);
    }

    @Override
    public String getUserName() {
        return this.txtFldUserName.getText();
    }

    @Override
    public char[] getPassword() {
        return this.txtFldPassword.getPassword();
    }

    @Override
    public String getHostName() {
        return this.txtFldHostName.getText();
    }

    @Override
    public String getPortNum() {
        return this.txtFldPortNum.getText();
    }

    @Override
    public void setConsoleEventListener(IConsoleEventListener consoleEventListener) {
        this.consoleEventListener = consoleEventListener;
    }
}

