/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.console.view;

import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.console.IConsoleListener;
import com.intel.stl.ui.console.ITabListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConsoleTabView
extends JPanel {
    private static final long serialVersionUID = -4025941288575285019L;
    private static final byte USER_NAME_IDX = 0;
    private static final byte COMMAND_NAME_IDX = 1;
    private JLabel lblCloseTab;
    private JLabel lblUserName;
    private JLabel lblCommandName;
    private final String[] tabNames;
    private ITabListener tabListener;
    private int tabIndex;
    private final int consoleId;
    private IConsoleListener consoleListener;
    private final ConsoleTabView tabView = this;

    public ConsoleTabView(int tabIndex, String[] tabNames, int consoleId) {
        this.tabIndex = tabIndex;
        this.tabNames = tabNames;
        this.consoleId = consoleId;
        this.initComponent();
    }

    protected void initComponent() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        this.lblUserName = ComponentFactory.getH4Label("", 0);
        this.lblCloseTab = new JLabel(UIImages.CLOSE_GRAY.getImageIcon());
        this.lblCloseTab.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 2, 0, 0, UIConstants.INTEL_BORDER_GRAY), BorderFactory.createEmptyBorder(0, 5, 0, 0)));
        this.lblCommandName = ComponentFactory.getH4Label("", 0);
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(1, 2, 1, 2);
        gc.fill = 1;
        gc.gridx = 0;
        gc.gridy = 0;
        this.add((Component)this.lblUserName, gc);
        gc.gridx = 1;
        gc.gridheight = 2;
        gc.weighty = 1.0;
        gc.insets = new Insets(1, 2, 1, 2);
        this.add((Component)this.lblCloseTab, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.weighty = 0.0;
        gc.insets = new Insets(1, 2, 1, 2);
        this.add((Component)this.lblCommandName, gc);
        this.setUserName(this.tabNames[0]);
        this.setCommandName(this.tabNames[1]);
    }

    public void addConsoleListener(IConsoleListener listener) {
        this.consoleListener = listener;
    }

    public void addTabListener(ITabListener listener) {
        this.tabListener = listener;
        this.lblCloseTab.addMouseListener(new MouseAdapter(){
            private Icon oldIcon;

            @Override
            public void mouseClicked(MouseEvent e) {
                Runnable runit = new Runnable(){

                    @Override
                    public void run() {
                        ConsoleTabView.this.tabListener.closeConsole(ConsoleTabView.this.tabView);
                    }
                };
                runit.run();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.oldIcon = ConsoleTabView.this.lblCloseTab.getIcon();
                ConsoleTabView.this.lblCloseTab.setIcon(UIImages.CLOSE_RED.getImageIcon());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ConsoleTabView.this.lblCloseTab.setIcon(this.oldIcon);
            }
        });
    }

    public JPanel getMainComponent() {
        return this;
    }

    public String getUserName() {
        return this.lblUserName.getText();
    }

    public void setUserName(String userName) {
        this.lblUserName.setText(userName);
    }

    public String getCommandName() {
        return this.lblCommandName.getText();
    }

    public void setCommandName(String command) {
        this.lblCommandName.setText(this.getCommandName(command));
    }

    protected String getCommandName(String cmd) {
        if (cmd == null) {
            return "";
        }
        int pos = cmd.indexOf(32);
        if (pos >= 0) {
            return cmd.substring(0, pos);
        }
        return cmd;
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public void setTabIndex(int index) {
        this.tabIndex = index;
    }

    public int getConsoleId() {
        return this.consoleId;
    }

    public void setLabelProperties(boolean highlight) {
        if (highlight) {
            this.lblUserName.setBackground(UIConstants.INTEL_WHITE);
            this.lblUserName.setForeground(UIConstants.INTEL_DARK_GRAY);
            this.lblCloseTab.setIcon(UIImages.CLOSE_GRAY.getImageIcon());
            this.lblCommandName.setBackground(UIConstants.INTEL_WHITE);
            this.lblCommandName.setForeground(UIConstants.INTEL_DARK_GRAY);
        } else {
            this.lblUserName.setBackground(UIConstants.INTEL_BLUE);
            this.lblUserName.setForeground(UIConstants.INTEL_WHITE);
            this.lblCloseTab.setIcon(UIImages.CLOSE_WHITE.getImageIcon());
            this.lblCommandName.setBackground(UIConstants.INTEL_BLUE);
            this.lblCommandName.setForeground(UIConstants.INTEL_WHITE);
        }
    }
}

