/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.console.view;

import com.intel.stl.ui.console.IConsole;
import com.intel.stl.ui.console.IConsoleListener;
import com.intel.stl.ui.console.ITty;
import com.intel.stl.ui.console.IntelEmulator;
import com.intel.stl.ui.console.view.IntelTerminalPanel;
import com.wittams.gritty.BackBuffer;
import com.wittams.gritty.Emulator;
import com.wittams.gritty.RequestOrigin;
import com.wittams.gritty.ScrollBuffer;
import com.wittams.gritty.StyleState;
import com.wittams.gritty.TerminalDisplay;
import com.wittams.gritty.TerminalWriter;
import com.wittams.gritty.Tty;
import com.wittams.gritty.TtyChannel;
import com.wittams.gritty.swing.ConnectedKeyHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntelTerminalView
extends JPanel {
    private static final Logger termLogger = LoggerFactory.getLogger(IntelTerminalView.class);
    private static final long serialVersionUID = -8213232075937432833L;
    private final String reportsCommand = "iba_report -o ";
    private final String reportsString = "iba_report -reporttypes ";
    private final StyleState styleState;
    private final BackBuffer backBuffer;
    private final ScrollBuffer scrollBuffer;
    private final IntelTerminalPanel termPanel;
    private final JScrollBar scrollBar;
    private ITty tty;
    private TtyChannel ttyChannel;
    private final TerminalWriter terminalWriter;
    private Emulator emulator;
    private Thread emuThread;
    private final List<String> topicIdList;
    private final AtomicBoolean sessionRunning = new AtomicBoolean();
    private final IConsoleListener consoleListener;
    private String command = new String("");

    public IntelTerminalView(IConsoleListener consoleListener, List<String> topicIdList, IConsole consoleController) {
        super(new BorderLayout());
        this.consoleListener = consoleListener;
        this.topicIdList = topicIdList;
        this.styleState = new StyleState();
        this.backBuffer = new BackBuffer(80, 24, this.styleState);
        this.scrollBuffer = new ScrollBuffer();
        this.termPanel = new IntelTerminalPanel(this.backBuffer, this.scrollBuffer, this.styleState, consoleListener.getHelpController(), consoleController);
        this.termPanel.setCursor(0, 0);
        this.terminalWriter = new TerminalWriter((TerminalDisplay)this.termPanel, this.backBuffer, this.styleState);
        this.scrollBar = new JScrollBar();
        this.add((Component)((Object)this.termPanel), "Center");
        this.add((Component)this.scrollBar, "East");
        this.scrollBar.setModel(this.termPanel.getBoundedRangeModel());
        this.sessionRunning.set(false);
    }

    public void updateTermPanelDimensions(Dimension mainPanelSize) {
        Dimension charSize = new Dimension();
        charSize.width = this.termPanel.getPixelWidth() / this.termPanel.getColumnCount();
        charSize.height = this.termPanel.getPixelHeight() / this.termPanel.getRowCount();
        Dimension termSize = new Dimension();
        termSize.width = mainPanelSize.width * 2 / charSize.width;
        termSize.height = mainPanelSize.height * 2 / charSize.height;
        this.termPanel.doResize(termSize, RequestOrigin.User);
    }

    public IntelTerminalPanel getTermPanel() {
        return this.termPanel;
    }

    public JScrollBar getScrollBar() {
        return this.scrollBar;
    }

    public void setTty(ITty tty) {
        this.tty = tty;
        this.ttyChannel = new TtyChannel((Tty)tty);
        this.emulator = new IntelEmulator(this.terminalWriter, this.ttyChannel);
        this.termPanel.setEmulator(this.emulator);
    }

    public void start() {
        if (!this.sessionRunning.get()) {
            this.emuThread = new Thread(new EmulatorTask());
            this.emuThread.start();
        } else {
            termLogger.error("Should not try to start session again at this point... ");
        }
    }

    public void stop() {
        if (this.sessionRunning.get() && this.emuThread != null) {
            this.emuThread.interrupt();
        }
    }

    public boolean isSessionRunning() {
        return this.sessionRunning.get();
    }

    protected ConnectedKeyHandler createKeyHandler(final Emulator emulator) {
        ConnectedKeyHandler keyHandler = new ConnectedKeyHandler(emulator){

            public void keyPressed(KeyEvent e) {
                try {
                    char keychar = e.getKeyChar();
                    byte[] obuffer = new byte[1];
                    int keycode = e.getKeyCode();
                    byte[] code = emulator.getCode(keycode);
                    if (code != null) {
                        emulator.sendBytes(code);
                    } else if ((keychar & 0xFF00) == 0) {
                        obuffer[0] = (byte)e.getKeyChar();
                        emulator.sendBytes(obuffer);
                    }
                    IntelTerminalView.this.processCommand(keychar, e.getKeyCode(), obuffer);
                }
                catch (IOException ex) {
                    termLogger.error("Error sending key to emulator", (Throwable)ex);
                }
            }

            public void keyTyped(KeyEvent e) {
                char keychar = e.getKeyChar();
                if ((keychar & 0xFF00) != 0) {
                    char[] foo = new char[]{keychar};
                    try {
                        byte[] bytes = new String(foo).getBytes("EUC-JP");
                        emulator.sendBytes(bytes);
                        IntelTerminalView.this.processCommand(keychar, e.getKeyCode(), bytes);
                    }
                    catch (IOException ex) {
                        termLogger.error("Error sending key to emulator", (Throwable)ex);
                    }
                }
            }
        };
        return keyHandler;
    }

    protected void processCommand(char keyChar, int keyCode, byte[] buf) {
        this.command = this.filterCommand(keyChar, keyCode, buf);
        this.consoleListener.getHelpController().parseCommand(this.command);
        if (this.command.split(" ").length > 0) {
            this.consoleListener.getHelpController().updateSelection(this.command.split(" ")[0]);
        }
    }

    protected String filterCommand(char keyChar, int keyCode, byte[] buf) {
        if ('\u001f' < keyChar && keyChar < '\u007f') {
            this.command = this.command + keyChar;
        }
        switch (keyCode) {
            case 8: {
                if (this.command.length() <= 0) break;
                if (this.command.startsWith("iba_report -reporttypes ")) {
                    this.command = this.command.replaceFirst("iba_report -reporttypes ", "iba_report -o ");
                }
                this.command = this.command.substring(0, this.command.length() - 1);
                break;
            }
            case 127: {
                break;
            }
            case 10: {
                this.command = "";
                this.consoleListener.getHelpController().parseCommand("toc");
                this.consoleListener.getHelpController().updateSelection(this.command);
                break;
            }
        }
        if (this.command.startsWith("iba_report -o ")) {
            this.command = this.command.replaceFirst("iba_report -o ", "iba_report -reporttypes ");
        }
        return this.command;
    }

    public String getBufferText(BufferType type) {
        return type.getValue(this);
    }

    public void setTerminalCursor(Point position) {
        this.termPanel.setCursor(position.x, position.y);
    }

    public void enableKeyHandler(boolean enable) {
        this.termPanel.enableKeyHandler(enable);
    }

    public List<String> getTopicIdList() {
        return this.topicIdList;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.termPanel.getPixelWidth() + this.scrollBar.getPreferredSize().width, this.termPanel.getPixelHeight());
    }

    public void sendCommand(String string) throws IOException {
        this.emulator.sendBytes(string.getBytes());
    }

    @Override
    public boolean requestFocusInWindow() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IntelTerminalView.this.termPanel.requestFocusInWindow();
            }
        });
        return super.requestFocusInWindow();
    }

    class EmulatorTask
    implements Runnable {
        EmulatorTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.currentThread().setName(IntelTerminalView.this.tty.getName());
                if (IntelTerminalView.this.tty.initialize()) {
                    Thread.currentThread().setName(IntelTerminalView.this.tty.getName());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            IntelTerminalView.this.termPanel.setKeyHandler((KeyListener)IntelTerminalView.this.createKeyHandler(IntelTerminalView.this.emulator));
                            IntelTerminalView.this.termPanel.requestFocusInWindow();
                        }
                    });
                    IntelTerminalView.this.sessionRunning.set(true);
                    IntelTerminalView.this.consoleListener.onConnect(IntelTerminalView.this.sessionRunning.get());
                    IntelTerminalView.this.emulator.start();
                }
            }
            catch (Exception e) {
                IntelTerminalView.this.consoleListener.onConnectFail(e);
            }
            finally {
                IntelTerminalView.this.sessionRunning.set(false);
                IntelTerminalView.this.consoleListener.terminalStopped();
            }
        }
    }

    public static enum BufferType {
        Back{

            @Override
            String getValue(IntelTerminalView term) {
                return term.getTermPanel().getBackBuffer().getLines();
            }
        }
        ,
        BackStyle{

            @Override
            String getValue(IntelTerminalView term) {
                return term.getTermPanel().getBackBuffer().getStyleLines();
            }
        }
        ,
        Damage{

            @Override
            String getValue(IntelTerminalView term) {
                return term.getTermPanel().getBackBuffer().getDamageLines();
            }
        }
        ,
        Scroll{

            @Override
            String getValue(IntelTerminalView term) {
                return term.getTermPanel().getScrollBuffer().getLines();
            }
        };


        abstract String getValue(IntelTerminalView var1);
    }
}

