/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.email.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.email.IEmailController;
import com.intel.stl.ui.main.view.FVMainFrame;
import com.intel.stl.ui.main.view.IFabricView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EmailSettingsView
extends JDialog
implements DocumentListener {
    private static final long serialVersionUID = 450669593032341011L;
    private boolean dirty = false;
    private JButton okBtn;
    private JButton cancelBtn;
    private JButton resetBtn;
    private JButton testBtn;
    private JTextArea messageArea;
    private final JTextField serverNameTxtField = ComponentFactory.createTextField(null, true, 100, this);
    private final JTextField serverPortTxtField = ComponentFactory.createTextField("0123456789", false, 5, this);
    private final JTextField fromAddrTxtField = ComponentFactory.createTextField(null, true, 100, this);
    private final JTextField testAddressTxtField = ComponentFactory.createTextField(null, true, 100, this);
    private IEmailController listener;
    private JCheckBox enableEmailFeature;
    private final String helpTextStr = STLConstants.K5014_EMAIL_HINT_TEXT.getValue();
    private final String helpTooltipStr = STLConstants.K5015_EMAIL_TOOLTIP_HINT_TEXT.getValue();
    private final Color disabledTextColor = UIConstants.INTEL_GRAY;
    private final Color enabledTextColor = Color.black;

    public EmailSettingsView(IFabricView owner) {
        super((JFrame)((Object)owner));
        this.setTitle(STLConstants.K5010_EMAIL_SETTINGS_TITLE.getValue());
        this.setModal(true);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.pack();
        this.setPreferredSize(new Dimension(500, (int)this.getPreferredSize().getHeight()));
        this.pack();
        this.setLocationRelativeTo((Component)((Object)owner));
    }

    private void initComponents() {
        this.addSettingsPanel();
        this.addButtonsPanel();
    }

    private void addSettingsPanel() {
        JPanel settingsPanel = new JPanel(new GridBagLayout());
        settingsPanel.setBackground(UIConstants.INTEL_WHITE);
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.insets = new Insets(10, 10, 10, 10);
        gc.fill = 2;
        this.enableEmailFeature = ComponentFactory.getIntelCheckBox(STLConstants.K5012_EMAIL_ENABLE_OPTION_TXT.getValue());
        this.enableEmailFeature.setName(WidgetName.ES_ENABLE_NOTIFICATION.name());
        this.enableEmailFeature.setFont(UIConstants.H5_FONT.deriveFont(1));
        this.enableEmailFeature.setForeground(UIConstants.INTEL_DARK_GRAY);
        this.enableEmailFeature.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EmailSettingsView.this.dirty = true;
                EmailSettingsView.this.setComponentsEnabled(e.getStateChange() == 1);
                EmailSettingsView.this.updateMessageArea();
            }
        });
        gc.gridwidth = 0;
        settingsPanel.add((Component)this.enableEmailFeature, gc);
        ++gc.gridy;
        gc.weightx = 0.1;
        gc.gridwidth = 1;
        JLabel smtpNameLbl = ComponentFactory.getH5Label(STLConstants.K5002_SMTP_HOST.getValue() + " :", 1);
        smtpNameLbl.setHorizontalAlignment(4);
        settingsPanel.add((Component)smtpNameLbl, gc);
        gc.gridx = 1;
        gc.weightx = 0.6;
        gc.gridwidth = 0;
        this.serverNameTxtField.setName(WidgetName.ES_SMTP_HOST.name());
        this.serverNameTxtField.setText("");
        settingsPanel.add((Component)this.serverNameTxtField, gc);
        ++gc.gridy;
        gc.gridx = 0;
        gc.weightx = 0.1;
        gc.gridwidth = 1;
        JLabel smtpPortLbl = ComponentFactory.getH5Label(STLConstants.K0404_PORT_NUMBER.getValue() + " :", 1);
        smtpPortLbl.setHorizontalAlignment(4);
        settingsPanel.add((Component)smtpPortLbl, gc);
        gc.gridx = 1;
        gc.weightx = 0.6;
        gc.gridwidth = 0;
        this.serverPortTxtField.setName(WidgetName.ES_SMTP_PORT.name());
        this.serverPortTxtField.setText("25");
        settingsPanel.add((Component)this.serverPortTxtField, gc);
        ++gc.gridy;
        gc.gridx = 0;
        gc.weightx = 0.1;
        gc.gridwidth = 1;
        JLabel senderLbl = ComponentFactory.getH5Label(STLConstants.K5003_FROM_LBL.getValue() + ":", 1);
        senderLbl.setHorizontalAlignment(4);
        settingsPanel.add((Component)senderLbl, gc);
        gc.gridx = 1;
        gc.weightx = 0.6;
        gc.gridwidth = 0;
        this.fromAddrTxtField.setName(WidgetName.ES_SENDER.name());
        this.fromAddrTxtField.setText(this.helpTextStr);
        this.fromAddrTxtField.setToolTipText(this.helpTooltipStr);
        this.fromAddrTxtField.setForeground(this.disabledTextColor);
        this.fromAddrTxtField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent fEvt) {
                if (EmailSettingsView.this.fromAddrTxtField.getText().equalsIgnoreCase(EmailSettingsView.this.helpTextStr) && EmailSettingsView.this.enableEmailFeature.isSelected()) {
                    EmailSettingsView.this.fromAddrTxtField.setText("");
                    EmailSettingsView.this.fromAddrTxtField.setForeground(EmailSettingsView.this.enabledTextColor);
                }
            }

            @Override
            public void focusLost(FocusEvent fEvt) {
                if (EmailSettingsView.this.fromAddrTxtField.getText().trim().isEmpty() && EmailSettingsView.this.enableEmailFeature.isSelected()) {
                    EmailSettingsView.this.fromAddrTxtField.setText(EmailSettingsView.this.helpTextStr);
                    EmailSettingsView.this.fromAddrTxtField.setForeground(EmailSettingsView.this.disabledTextColor);
                }
            }
        });
        settingsPanel.add((Component)this.fromAddrTxtField, gc);
        JPanel testPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        testPanel.setBackground(UIConstants.INTEL_WHITE);
        testPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIConstants.INTEL_BORDER_GRAY, 2), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(10, 10, 10, 10);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        this.messageArea = new JTextArea();
        this.messageArea.setText(STLConstants.K5011_EMAIL_TEST_HELP_MSG.getValue());
        this.messageArea.setWrapStyleWord(true);
        this.messageArea.setLineWrap(true);
        this.messageArea.setEditable(false);
        this.messageArea.setFocusable(false);
        this.messageArea.setFont(UIConstants.H5_FONT.deriveFont(1));
        this.messageArea.setForeground(UIConstants.INTEL_DARK_GRAY);
        Util.makeUndoable(this.messageArea);
        testPanel.add((Component)this.messageArea, gbc);
        gbc.gridy = 1;
        gbc.weightx = 0.6;
        gbc.gridwidth = 2;
        this.testAddressTxtField.setName(WidgetName.ES_RECEIVERS.name());
        this.testAddressTxtField.setToolTipText(this.helpTooltipStr);
        testPanel.add((Component)this.testAddressTxtField, gbc);
        gbc.gridx = 3;
        gbc.weightx = 0.1;
        gbc.gridwidth = 1;
        this.testBtn = ComponentFactory.getIntelActionButton(STLConstants.K5009_WIZARD_EMAIL_TEST_LABEL_TEXT.getValue());
        this.testBtn.setName(WidgetName.ES_TEST.name());
        this.testBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmailSettingsView.this.testBtnAction();
            }
        });
        this.testBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                EmailSettingsView.this.testBtn.requestFocusInWindow();
            }
        });
        this.testBtn.setEnabled(false);
        this.testBtn.setToolTipText(STLConstants.K5016_EMAIL_TEST_BTN_TOOLTIP_TEXT.getValue());
        testPanel.add((Component)this.testBtn, gbc);
        ++gc.gridy;
        gc.gridx = 0;
        gc.weightx = 3.0;
        gc.gridwidth = 0;
        settingsPanel.add((Component)testPanel, gc);
        this.getContentPane().add((Component)settingsPanel, "Center");
    }

    private void addButtonsPanel() {
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        buttonsPanel.setBackground(UIConstants.INTEL_WHITE);
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 20, 10));
        this.okBtn = ComponentFactory.getIntelActionButton(STLConstants.K0645_OK.getValue());
        this.okBtn.setName(WidgetName.ES_OK.name());
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmailSettingsView.this.okBtnAction();
            }
        });
        this.okBtn.setEnabled(false);
        this.cancelBtn = ComponentFactory.getIntelActionButton(STLConstants.K0621_CANCEL.getValue());
        this.cancelBtn.setName(WidgetName.ES_CANCEL.name());
        this.getRootPane().setDefaultButton(this.cancelBtn);
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmailSettingsView.this.cancelBtnAction();
            }
        });
        this.resetBtn = ComponentFactory.getIntelActionButton("Reset");
        this.resetBtn.setName(WidgetName.ES_RESET.name());
        this.resetBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmailSettingsView.this.resetBtnAction();
            }
        });
        JButton[] btnGroup = new JButton[]{this.resetBtn, this.cancelBtn, this.okBtn, this.testBtn};
        ComponentFactory.makeSameWidthButtons(btnGroup);
        buttonsPanel.add(this.resetBtn);
        buttonsPanel.add(Box.createGlue());
        buttonsPanel.add(this.cancelBtn);
        buttonsPanel.add(Box.createHorizontalStrut(10));
        buttonsPanel.add(this.okBtn);
        this.getContentPane().add((Component)buttonsPanel, "South");
    }

    private void okBtnAction() {
        if (this.dirty) {
            this.listener.onOK();
        }
        this.setVisible(false);
    }

    private void cancelBtnAction() {
        this.updateMessageArea();
        this.setVisible(false);
    }

    @Override
    public void setVisible(boolean visible) {
        this.resetBtnAction();
        super.setVisible(visible);
        this.setLocationRelativeTo(this.getParent());
        if (visible) {
            this.setAlwaysOnTop(true);
        }
    }

    private void resetBtnAction() {
        this.listener.onReset();
        this.okBtn.setEnabled(false);
        this.getRootPane().setDefaultButton(this.cancelBtn);
        this.dirty = false;
        this.updateMessageArea();
    }

    private void testBtnAction() {
        this.listener.onTest();
    }

    public void setEmailSettingsListener(IEmailController listener) {
        this.listener = listener;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateValues();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateValues();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateValues();
    }

    private void updateValues() {
        if (this.isVisible()) {
            this.updateMessageArea();
            this.testBtn.setEnabled(this.isReadyToTest());
            this.dirty = true;
            this.makeOkBtnDefault();
        }
    }

    private void updateMessageArea() {
        if (this.messageArea.getText() != STLConstants.K5011_EMAIL_TEST_HELP_MSG.getValue()) {
            this.messageArea.setText(STLConstants.K5011_EMAIL_TEST_HELP_MSG.getValue());
        }
    }

    private void makeOkBtnDefault() {
        this.okBtn.setEnabled(true);
        this.getRootPane().setDefaultButton(this.okBtn);
    }

    public String getSmtpServerNameStr() {
        return this.serverNameTxtField.getText();
    }

    public String getSmtpServerPortStr() {
        return this.serverPortTxtField.getText();
    }

    public String getFromAddrStr() {
        if (this.fromAddrTxtField.getText().trim().equalsIgnoreCase(this.helpTextStr)) {
            return "";
        }
        return this.fromAddrTxtField.getText();
    }

    public String getToAddrStr() {
        return this.testAddressTxtField.getText();
    }

    public boolean getEnableEmail() {
        return this.enableEmailFeature.isSelected();
    }

    public void setSmtpServerNameStr(String serverName) {
        this.serverNameTxtField.setText(serverName);
    }

    public void setSmtpServerPortStr(String serverPort) {
        this.serverPortTxtField.setText(serverPort);
    }

    public void setFromAddrStr(String fromAddr) {
        if (fromAddr.trim().equals("")) {
            this.fromAddrTxtField.setText(this.helpTextStr);
            this.fromAddrTxtField.setForeground(this.disabledTextColor);
        } else {
            this.fromAddrTxtField.setText(fromAddr);
            this.fromAddrTxtField.setForeground(this.enabledTextColor);
        }
    }

    public void setToAddrStr(String toAddr) {
        this.testAddressTxtField.setText(toAddr);
    }

    public void setEnableEmailChkbox(boolean isEnabled) {
        this.enableEmailFeature.setSelected(isEnabled);
        this.setComponentsEnabled(isEnabled);
    }

    public void setOwner(FVMainFrame owner) {
        this.setLocationRelativeTo(owner);
    }

    private boolean isReadyToTest() {
        boolean canTest = false;
        if (this.isVisible()) {
            boolean isFromTxtValid = this.listener.isEmailValid(this.fromAddrTxtField.getText().trim());
            boolean isTestTxtValid = this.listener.isEmailValid(this.testAddressTxtField.getText().trim());
            if (isFromTxtValid && isTestTxtValid && !this.serverNameTxtField.getText().trim().isEmpty()) {
                canTest = true;
            }
            this.testBtn.setEnabled(canTest);
        }
        return canTest;
    }

    public void setComponentsEnabled(boolean enabled) {
        this.serverNameTxtField.setEnabled(enabled);
        this.serverPortTxtField.setEnabled(enabled);
        this.fromAddrTxtField.setEnabled(enabled);
        if (this.fromAddrTxtField.getText().trim().equalsIgnoreCase(this.helpTextStr)) {
            this.fromAddrTxtField.setForeground(this.disabledTextColor);
        }
        this.testAddressTxtField.setEnabled(enabled);
        this.makeOkBtnDefault();
        this.testBtn.setEnabled(enabled && this.isReadyToTest());
    }

    public void showTesting(boolean isTesting) {
        if (isTesting) {
            this.messageArea.setText(STLConstants.K5017_SENDING_EMAIL.getValue());
            this.testBtn.setEnabled(false);
        } else {
            this.messageArea.setText(STLConstants.K5018_EMAIL_SENT_OUT.getValue());
            this.testBtn.setEnabled(true);
        }
    }
}

