/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.logger.config.view;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.Encoder;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.common.view.ComponentFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.VerticalLayout;
import org.slf4j.LoggerFactory;

class ConversionPatternHelpDialog
extends JDialog {
    private static final long serialVersionUID = 3640306308504496390L;
    private JPanel buttonPannel = null;
    private JScrollPane conversionPatternPanel = null;
    private JPanel previewPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JButton previewButton = null;
    private JPanel parentDialog = null;
    private JTextField previewText = null;
    private JLabel formatString = null;
    private JLabel formatStringLabel = null;
    private JLabel sampleString = null;
    private JLabel sampleStringLabel = null;
    private JTable conversionCharacterTable = null;
    private final String[] heading = new String[]{STLConstants.K0646_CONVERSION_CHARACTER.getValue(), STLConstants.K0647_EFFECT.getValue()};
    private final String[][] data = new String[14][2];
    final Logger logger = (Logger)LoggerFactory.getLogger(ConversionPatternHelpDialog.class);
    final LoggerContext loggerContext = this.logger.getLoggerContext();
    protected AbstractAction okAction = new AbstractAction(STLConstants.K0645_OK.getValue()){
        private static final long serialVersionUID = -6961800759728659264L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ConversionPatternHelpDialog.this.dispose();
        }
    };
    protected AbstractAction cancelAction = new AbstractAction(STLConstants.K0621_CANCEL.getValue()){
        private static final long serialVersionUID = 9180757082471160424L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ConversionPatternHelpDialog.this.dispose();
        }
    };
    protected AbstractAction previewAction = new AbstractAction(STLConstants.K0664_PREVIEW.getValue()){
        private static final long serialVersionUID = 8019247636030333301L;

        @Override
        public void actionPerformed(ActionEvent e) {
            String sampleStr = ConversionPatternHelpDialog.this.preview();
            ConversionPatternHelpDialog.this.sampleString.setText(sampleStr);
        }
    };

    public ConversionPatternHelpDialog(JPanel mainPanel) {
        this.parentDialog = mainPanel;
        this.setTitle(STLConstants.K0648_OUTPUT_FORMAT_HELP.getValue());
        this.setResizable(false);
        Container container = this.getContentPane();
        container.setLayout((LayoutManager)new VerticalLayout());
        container.add(this.getPreviewPanel());
        container.add(this.getConversionPatternPanel());
        container.add(this.getButtonPanel());
        this.setModal(true);
        this.pack();
        this.setLocationRelativeTo(mainPanel);
        this.setAlwaysOnTop(true);
    }

    protected JPanel getPreviewPanel() {
        if (this.previewPanel == null) {
            this.previewPanel = new JPanel(new GridBagLayout());
            this.previewPanel.setBackground(UIConstants.INTEL_WHITE);
            this.previewPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), STLConstants.K0664_PREVIEW.getValue(), 4, 2, UIConstants.H4_FONT.deriveFont(1), null));
            GridBagConstraints gc = new GridBagConstraints();
            this.formatStringLabel = ComponentFactory.getH5Label(UILabels.STL50049_TO_PREVIEW.getDescription(UILabels.STL50058_SAMPLE_LOG_MESSAGE.getDescription()), 1);
            gc.gridx = 0;
            gc.gridy = 0;
            gc.gridwidth = 3;
            gc.fill = 2;
            gc.anchor = 17;
            gc.insets = new Insets(3, 5, 3, 5);
            this.previewPanel.add((Component)this.formatStringLabel, gc);
            this.formatString = ComponentFactory.getH5Label(STLConstants.K0665_ENTER_FORMAT.getValue(), 1);
            gc.gridx = 0;
            gc.gridy = 1;
            gc.gridwidth = 1;
            gc.weightx = 0.0;
            this.previewPanel.add((Component)this.formatString, gc);
            this.previewText = new JTextField(40);
            this.previewText.setName(WidgetName.LOG_PREVIW_TEXT.name());
            gc.gridx = 1;
            gc.gridy = 1;
            gc.weightx = 1.0;
            this.previewPanel.add((Component)this.previewText, gc);
            this.previewButton = ComponentFactory.getIntelActionButton(this.previewAction);
            this.previewButton.setName(WidgetName.LOG_PREVIW.name());
            gc.gridx = 2;
            gc.gridy = 1;
            gc.weightx = 0.0;
            this.previewPanel.add((Component)this.previewButton, gc);
            this.sampleStringLabel = ComponentFactory.getH5Label(STLConstants.K0666_SAMPLE_FORMATTED.getValue(), 1);
            gc.gridx = 0;
            gc.gridy = 2;
            gc.gridwidth = 1;
            gc.weightx = 0.0;
            this.previewPanel.add((Component)this.sampleStringLabel, gc);
            this.sampleString = new JLabel("");
            this.sampleString.setName(WidgetName.LOG_PREVIW_OUTPUT.name());
            this.sampleString.setForeground(Color.RED);
            gc.gridx = 1;
            gc.gridy = 2;
            gc.gridwidth = 2;
            gc.weightx = 1.0;
            this.previewPanel.add((Component)this.sampleString, gc);
        }
        return this.previewPanel;
    }

    protected JScrollPane getConversionPatternPanel() {
        if (this.conversionPatternPanel == null) {
            JTable table = this.getConversionCharacterTable();
            this.conversionPatternPanel = new JScrollPane(table);
            this.conversionPatternPanel.setBackground(UIConstants.INTEL_WHITE);
            this.conversionPatternPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), STLConstants.K0663_CONVERSION_PATTERN.getValue(), 4, 2, UIConstants.H4_FONT.deriveFont(1), null));
        }
        return this.conversionPatternPanel;
    }

    protected JTable getConversionCharacterTable() {
        if (this.conversionCharacterTable == null) {
            this.data[0][0] = STLConstants.K0649_SC.getValue();
            this.data[0][1] = UILabels.STL50002_DATA1.getDescription();
            this.data[1][0] = STLConstants.K0650_C.getValue();
            this.data[1][1] = UILabels.STL50003_DATA2.getDescription();
            this.data[2][0] = STLConstants.K0651_D.getValue();
            this.data[2][1] = UILabels.STL50004_DATA3.getDescription();
            this.data[3][0] = STLConstants.K0652_F.getValue();
            this.data[3][1] = UILabels.STL50005_DATA4.getDescription();
            this.data[4][0] = STLConstants.K0653_SL.getValue();
            this.data[4][1] = UILabels.STL50006_DATA5.getDescription();
            this.data[5][0] = STLConstants.K0654_L.getValue();
            this.data[5][1] = UILabels.STL50007_DATA6.getDescription();
            this.data[6][0] = STLConstants.K0655_SM.getValue();
            this.data[6][1] = UILabels.STL50008_DATA7.getDescription();
            this.data[7][0] = STLConstants.K0656_M.getValue();
            this.data[7][1] = UILabels.STL50009_DATA8.getDescription();
            this.data[8][0] = STLConstants.K0657_SN.getValue();
            this.data[8][1] = UILabels.STL50010_DATA9.getDescription();
            this.data[9][0] = STLConstants.K0658_SP.getValue();
            this.data[9][1] = UILabels.STL50011_DATA10.getDescription();
            this.data[10][0] = STLConstants.K0659_SR.getValue();
            this.data[10][1] = UILabels.STL50012_DATA11.getDescription();
            this.data[11][0] = STLConstants.K0660_ST.getValue();
            this.data[11][1] = UILabels.STL50013_DATA12.getDescription();
            this.data[12][0] = STLConstants.K0661_SX.getValue();
            this.data[12][1] = UILabels.STL50014_DATA13.getDescription();
            this.data[13][0] = STLConstants.K0662_DOUBLE_PERCENT.getValue();
            this.data[13][1] = UILabels.STL50015_DATA14.getDescription();
            this.conversionCharacterTable = ComponentFactory.createIntelNonSortableSimpleTable(this.data, this.heading);
            this.conversionCharacterTable.setBorder(BorderFactory.createEtchedBorder());
            this.conversionCharacterTable.setEnabled(false);
            this.packRows(this.conversionCharacterTable, 2);
            this.packCols(this.conversionCharacterTable, 2);
            this.conversionCharacterTable.setPreferredScrollableViewportSize(this.conversionCharacterTable.getPreferredSize());
        }
        return this.conversionCharacterTable;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPannel == null) {
            this.buttonPannel = new JPanel();
            this.okButton = ComponentFactory.getIntelActionButton(this.okAction);
            this.okButton.setName(WidgetName.LOG_PREVIW_OK.name());
            this.buttonPannel.add(this.okButton);
            this.cancelButton = ComponentFactory.getIntelCancelButton(this.cancelAction);
            this.cancelButton.setName(WidgetName.LOG_PREVIW_CANCEL.name());
            this.buttonPannel.add(this.cancelButton);
        }
        return this.buttonPannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String preview() {
        int index;
        String s = this.previewText.getText().trim();
        StringBuilder ss = new StringBuilder(s);
        if (s.contains(STLConstants.K0652_F.getValue().trim())) {
            index = ss.indexOf(STLConstants.K0652_F.getValue().trim());
            ss.replace(index, index + 2, "ConversionPatternHelpDialog.java");
        }
        if (s.contains(STLConstants.K0654_L.getValue().trim())) {
            index = ss.indexOf(STLConstants.K0654_L.getValue().trim());
            ss.replace(index, index + 2, "38");
        }
        s = ss.toString();
        this.loggerContext.reset();
        this.logger.detachAndStopAllAppenders();
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)this.loggerContext);
        encoder.setPattern(s);
        encoder.start();
        OutputStreamAppender appender = new OutputStreamAppender();
        appender.setContext((Context)this.loggerContext);
        appender.setEncoder((Encoder)encoder);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        appender.setOutputStream((OutputStream)out);
        appender.start();
        try {
            this.logger.addAppender((Appender)appender);
            this.logger.info(STLConstants.K0666_SAMPLE_FORMATTED.getValue());
        }
        finally {
            appender.stop();
        }
        return out.toString();
    }

    public int getPreferredRowHeight(JTable table, int rowIndex, int margin) {
        int height = table.getRowHeight();
        for (int c = 0; c < table.getColumnCount(); ++c) {
            TableCellRenderer renderer = table.getCellRenderer(rowIndex, c);
            Component comp = table.prepareRenderer(renderer, rowIndex, c);
            int h = comp.getPreferredSize().height + 2 * margin;
            height = Math.max(height, h);
        }
        return height;
    }

    public int getPreferredColumnWidth(JTable table, int colIndex, int margin) {
        int width = 90;
        for (int r = 0; r < table.getRowCount(); ++r) {
            TableCellRenderer renderer = table.getCellRenderer(r, colIndex);
            Component comp = table.prepareRenderer(renderer, r, colIndex);
            int w = comp.getPreferredSize().width + 2 * margin;
            width = Math.max(width, w);
        }
        return width;
    }

    public void packRows(JTable table, int margin) {
        this.packRows(table, 0, table.getRowCount(), margin);
    }

    public void packRows(JTable table, int start, int end, int margin) {
        for (int r = 0; r < table.getRowCount(); ++r) {
            int h = this.getPreferredRowHeight(table, r, margin);
            if (table.getRowHeight(r) == h) continue;
            table.setRowHeight(r, h);
        }
    }

    public void packCols(JTable table, int margin) {
        TableColumn column = null;
        for (int i = 0; i < table.getColumnCount(); ++i) {
            column = table.getColumnModel().getColumn(i);
            int w = this.getPreferredColumnWidth(table, i, margin);
            column.setPreferredWidth(w);
        }
    }
}

