/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.logger.config.view;

import com.intel.stl.api.configuration.AppenderConfig;
import com.intel.stl.api.configuration.ConfigurationException;
import com.intel.stl.api.configuration.LoggingConfiguration;
import com.intel.stl.api.configuration.LoggingThreshold;
import com.intel.stl.api.configuration.RollingFileAppender;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.IntelComboBoxUI;
import com.intel.stl.ui.common.view.SafeNumberField;
import com.intel.stl.ui.logger.config.ILoggingControl;
import com.intel.stl.ui.logger.config.view.ConversionPatternHelpDialog;
import com.intel.stl.ui.main.view.IFabricView;
import com.intel.stl.ui.model.LoggingThresholdViz;
import com.intel.stl.ui.wizards.impl.WizardValidationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LoggingConfigView
extends JDialog {
    private static final long serialVersionUID = -5605031349189530174L;
    public static final int DIALOG_WIDTH = 800;
    public static final int DIALOG_HEIGHT = 500;
    private DocumentListener isDirtyListener;
    private DocumentListener setDirtyListener;
    private boolean dirty;
    private JTextField txtfldConversionPattern;
    private JFileChooser fileChooser;
    private JComboBox<String> cboxThresholdValue;
    private JFormattedTextField txtfldMaxFileSize;
    private JTextField txtfldMaxBackUpIndex;
    private JFormattedTextField txtfldFileLocation;
    private final String byteStr = "B";
    private JComboBox<String> cboxFileSizeUnit;
    private JPanel pnlMainCtrl;
    private JButton btnReset;
    private JButton btnOk;
    private JButton btnCancel;
    private ILoggingControl loggingControlListener;
    private RollingFileAppender rollingFileAppender;
    private final IFabricView owner;

    public LoggingConfigView(IFabricView owner) {
        super((JFrame)((Object)owner), STLConstants.K3048_LOGGING_CONFIGURATION.getValue(), true);
        this.owner = owner;
        this.createDocumentListener();
        this.initComponents();
    }

    protected void initComponents() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        final JPanel pnlConfigAppender = new JPanel();
        pnlConfigAppender.setOpaque(true);
        pnlConfigAppender.setBackground(UIConstants.INTEL_WHITE);
        pnlConfigAppender.setLayout(new GridBagLayout());
        pnlConfigAppender.setPreferredSize(new Dimension(800, 500));
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 17;
        gc.fill = 2;
        gc.insets = new Insets(5, 5, 5, 5);
        gc.weighty = 1.0;
        JLabel lblThreshold = ComponentFactory.getH5Label(STLConstants.K0636_APPLICATION_LOG_LEVEL.getValue(), 1);
        pnlConfigAppender.add((Component)lblThreshold, gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        String[] thresholdValues = new String[]{STLConstants.K0698_ALL.getValue(), STLConstants.K0632_TRACE.getValue(), STLConstants.K0630_DEBUG.getValue(), STLConstants.K0631_INFO.getValue(), STLConstants.K3002_WARN.getValue(), STLConstants.K0030_ERROR.getValue(), STLConstants.K0699_OFF.getValue()};
        this.cboxThresholdValue = ComponentFactory.createComboBox(thresholdValues, new DocumentListener[0]);
        this.cboxThresholdValue.setName(WidgetName.LOG_LEVEL.name());
        this.cboxThresholdValue.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int selectedIndex = ((JComboBox)e.getSource()).getSelectedIndex();
                LoggingConfigView.this.enableFields(selectedIndex);
                LoggingConfigView.this.setDirty();
            }
        });
        pnlConfigAppender.add(this.cboxThresholdValue, gc);
        gc.gridx = 0;
        ++gc.gridy;
        gc.weightx = 0.0;
        JLabel lblConversionPattern = ComponentFactory.getH5Label(STLConstants.K0637_OUTPUT_FORMAT.getValue(), 1);
        pnlConfigAppender.add((Component)lblConversionPattern, gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.txtfldConversionPattern = ComponentFactory.createTextField(null, false, 4096, this.isDirtyListener, this.setDirtyListener);
        this.txtfldConversionPattern.setName(WidgetName.LOG_OUTPUT_FORMAT.name());
        pnlConfigAppender.add((Component)this.txtfldConversionPattern, gc);
        gc.gridx = 2;
        gc.weightx = 0.0;
        JButton btnConversionPatternHelp = ComponentFactory.getImageButton(UIImages.HELP_ICON.getImageIcon());
        btnConversionPatternHelp.setName(WidgetName.LOG_OUTPUT_FORMAT_HELP.name());
        final ConversionPatternHelpDialog dlgPatternHelp = new ConversionPatternHelpDialog(pnlConfigAppender);
        btnConversionPatternHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dlgPatternHelp.setVisible(true);
            }
        });
        pnlConfigAppender.add((Component)btnConversionPatternHelp, gc);
        gc.gridx = 0;
        ++gc.gridy;
        JLabel lblMaxFileSize = ComponentFactory.getH5Label(STLConstants.K0638_MAX_FILE_SIZE.getValue(), 1);
        pnlConfigAppender.add((Component)lblMaxFileSize, gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.txtfldMaxFileSize = new SafeNumberField<Long>(new DecimalFormat("###"), 0L, false);
        this.txtfldMaxFileSize.setName(WidgetName.LOG_FILE_SIZE.name());
        ComponentFactory.setupTextField(this.txtfldMaxFileSize, this.setDirtyListener, this.isDirtyListener);
        pnlConfigAppender.add((Component)this.txtfldMaxFileSize, gc);
        gc.gridx = 2;
        gc.weightx = 0.0;
        String[] unitValueArray = new String[]{STLConstants.K0697_BYTE.getValue(), STLConstants.K0695_KB.getValue(), STLConstants.K0722_MB.getValue(), STLConstants.K0696_GB.getValue()};
        this.cboxFileSizeUnit = new JComboBox<String>(unitValueArray);
        this.cboxFileSizeUnit.setName(WidgetName.LOG_FILE_SIZE_UNIT.name());
        this.cboxFileSizeUnit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LoggingConfigView.this.dirty = true;
                LoggingConfigView.this.setDirty();
            }
        });
        this.cboxFileSizeUnit.setUI(new IntelComboBoxUI());
        pnlConfigAppender.add(this.cboxFileSizeUnit, gc);
        gc.gridx = 0;
        ++gc.gridy;
        JLabel lblMaxBackupIndex = ComponentFactory.getH5Label(STLConstants.K0640_MAX_NUM_FILE.getValue(), 1);
        pnlConfigAppender.add((Component)lblMaxBackupIndex, gc);
        gc.gridx = 1;
        this.txtfldMaxBackUpIndex = ComponentFactory.createNumericTextField(this.setDirtyListener, this.isDirtyListener);
        this.txtfldMaxBackUpIndex.setName(WidgetName.LOG_MAX_NUM_FILES.name());
        pnlConfigAppender.add((Component)this.txtfldMaxBackUpIndex, gc);
        gc.gridx = 0;
        ++gc.gridy;
        JLabel lblFileLocation = ComponentFactory.getH5Label(STLConstants.K0641_FILE_LOC.getValue(), 1);
        pnlConfigAppender.add((Component)lblFileLocation, gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.txtfldFileLocation = ComponentFactory.createTextField(null, false, 4096, this.setDirtyListener, this.isDirtyListener);
        this.txtfldFileLocation.setName(WidgetName.LOG_FILE_LOCATION.name());
        pnlConfigAppender.add((Component)this.txtfldFileLocation, gc);
        gc.fill = 0;
        gc.gridx = 2;
        gc.weightx = 0.0;
        JButton browseButton = ComponentFactory.getImageButton(UIImages.FOLDER_ICON.getImageIcon());
        browseButton.setName(WidgetName.LOG_FILE_BROWSER.name());
        browseButton.setToolTipText(STLConstants.K0642_BROWSE.getValue());
        this.fileChooser = new JFileChooser();
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggingConfigView.this.fileChooser.setDialogTitle(STLConstants.K0643_SELECT_FILE.getValue());
                File logLocation = new File(LoggingConfigView.this.rollingFileAppender.getFileLocation());
                LoggingConfigView.this.fileChooser.setCurrentDirectory(logLocation);
                LoggingConfigView.this.fileChooser.setFileSelectionMode(0);
                int result = LoggingConfigView.this.fileChooser.showOpenDialog(pnlConfigAppender);
                if (result == 0) {
                    File file = LoggingConfigView.this.fileChooser.getSelectedFile();
                    LoggingConfigView.this.txtfldFileLocation.setText(file.getAbsolutePath());
                }
            }
        });
        pnlConfigAppender.add((Component)browseButton, gc);
        pnlConfigAppender.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                int selectedIndex = LoggingConfigView.this.cboxThresholdValue.getSelectedIndex();
                LoggingConfigView.this.enableFields(selectedIndex);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        contentPane.add((Component)pnlConfigAppender, "North");
        contentPane.add((Component)this.getControlPanel(), "South");
        this.pack();
    }

    protected boolean isNumeric(String str) {
        NumberFormat formatter = NumberFormat.getInstance();
        ParsePosition pos = new ParsePosition(0);
        formatter.parse(str, pos);
        return str.length() == pos.getIndex();
    }

    protected JPanel getControlPanel() {
        if (this.pnlMainCtrl == null) {
            this.pnlMainCtrl = new JPanel();
            this.pnlMainCtrl.setLayout(new BoxLayout(this.pnlMainCtrl, 0));
            this.pnlMainCtrl.setBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2));
            this.pnlMainCtrl.add(Box.createGlue());
            this.btnReset = ComponentFactory.getIntelActionButton(STLConstants.K1006_RESET.getValue());
            this.btnReset.setName(WidgetName.LOG_RESET.name());
            this.btnReset.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggingConfigView.this.loggingControlListener.onReset();
                    LoggingConfigView.this.btnReset.setEnabled(false);
                    LoggingConfigView.this.btnOk.setEnabled(false);
                }
            });
            this.pnlMainCtrl.add(this.btnReset);
            this.pnlMainCtrl.add(Box.createHorizontalStrut(5));
            this.btnOk = ComponentFactory.getIntelActionButton(STLConstants.K0645_OK.getValue());
            this.btnOk.setName(WidgetName.LOG_OK.name());
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggingConfigView.this.onOk();
                }
            });
            this.btnOk.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    ((JButton)e.getSource()).requestFocusInWindow();
                }
            });
            this.pnlMainCtrl.add(this.btnOk);
            this.pnlMainCtrl.add(Box.createHorizontalStrut(5));
            this.btnCancel = ComponentFactory.getIntelActionButton(STLConstants.K0621_CANCEL.getValue());
            this.btnCancel.setName(WidgetName.LOG_CANCEL.name());
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggingConfigView.this.onCancel();
                }
            });
            this.pnlMainCtrl.add(this.btnCancel);
        }
        return this.pnlMainCtrl;
    }

    private void centerDialog() {
        this.pack();
        Point dialogLocation = new Point(0, 0);
        dialogLocation.x = this.owner.getScreenPosition().x + this.owner.getScreenSize().width / 2 - this.getWidth() / 2;
        dialogLocation.y = this.owner.getScreenPosition().y + this.owner.getScreenSize().height / 2 - this.getHeight() / 2;
        this.setLocation(dialogLocation);
    }

    protected JTextField createTextField(String txt) {
        if (this.isDirtyListener == null || this.setDirtyListener == null) {
            this.createDocumentListener();
        }
        JTextField txtField = new JTextField(txt);
        txtField.getDocument().addDocumentListener(this.setDirtyListener);
        txtField.getDocument().addDocumentListener(this.isDirtyListener);
        return txtField;
    }

    protected void createDocumentListener() {
        this.isDirtyListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                LoggingConfigView.this.dirty = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LoggingConfigView.this.dirty = true;
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LoggingConfigView.this.dirty = true;
            }
        };
        this.setDirtyListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                LoggingConfigView.this.setDirty();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LoggingConfigView.this.setDirty();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LoggingConfigView.this.setDirty();
            }
        };
    }

    protected void enableFields(int selectedIndex) {
        int offIndex = LoggingThresholdViz.OFF.getId();
        boolean enabled = selectedIndex != offIndex;
        this.txtfldConversionPattern.setEnabled(enabled);
        this.txtfldMaxFileSize.setEnabled(enabled);
        this.txtfldMaxBackUpIndex.setEnabled(enabled);
        this.txtfldFileLocation.setEnabled(enabled);
    }

    protected void setDirty() {
        this.dirty = true;
        if (this.txtfldConversionPattern.getText().length() > 0 && this.txtfldMaxFileSize.getText().length() > 0 && this.txtfldMaxBackUpIndex.getText().length() > 0 && this.txtfldFileLocation.getText().length() > 0) {
            this.btnOk.setEnabled(true);
            this.btnReset.setEnabled(true);
        } else {
            this.btnOk.setEnabled(false);
            this.btnReset.setEnabled(false);
        }
    }

    protected void onOk() {
        try {
            String selection = (String)this.cboxThresholdValue.getSelectedItem();
            LoggingThreshold threshold = LoggingThresholdViz.getLoggingThreshold(selection);
            this.loggingControlListener.setRootLoggingLevel(threshold);
            boolean success = this.loggingControlListener.onOk();
            if (success) {
                this.closeLoggingConfig();
            }
        }
        catch (WizardValidationException e) {
            Util.showErrorMessage(this, e.getMessage());
        }
    }

    protected void onCancel() {
        this.closeLoggingConfig();
    }

    private void setMaxFileSize(String maxFileSizeStr) {
        if (!maxFileSizeStr.endsWith("B")) {
            this.cboxFileSizeUnit.setSelectedItem(STLConstants.K0697_BYTE.getValue());
            this.txtfldMaxFileSize.setText(maxFileSizeStr);
        } else {
            String unit = maxFileSizeStr.substring(maxFileSizeStr.length() - 2, maxFileSizeStr.length());
            if (unit.equals(STLConstants.K0695_KB.getValue())) {
                this.cboxFileSizeUnit.setSelectedItem(STLConstants.K0695_KB.getValue());
                this.txtfldMaxFileSize.setText(maxFileSizeStr.substring(0, maxFileSizeStr.length() - 2));
            } else if (unit.equals(STLConstants.K0722_MB.getValue())) {
                this.cboxFileSizeUnit.setSelectedItem(STLConstants.K0722_MB.getValue());
                this.txtfldMaxFileSize.setText(maxFileSizeStr.substring(0, maxFileSizeStr.length() - 2));
            } else if (unit.equals(STLConstants.K0696_GB.getValue())) {
                this.cboxFileSizeUnit.setSelectedItem(STLConstants.K0696_GB.getValue());
                this.txtfldMaxFileSize.setText(maxFileSizeStr.substring(0, maxFileSizeStr.length() - 2));
            } else {
                throw new IllegalArgumentException("Unknow unit '" + unit + "'");
            }
        }
    }

    public void setLoggingControlListener(ILoggingControl listener) {
        this.loggingControlListener = listener;
    }

    public void setConversionPattern(String pattern) {
        this.txtfldConversionPattern.setText(pattern);
    }

    public void initView(final HashMap<String, AppenderConfig> appenderConfigMap) {
        Runnable init = new Runnable(){

            @Override
            public void run() {
                LoggingConfigView.this.rollingFileAppender = (RollingFileAppender)appenderConfigMap.get(STLConstants.K3003_ROLLING_FILE_APPENDER.getValue());
                if (LoggingConfigView.this.rollingFileAppender != null) {
                    LoggingThreshold threshold = LoggingConfigView.this.loggingControlListener.getRootLoggingLevel();
                    if (threshold == null) {
                        LoggingConfigView.this.cboxThresholdValue.setSelectedIndex(LoggingThresholdViz.ERROR.getId());
                    } else {
                        LoggingConfigView.this.cboxThresholdValue.setSelectedIndex(threshold.getId());
                    }
                    LoggingConfigView.this.txtfldConversionPattern.setText(LoggingConfigView.this.rollingFileAppender.getConversionPattern());
                    LoggingConfigView.this.setMaxFileSize(LoggingConfigView.this.rollingFileAppender.getMaxFileSize());
                    LoggingConfigView.this.txtfldMaxBackUpIndex.setText(String.valueOf(LoggingConfigView.this.rollingFileAppender.getMaxNumOfBackUp()));
                    LoggingConfigView.this.txtfldFileLocation.setText(LoggingConfigView.this.rollingFileAppender.getFileLocation());
                }
            }
        };
        Util.runInEDT(init);
    }

    public void updateAppender(LoggingConfiguration loggingConfig) {
        try {
            List<AppenderConfig> appenders = loggingConfig.getAppenders();
            for (AppenderConfig appender : appenders) {
                if (!(appender instanceof RollingFileAppender)) continue;
                this.rollingFileAppender.setName(appender.getName());
                this.rollingFileAppender.setConversionPattern(this.txtfldConversionPattern.getText());
                try {
                    this.rollingFileAppender.setFileLocation(this.txtfldFileLocation.getText().trim());
                }
                catch (ConfigurationException e) {
                    Util.showErrorMessage(this, e.getMessage());
                }
                String fileSizeUnitSelected = (String)this.cboxFileSizeUnit.getSelectedItem();
                String maxFileSizestr = this.txtfldMaxFileSize.getText().trim();
                if (fileSizeUnitSelected.equals(STLConstants.K0697_BYTE.getValue())) {
                    this.rollingFileAppender.setMaxFileSize(maxFileSizestr);
                } else {
                    String maxFileSizeInclUnitStr = maxFileSizestr + fileSizeUnitSelected;
                    this.rollingFileAppender.setMaxFileSize(maxFileSizeInclUnitStr);
                }
                String maxNumBackupsStr = this.txtfldMaxBackUpIndex.getText().trim();
                this.rollingFileAppender.setMaxNumOfBackUp(maxNumBackupsStr);
            }
        }
        catch (Exception e) {
            Util.showErrorMessage(this, UILabels.STL50057_LOGGING_CONFIG_SAVE_FAILURE.getDescription());
        }
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clearPanel() {
        this.cboxThresholdValue.setSelectedItem(STLConstants.K0699_OFF.getValue());
        this.cboxFileSizeUnit.setSelectedIndex(0);
        this.txtfldConversionPattern.setText("");
        this.txtfldFileLocation.setText("");
        this.txtfldMaxFileSize.setText("");
        this.txtfldMaxBackUpIndex.setText("");
    }

    public void showErrorMessage(String errorMessage) {
        Util.showErrorMessage(this, errorMessage);
    }

    public void showLoggingConfig() {
        this.btnOk.setEnabled(false);
        this.btnReset.setEnabled(false);
        this.centerDialog();
        this.setVisible(true);
    }

    public void closeLoggingConfig() {
        this.setVisible(false);
    }
}

