/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main;

import com.intel.stl.api.CertsDescription;
import com.intel.stl.api.SSLStoreCredentialsDeniedException;
import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.DialogFactory;
import com.intel.stl.ui.main.FabricController;
import com.intel.stl.ui.main.view.CredentialsGlassPanel;
import com.intel.stl.ui.main.view.FVMainFrame;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class CertsLoginController {
    private final FabricController controller;
    private final FVMainFrame mainFrame;
    private final CredentialsGlassPanel certsPanel;
    private Component oldGlassComp;
    private final Object waitingForUserResponse = new Object();
    private CertsDescription connectionCerts = null;
    private int buttonPressed = -1;
    public static final int MAX_TRIES = 5;
    private int sslAttempts = 5;

    public CertsLoginController(FabricController controller, FVMainFrame mainFrame, CredentialsGlassPanel panel) {
        this.controller = controller;
        this.mainFrame = mainFrame;
        this.certsPanel = panel;
        this.certsPanel.setCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CertsLoginController.this.cancelAction();
            }
        });
        this.certsPanel.setOkAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CertsLoginController.this.okAction();
            }
        });
    }

    public void sslReconnectCleanup() {
        this.buttonPressed = -1;
        this.sslAttempts = 5;
        this.certsPanel.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertsDescription getSSLCredentials(final HostInfo hostInfo) throws SSLStoreCredentialsDeniedException {
        if (this.sslAttempts < 1) {
            this.sslAttempts = 5;
            this.certsPanel.reset();
            this.controller.onMenuClose();
            throw new SSLStoreCredentialsDeniedException(UILabels.STL50050_CONNECTION_FAIL);
        }
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                CertsLoginController.this.showCredentialsPanel(hostInfo);
            }
        });
        Object object = this.waitingForUserResponse;
        synchronized (object) {
            while (this.buttonPressed < 0) {
                try {
                    this.waitingForUserResponse.wait();
                }
                catch (InterruptedException e) {
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        if (this.buttonPressed == DialogFactory.CANCEL_OPTION) {
            this.sslAttempts = 5;
            this.certsPanel.reset();
            this.controller.onMenuClose();
            throw new SSLStoreCredentialsDeniedException(UILabels.STL10114_USER_CANCELLED);
        }
        hostInfo.setCertsDescription(this.connectionCerts);
        this.buttonPressed = -1;
        return this.connectionCerts;
    }

    public void showCredentialsPanel(HostInfo hostInfo) {
        CertsDescription currentCerts = hostInfo.getCertsDescription();
        this.certsPanel.setKeyStoreLocation(currentCerts.getKeyStoreFile());
        this.certsPanel.setTrustStoreLocation(currentCerts.getTrustStoreFile());
        this.oldGlassComp = this.mainFrame.installGlassPanel(this.certsPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAction() {
        this.buttonPressed = DialogFactory.CANCEL_OPTION;
        this.sslAttempts = 0;
        Object object = this.waitingForUserResponse;
        synchronized (object) {
            this.waitingForUserResponse.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void okAction() {
        this.buttonPressed = DialogFactory.OK_OPTION;
        this.connectionCerts = new CertsDescription(this.certsPanel.getKeyStoreLocation(), this.certsPanel.getTrustStoreLocation());
        this.connectionCerts.setKeyStorePwd(this.certsPanel.getKeyStorePwd());
        this.connectionCerts.setTrustStorePwd(this.certsPanel.getTrustStorePwd());
        if (this.oldGlassComp != null) {
            this.mainFrame.installGlassPanel(this.oldGlassComp);
        }
        --this.sslAttempts;
        Object object = this.waitingForUserResponse;
        synchronized (object) {
            this.waitingForUserResponse.notify();
        }
    }

    public void setKeyStorePwdError(String errorMessage) {
        this.certsPanel.setKeyStorePwdError(errorMessage);
    }

    public void setKeyStoreLocError(String errorMessage) {
        this.certsPanel.setKeyStoreLocError(errorMessage);
    }

    public void setTrustStorePwdError(String errorMessage) {
        this.certsPanel.setTrustStorePwdError(errorMessage);
    }

    public void setTrustStoreLocError(String errorMessage) {
        this.certsPanel.setTrustStorePwdError(errorMessage);
    }
}

