/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main;

import com.intel.stl.api.configuration.EventType;
import com.intel.stl.api.notice.EventDescription;
import com.intel.stl.api.notice.FESource;
import com.intel.stl.api.notice.NoticeSeverity;
import com.intel.stl.api.performance.IPerformanceApi;
import com.intel.stl.api.performance.ImageInfoBean;
import com.intel.stl.api.performance.SMInfoDataBean;
import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.api.subnet.SMRecordBean;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.ui.common.EventTableModel;
import com.intel.stl.ui.common.IPageController;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.ISectionController;
import com.intel.stl.ui.common.PageWeight;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.view.EventTableView;
import com.intel.stl.ui.common.view.ISectionListener;
import com.intel.stl.ui.common.view.JSectionView;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.EventTableSection;
import com.intel.stl.ui.main.PerformanceSection;
import com.intel.stl.ui.main.SummarySectionOld;
import com.intel.stl.ui.main.view.HomeView;
import com.intel.stl.ui.main.view.PerformanceSectionView;
import com.intel.stl.ui.main.view.SummarySectionViewOld;
import com.intel.stl.ui.model.GroupStatistics;
import com.intel.stl.ui.model.StateSummary;
import com.intel.stl.ui.publisher.CallbackAdapter;
import com.intel.stl.ui.publisher.ICallback;
import com.intel.stl.ui.publisher.Task;
import com.intel.stl.ui.publisher.TaskScheduler;
import com.intel.stl.ui.publisher.subscriber.ImageInfoSubscriber;
import com.intel.stl.ui.publisher.subscriber.SubscriberType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.engio.mbassy.bus.MBassador;

public class HomePageOld
implements IPageController {
    private TaskScheduler scheduler;
    private ISubnetApi subnetApi;
    private HomeView view = null;
    private final List<ISectionController<?>> sections;
    private SummarySectionOld summary;
    private PerformanceSection performance;
    private EventTableSection events;
    private GroupStatistics groupStatistics;
    private final boolean showEvents;
    private Task<ImageInfoBean> imageInfoTask;
    private ICallback<ImageInfoBean> imageInfoCallback;
    private Task<StateSummary> stateSummaryTask;
    private ICallback<StateSummary> stateSummaryCallback;
    private int mPortNum = 0;
    private final MBassador<IAppEvent> eventBus;
    private ImageInfoSubscriber imageInfoSubscriber;
    private boolean isRefreshing;

    public HomePageOld(MBassador<IAppEvent> eventBus) {
        this(eventBus, false);
    }

    public HomePageOld(MBassador<IAppEvent> eventBus, boolean showEvents) {
        this.showEvents = showEvents;
        this.eventBus = eventBus;
        this.view = new HomeView();
        this.sections = this.getSections();
        ArrayList sectionViews = new ArrayList();
        for (ISectionController<?> section : this.sections) {
            sectionViews.add((JSectionView<?>)section.getView());
        }
        this.view.installSectionViews(sectionViews);
    }

    protected List<ISectionController<?>> getSections() {
        ArrayList sections = new ArrayList();
        this.summary = new SummarySectionOld(new SummarySectionViewOld(), this.eventBus);
        sections.add(this.summary);
        this.performance = new PerformanceSection(new PerformanceSectionView(), this.eventBus);
        sections.add(this.performance);
        if (this.showEvents) {
            EventTableModel tableModel = new EventTableModel();
            final EventTableView tableView = new EventTableView(tableModel);
            JSectionView<ISectionListener> eventsView = new JSectionView<ISectionListener>(STLConstants.K0104_HOME_EVENTS.getValue()){
                private static final long serialVersionUID = -3095494060522455280L;

                @Override
                protected JComponent getMainComponent() {
                    return tableView;
                }
            };
            this.events = new EventTableSection(tableModel, eventsView, tableView, this.eventBus);
            sections.add(this.events);
        }
        return sections;
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        IProgressObserver[] subObservers = observer.createSubObservers(2);
        this.subnetApi = context.getSubnetApi();
        this.scheduler = context.getTaskScheduler();
        this.imageInfoSubscriber = (ImageInfoSubscriber)this.scheduler.getSubscriber(SubscriberType.IMAGE_INFO);
        this.imageInfoCallback = new CallbackAdapter<ImageInfoBean>(){

            @Override
            public synchronized void onDone(ImageInfoBean result) {
                if (result != null) {
                    HomePageOld.this.processImageInfo(result);
                }
            }
        };
        this.imageInfoTask = this.imageInfoSubscriber.registerImageInfo(this.imageInfoCallback);
        if (observer.isCancelled()) {
            this.clear();
            return;
        }
        this.stateSummaryCallback = new CallbackAdapter<StateSummary>(){

            @Override
            public synchronized void onDone(StateSummary result) {
                if (result != null) {
                    HomePageOld.this.processStateSummary(result);
                }
            }
        };
        if (observer.isCancelled()) {
            this.clear();
            return;
        }
        subObservers[0].onFinish();
        this.performance.setContext(context, subObservers[1]);
        observer.onFinish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRefresh(IProgressObserver observer) {
        this.viewClear();
        IPerformanceApi perfApi = this.scheduler.getPerformanceApi();
        this.isRefreshing = true;
        try {
            ImageInfoBean imgInfo = perfApi.getLatestImageInfo();
            this.imageInfoCallback.onDone(imgInfo);
            if (observer.isCancelled()) {
                this.viewClear();
                return;
            }
            if (observer.isCancelled()) {
                this.viewClear();
                return;
            }
            this.performance.onRefresh(observer);
            observer.onFinish();
        }
        finally {
            this.isRefreshing = false;
        }
    }

    @Override
    public void clear() {
        this.viewClear();
        if (this.scheduler != null) {
            if (this.imageInfoTask != null) {
                this.imageInfoSubscriber.deregisterImageInfo(this.imageInfoTask, this.imageInfoCallback);
            }
            if (this.stateSummaryTask != null) {
                // empty if block
            }
        }
        this.groupStatistics = null;
    }

    protected void viewClear() {
        for (ISectionController<?> section : this.sections) {
            section.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processImageInfo(ImageInfoBean imageInfo) {
        List<SMInfoDataBean> sms = this.getSMs();
        HomePageOld homePageOld = this;
        synchronized (homePageOld) {
            if (this.groupStatistics == null) {
                this.groupStatistics = new GroupStatistics(this.subnetApi.getConnectionDescription(), imageInfo, sms);
                try {
                    this.groupStatistics.setNodeTypesDist(this.subnetApi.getNodesTypeDist(false, this.isRefreshing));
                    this.groupStatistics.setPortTypesDist(this.subnetApi.getPortsTypeDist(true, this.isRefreshing));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.groupStatistics.setImageInfo(imageInfo, sms);
            }
            int msmLid = imageInfo.getSMInfo()[0].getLid();
            SMRecordBean msm = this.subnetApi.getSM(msmLid);
            if (msm != null) {
                this.groupStatistics.setMsmUptimeInSeconds(msm.getSmInfo().getElapsedTime());
            }
        }
        this.summary.updateStatistics(this.groupStatistics);
    }

    protected List<SMInfoDataBean> getSMs() {
        List<SMRecordBean> sms = this.subnetApi.getSMs();
        ArrayList<SMInfoDataBean> res = new ArrayList<SMInfoDataBean>();
        for (SMRecordBean sm : sms) {
            try {
                NodeRecordBean node = this.subnetApi.getNode(sm.getLid());
                SMInfoDataBean smInfoData = new SMInfoDataBean();
                smInfoData.setLid(sm.getLid());
                smInfoData.setPriority(sm.getSmInfo().getPriority());
                smInfoData.setSmNodeDesc(node.getNodeDesc());
                smInfoData.setSmPortGuid(sm.getSmInfo().getPortGuid());
                smInfoData.setState(sm.getSmInfo().getSmStateCurrent());
                res.add(smInfoData);
            }
            catch (SubnetDataNotFoundException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processStateSummary(StateSummary stateSummary) {
        if (this.groupStatistics == null) {
            return;
        }
        int totalSWs = 0;
        int totalCAs = 0;
        HomePageOld homePageOld = this;
        synchronized (homePageOld) {
            totalSWs = this.groupStatistics.getNodeTypesDist().get((Object)NodeType.SWITCH);
            totalCAs = this.groupStatistics.getNodeTypesDist().get((Object)NodeType.HFI);
        }
        this.summary.updateStates(stateSummary.getSwitchStates(), totalSWs, stateSummary.getHfiStates(), totalCAs);
        this.summary.updateHealthScore(stateSummary.getHealthScore());
        this.summary.updateWorstNodes(stateSummary.getWorstNodes());
    }

    protected void updateEventTable() {
        if (this.events == null) {
            return;
        }
        EventDescription event = new EventDescription();
        event.setDate(new Date());
        event.setSeverity(NoticeSeverity.INFO);
        FESource feSrc = new FESource();
        feSrc.setHost("FDR_SWITCH9");
        event.setType(EventType.FE_CONNECTION_LOST);
        if (this.mPortNum < 100) {
            ++this.mPortNum;
            feSrc.setPort(this.mPortNum);
            event.setSource(feSrc);
            this.events.updateTable(event);
        }
    }

    @Override
    public String getName() {
        return "Home 2";
    }

    @Override
    public String getDescription() {
        return STLConstants.K0101_HOME_DESCRIPTION.getValue();
    }

    @Override
    public JPanel getView() {
        return this.view;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void onEnter() {
    }

    @Override
    public void onExit() {
    }

    @Override
    public boolean canExit() {
        return true;
    }

    @Override
    public PageWeight getContextSwitchWeight() {
        return PageWeight.MEDIUM;
    }

    @Override
    public PageWeight getRefreshWeight() {
        return PageWeight.MEDIUM;
    }
}

