/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.performance.SMInfoDataBean;
import com.intel.stl.ui.common.BaseCardController;
import com.intel.stl.ui.common.DistributionBarController;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.ICardListener;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.view.StatisticsViewOld;
import com.intel.stl.ui.model.GroupStatistics;
import com.intel.stl.ui.model.NodeTypeViz;
import com.intel.stl.ui.model.StateShortTypeViz;
import java.util.concurrent.TimeUnit;
import net.engio.mbassy.bus.MBassador;

public class StatisticsCardOld
extends BaseCardController<ICardListener, StatisticsViewOld> {
    private final DistributionBarController nodeTypesController;
    private final DistributionBarController nodeStatesController;
    private final DistributionBarController portTypesController;
    private final DistributionBarController portStatesController;

    public StatisticsCardOld(StatisticsViewOld view, MBassador<IAppEvent> eventBus) {
        super(view, eventBus);
        this.nodeTypesController = new DistributionBarController(view.getNodeTypesBar(), NodeTypeViz.names, null, NodeTypeViz.colors);
        this.nodeStatesController = new DistributionBarController(view.getNodeStatesBar(), StateShortTypeViz.names, null, StateShortTypeViz.colors);
        this.portTypesController = new DistributionBarController(view.getPortTypesBar(), NodeTypeViz.names, null, NodeTypeViz.colors);
        this.portStatesController = new DistributionBarController(view.getPortStatesBar(), StateShortTypeViz.names, null, StateShortTypeViz.colors);
    }

    public DistributionBarController getNodeTypesController() {
        return this.nodeTypesController;
    }

    public DistributionBarController getNodeStatesController() {
        return this.nodeStatesController;
    }

    public DistributionBarController getPortTypesController() {
        return this.portTypesController;
    }

    public DistributionBarController getPortStatesController() {
        return this.portStatesController;
    }

    public void updateStatistics(final GroupStatistics sta) {
        final int totalNodes = sta.getNumNodes();
        this.nodeTypesController.setDistribution(NodeTypeViz.getDistributionValues2(sta.getNodeTypesDist()));
        this.nodeStatesController.setDistribution(StateShortTypeViz.getDistributionValues(sta.getNumNoRespNodes(), sta.getNumSkippedNodes(), totalNodes));
        final long totalPorts = sta.getNumActivePorts();
        this.portTypesController.setDistribution(NodeTypeViz.getDistributionValues(sta.getPortTypesDist()));
        this.portStatesController.setDistribution(StateShortTypeViz.getDistributionValues(sta.getNumNoRespPorts(), sta.getNumSkippedPorts(), totalPorts));
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                ((StatisticsViewOld)StatisticsCardOld.this.view).setTitle(StatisticsCardOld.this.getTitle(sta));
                ((StatisticsViewOld)StatisticsCardOld.this.view).setDuration(sta.getMsmUptimeInSeconds(), TimeUnit.SECONDS);
                ((StatisticsViewOld)StatisticsCardOld.this.view).setLinks(UIConstants.INTEGER.format(sta.getNumLinks()));
                ((StatisticsViewOld)StatisticsCardOld.this.view).setNodes(UIConstants.INTEGER.format(totalNodes));
                ((StatisticsViewOld)StatisticsCardOld.this.view).setPorts(UIConstants.INTEGER.format(totalPorts));
                SMInfoDataBean msm = sta.getMasterSM();
                if (msm != null) {
                    String name = msm.getSmNodeDesc();
                    String description = STLConstants.K0026_LID.getValue() + ": " + StringUtils.intHexString(msm.getLid()) + " " + STLConstants.K0027_PORT_GUID.getValue() + ": " + StringUtils.longHexString(msm.getSmPortGuid());
                    ((StatisticsViewOld)StatisticsCardOld.this.view).setMsmName(name, description);
                }
            }
        });
    }

    public String getTitle(GroupStatistics sta) {
        return STLConstants.K0007_SUBNET.getValue() + ": " + sta.getName();
    }

    @Override
    public ICardListener getCardListener() {
        return this;
    }
}

