/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.configuration.UserSettings;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.ui.common.IContextAware;
import com.intel.stl.ui.common.ProgressObserver;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.framework.AbstractTask;
import com.intel.stl.ui.framework.IController;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.ContextSwitchTask;
import com.intel.stl.ui.main.FabricController;
import com.intel.stl.ui.main.FabricModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubnetSwitchTask
extends AbstractTask<FabricModel, Context, String> {
    private static Logger log = LoggerFactory.getLogger(SubnetSwitchTask.class);
    private boolean previousContextCleared;
    private Context oldContext;
    private final List<ContextSwitchTask> subtasks;
    private final List<IContextAware> backgroundContextPages;
    private final List<IContextAware> foregroundContextPages;
    private Exception foregroundFailure;
    private final Context newContext;
    private final Object mutex = new Object();

    public SubnetSwitchTask(FabricModel model, Context newContext, List<IContextAware> foregroundContextPages, List<IContextAware> backgroundContextPages) {
        super(model);
        this.newContext = newContext;
        this.foregroundContextPages = foregroundContextPages;
        this.backgroundContextPages = backgroundContextPages;
        this.subtasks = new ArrayList<ContextSwitchTask>();
    }

    public Context getNewContext() {
        return this.newContext;
    }

    public Context getOldContext() {
        return this.oldContext;
    }

    public void setOldContext(Context oldContext) {
        this.oldContext = oldContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Context processInBackground(Context context) throws Exception {
        this.foregroundFailure = null;
        this.oldContext = context;
        this.previousContextCleared = false;
        this.newContext.initialize();
        boolean addRandomValues = ((FabricModel)this.model).isAddRandomValues();
        this.newContext.setRandom(addRandomValues);
        this.newContext.getPerformanceApi().setRandom(addRandomValues);
        FabricController controller = (FabricController)this.getController();
        SubnetDescription newSubnet = this.newContext.getSubnetDescription();
        SubnetDescription currentSubnet = null;
        if (this.oldContext != null) {
            currentSubnet = this.oldContext.getSubnetDescription();
            log.info("Switching to subnet '" + newSubnet + "' from '" + currentSubnet + "'...");
        } else {
            log.info("Switching to subnet '" + newSubnet + "'...");
        }
        this.publishProgressNote(UILabels.STL10105_CREATE_CONTEXT.getDescription());
        if (this.oldContext != null) {
            log.info("Clearing context for '" + currentSubnet + "'");
            this.publishProgressNote(UILabels.STL10107_CLEAR_CONTEXT.getDescription());
            this.oldContext.close();
            this.previousContextCleared = true;
        }
        for (IContextAware page : this.foregroundContextPages) {
            short work = page.getContextSwitchWeight().getWeight();
            ProgressObserver observer = new ProgressObserver(this, work);
            try {
                this.publishProgressNote(UILabels.STL10108_INIT_PAGE.getDescription(page.getName()));
                page.setContext(this.newContext, observer);
                this.publishProgressNote(UILabels.STL10112_INIT_PAGE_COMPLETED.getDescription(page.getName()));
            }
            catch (Exception e) {
                if (this.foregroundFailure != null) continue;
                this.foregroundFailure = e;
            }
            finally {
                observer.onFinish();
            }
        }
        for (IContextAware page : this.backgroundContextPages) {
            ContextSwitchTask subtask = new ContextSwitchTask((FabricModel)this.model, this.newContext, this, page);
            this.subtasks.add(subtask);
            controller.submitTask(subtask);
        }
        boolean allDone = false;
        while (!allDone) {
            this.waitForSubtasks();
            boolean completed = true;
            for (ContextSwitchTask subtask : this.subtasks) {
                if (subtask.isDone() || subtask.isCancelled()) continue;
                completed = false;
            }
            if (!completed) continue;
            allDone = true;
        }
        return this.newContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForSubtasks() {
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.mutex.wait(500L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSubtasks() {
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notify();
        }
    }

    @Override
    public void onTaskSuccess(Context result) {
        if (this.foregroundFailure != null) {
            this.onTaskFailure(this.foregroundFailure);
            return;
        }
        for (ContextSwitchTask subtask : this.subtasks) {
            if (!subtask.hasException()) continue;
            this.onTaskFailure(subtask.getExecutionException());
            return;
        }
        IController controller = this.getController();
        controller.setContext(result);
        SubnetDescription oldSubnet = ((FabricModel)this.model).getCurrentSubnet();
        SubnetDescription resSubnet = result.getSubnetDescription();
        ((FabricModel)this.model).setCurrentSubnet(resSubnet);
        ((FabricModel)this.model).setPreviousSubnet(oldSubnet);
        UserSettings userSettings = result.getUserSettings();
        Properties usrState = null;
        if (userSettings != null && (usrState = userSettings.getPreferences().get("UserState")) == null) {
            usrState = new Properties();
            userSettings.getPreferences().put("UserState", usrState);
        }
        if (usrState != null) {
            usrState.setProperty("LastSubnetAccessed", resSubnet.getName());
        }
        controller.notifyModelChanged();
    }

    @Override
    public void onTaskFailure(Throwable caught) {
        SubnetDescription newSubnet = this.newContext.getSubnetDescription();
        StringBuffer sb = new StringBuffer();
        sb.append(UILabels.STL50050_CONNECTION_FAIL.getDescription(newSubnet.getName(), newSubnet.getCurrentFE().getHost()));
        sb.append("\n" + StringUtils.getErrorMessage(caught));
        if (!this.previousContextCleared && this.oldContext != null) {
            SubnetDescription currentSubnet = this.oldContext.getSubnetDescription();
            sb.append("\n");
            sb.append(UILabels.STL50051_USE_OLD_SUBNET.getDescription(currentSubnet.getName(), currentSubnet.getCurrentFE().getHost()));
        }
        ((FabricModel)this.model).setErrorMessage(sb.toString());
        this.getController().notifyModelUpdateFailed(caught);
    }

    @Override
    public void onFinally() {
    }

    @Override
    public void processIntermediateResults(List<String> intermediateResults) {
    }

    public void publishProgressNote(String note) {
        this.firePropertyChange("ProgressNote", null, note);
    }
}

