/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UndoableSelection<S>
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 8781728280185363577L;
    private static final Logger log = LoggerFactory.getLogger(UndoableSelection.class);
    protected final S oldSelection;
    protected final S newSelection;
    private boolean isSignificant = true;

    public UndoableSelection(S oldSelection, S newSelection) {
        this.oldSelection = oldSelection;
        this.newSelection = newSelection;
    }

    public boolean isValid() {
        return this.oldSelection != this.newSelection && (this.newSelection == null || !this.newSelection.equals(this.oldSelection));
    }

    public void setSignificant(boolean isSignificant) {
        this.isSignificant = isSignificant;
    }

    @Override
    public boolean isSignificant() {
        return this.isSignificant;
    }

    @Override
    public synchronized void undo() throws CannotUndoException {
        super.undo();
        if (this.oldSelection != null) {
            log.info("UNDO " + this.oldSelection);
            this.execute(this.oldSelection);
        }
    }

    @Override
    public synchronized void redo() throws CannotRedoException {
        super.redo();
        if (this.newSelection != null) {
            log.info("REDO " + this.newSelection);
            this.execute(this.newSelection);
        }
    }

    protected abstract void execute(S var1);

    @Override
    public boolean canUndo() {
        boolean res = super.canUndo() && this.canExecute(this.oldSelection);
        log.info("CAN_UNDO " + res);
        return res;
    }

    @Override
    public boolean canRedo() {
        boolean res = super.canRedo() && this.canExecute(this.newSelection);
        log.info("CAN_REDO " + res);
        return res;
    }

    protected boolean canExecute(S selection) {
        return true;
    }

    @Override
    public String toString() {
        return "UndoableSelection [isSignificant=" + this.isSignificant + ",\n  oldSelection=" + this.oldSelection + ",\n  newSelection=" + this.newSelection + "]";
    }
}

