/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main;

import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.common.IPinProvider;
import com.intel.stl.ui.common.PinDescription;
import com.intel.stl.ui.common.PinnableCardController;
import com.intel.stl.ui.common.UndoableJumpEvent;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.event.JumpDestination;
import com.intel.stl.ui.event.NodesSelectedEvent;
import com.intel.stl.ui.event.PageSelectedEvent;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.HelpAction;
import com.intel.stl.ui.main.HomePage;
import com.intel.stl.ui.main.UndoHandler;
import com.intel.stl.ui.main.view.IWorstNodesListener;
import com.intel.stl.ui.main.view.WorstNodesView;
import com.intel.stl.ui.model.NodeScore;
import java.util.Properties;
import net.engio.mbassy.bus.MBassador;

public class WorstNodesCard
extends PinnableCardController<IWorstNodesListener, WorstNodesView>
implements IWorstNodesListener,
IPinProvider {
    private UndoHandler undoHandler;
    private final String origin = HomePage.NAME;
    private NodeScore[] lastNodes;

    public WorstNodesCard(WorstNodesView view, MBassador<IAppEvent> eventBus) {
        super(view, eventBus);
    }

    @Override
    public String getHelpID() {
        return HelpAction.getInstance().getWorstNodes();
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        if (context != null && context.getController() != null) {
            this.undoHandler = context.getController().getUndoHandler();
        }
    }

    public void updateWorstNodes(final NodeScore[] nodes) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                WorstNodesCard.access$002(WorstNodesCard.this, nodes);
                ((WorstNodesView)WorstNodesCard.this.view).updateNodes(nodes);
                if (WorstNodesCard.this.pinView != null) {
                    ((WorstNodesView)WorstNodesCard.this.pinView).updateNodes(nodes);
                }
            }
        });
    }

    @Override
    public void jumpTo(int lid, NodeType type, JumpDestination descination) {
        NodesSelectedEvent event = new NodesSelectedEvent(lid, type, this, descination.getName());
        this.eventBus.publish((Object)event);
        if (this.undoHandler != null && !this.undoHandler.isInProgress()) {
            UndoableJumpEvent undoSel = new UndoableJumpEvent((MBassador<IAppEvent>)this.eventBus, new PageSelectedEvent(this, this.origin), event);
            this.undoHandler.addUndoAction(undoSel);
        }
    }

    @Override
    public IWorstNodesListener getCardListener() {
        return this;
    }

    @Override
    public void clear() {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                WorstNodesCard.access$002(WorstNodesCard.this, null);
                ((WorstNodesView)WorstNodesCard.this.view).clear();
                if (WorstNodesCard.this.pinView != null) {
                    ((WorstNodesView)WorstNodesCard.this.pinView).clear();
                }
            }
        });
    }

    @Override
    public void onMore() {
    }

    @Override
    public void onSizeChanged(int size) {
        ((WorstNodesView)this.view).setSize(size);
        if (this.pinView != null) {
            ((WorstNodesView)this.pinView).setSize(size);
        }
    }

    @Override
    protected void generateArgument(Properties arg) {
    }

    @Override
    protected WorstNodesView createPinView() {
        WorstNodesView pinView = new WorstNodesView();
        pinView.setCardListener(this.getCardListener());
        return pinView;
    }

    @Override
    protected void initPinView() {
        if (this.lastNodes != null) {
            ((WorstNodesView)this.pinView).updateNodes(this.lastNodes);
        }
    }

    @Override
    public PinDescription.PinID getPinID() {
        return PinDescription.PinID.WORST;
    }

    static /* synthetic */ NodeScore[] access$002(WorstNodesCard x0, NodeScore[] x1) {
        x0.lastNodes = x1;
        return x1;
    }
}

