/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main.view;

import com.intel.stl.api.FMGuiPlugin;
import com.intel.stl.api.StatementClosedException;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.ui.common.EventTableController;
import com.intel.stl.ui.common.EventTableModel;
import com.intel.stl.ui.common.IPageController;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.EventSummaryBarPanel;
import com.intel.stl.ui.common.view.EventTableView;
import com.intel.stl.ui.common.view.IntelTabbedPaneUI;
import com.intel.stl.ui.common.view.ProgressPanel;
import com.intel.stl.ui.main.FabricController;
import com.intel.stl.ui.main.FabricModel;
import com.intel.stl.ui.main.view.IFabricView;
import com.intel.stl.ui.main.view.IPageListener;
import com.intel.stl.ui.main.view.IProgressListener;
import com.intel.stl.ui.main.view.PinBoardView;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.VerticalLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FVMainFrame
extends JFrame
implements IFabricView,
ChangeListener,
IProgressListener {
    private final Logger log = LoggerFactory.getLogger(FVMainFrame.class);
    private static final long serialVersionUID = 6591005475727108668L;
    private static final String INIT_PANEL = "init panel";
    private static final String CONTENT_PANEL = "content panel";
    private static final String SUBNET_PROPERTY = "subnet";
    private JSplitPane mSplPnTopLevel;
    private JPanel mInitTopLevel;
    private CardLayout mCardLayout;
    private JSplitPane leftPane;
    private JTabbedPane mTabbedTopLevel;
    private JToolBar toolBar;
    private JButton refreshBtn;
    private JButton undoBtn;
    private JButton redoBtn;
    private JPanel mPnlPinBoard;
    private PinBoardView pinBoardView;
    private EventSummaryBarPanel eventSummaryBarPanel;
    private EventTableModel mEventTableModel;
    private EventTableView mEventTableView;
    private EventTableController mEventTableController;
    private FabricController controller;
    private JMenu connecttoMenu;
    private JMenuItem closeMenu;
    private JMenuItem wizardMenu;
    private JMenuItem loggingMenu;
    private JMenuItem randomMenu;
    private JMenuItem hideNodesMenu;
    private JMenuItem onlineHelpMenu;
    private JMenuItem aboutMenu;
    private JMenuItem emailMenu;
    private JPanel glassPanel;
    private String subnetName;
    private ProgressPanel progressPanel;
    private String currentTab;
    private Dimension screenSize;
    private Rectangle screenBounds;
    private IPageListener listener;
    private final List<String> progressLabels = new ArrayList<String>();

    public FVMainFrame(String subnetName) {
        super(STLConstants.K0001_FABRIC_VIEWER_TITLE.getValue());
        this.subnetName = subnetName;
        this.setName(STLConstants.K0001_FABRIC_VIEWER_TITLE.getValue() + "_" + subnetName);
    }

    @Override
    public void setSubnetName(String subnetName) {
        this.subnetName = subnetName;
    }

    @Override
    public String getSubnetName() {
        return this.subnetName;
    }

    @Override
    public void showInitScreen(Rectangle bounds, boolean maximized) {
        if (this.controller.getHideInactiveNodes()) {
            this.hideNodesMenu.doClick();
        }
        this.createConnectMenu();
        this.mCardLayout.show(this.getContentPane(), INIT_PANEL);
        this.setBounds(bounds);
        this.setVisible(true);
        if (maximized) {
            this.setExtendedState(this.getExtendedState() | 6);
        }
    }

    public void setController(FabricController controller) {
        this.controller = controller;
    }

    public void initComponents() {
        this.setDefaultCloseOperation(0);
        this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.screenSize.width = (int)((double)this.screenSize.width * 0.8);
        this.screenSize.height = (int)((double)this.screenSize.height * 0.8);
        this.setPreferredSize(this.screenSize);
        Image[] images = new Image[]{UIImages.LOGO_24.getImage(), UIImages.LOGO_32.getImage(), UIImages.LOGO_64.getImage(), UIImages.LOGO_128.getImage()};
        this.setIconImages(Arrays.asList(images));
        this.installMenus();
        JPanel panel = (JPanel)this.getContentPane();
        this.mCardLayout = new CardLayout();
        panel.setLayout(this.mCardLayout);
        this.mInitTopLevel = this.createInitPanel();
        panel.add(INIT_PANEL, this.mInitTopLevel);
        this.progressPanel = new ProgressPanel(false, this);
        this.glassPanel = new JPanel();
        this.glassPanel.setOpaque(false);
        this.glassPanel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 0;
        gc.anchor = 10;
        this.glassPanel.add((Component)this.progressPanel, gc);
        this.glassPanel.addMouseListener(new MouseAdapter(){});
        this.glassPanel.addMouseMotionListener(new MouseMotionAdapter(){});
        this.glassPanel.addKeyListener(new KeyAdapter(){});
        this.setGlassPane(this.glassPanel);
        this.installActions();
        this.pack();
    }

    private JSplitPane createContentPane() {
        JSplitPane pane = new JSplitPane(1);
        pane.setContinuousLayout(true);
        pane.setResizeWeight(0.7);
        pane.setDividerSize(5);
        this.mPnlPinBoard = new JPanel();
        this.mPnlPinBoard.setLayout(new BorderLayout());
        this.mPnlPinBoard.setOpaque(false);
        this.mPnlPinBoard.setMinimumSize(new Dimension(100, 300));
        this.eventSummaryBarPanel = new EventSummaryBarPanel();
        this.eventSummaryBarPanel.setVisible(true);
        this.mPnlPinBoard.add((Component)this.eventSummaryBarPanel, "North");
        this.mPnlPinBoard.setVisible(true);
        this.mPnlPinBoard.setBackground(UIConstants.INTEL_WHITE);
        this.pinBoardView = new PinBoardView();
        this.pinBoardView.setOpaque(false);
        JScrollPane scrollPane = new JScrollPane(this.pinBoardView);
        scrollPane.getViewport().setBackground(UIConstants.INTEL_WHITE);
        this.mPnlPinBoard.add((Component)scrollPane, "Center");
        pane.setRightComponent(this.mPnlPinBoard);
        this.leftPane = new JSplitPane(0);
        this.leftPane.setContinuousLayout(true);
        this.leftPane.setResizeWeight(0.8);
        this.leftPane.setDividerSize(4);
        this.leftPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (((FVMainFrame)FVMainFrame.this).mEventTableView.getSize().height < ((FVMainFrame)FVMainFrame.this).mEventTableView.getMinimumSize().height) {
                    int newLoc = ((FVMainFrame)FVMainFrame.this).leftPane.getSize().height - ((FVMainFrame)FVMainFrame.this).mEventTableView.getMinimumSize().height - 4;
                    FVMainFrame.this.leftPane.setDividerLocation(newLoc);
                }
            }
        });
        this.mTabbedTopLevel = new JTabbedPane(){
            private static final long serialVersionUID = -638815127814812316L;

            @Override
            public void setSelectedIndex(int index) {
                if (FVMainFrame.this.listener == null || FVMainFrame.this.listener.canPageChange(FVMainFrame.this.currentTab, FVMainFrame.this.mTabbedTopLevel.getTitleAt(index))) {
                    super.setSelectedIndex(index);
                }
            }
        };
        this.mTabbedTopLevel.addChangeListener(this);
        IntelTabbedPaneUI tabUi = new IntelTabbedPaneUI();
        JPanel ctrPanel = tabUi.getControlPanel();
        this.initTabCtrlPanel(ctrPanel);
        this.mTabbedTopLevel.setUI(tabUi);
        this.leftPane.setTopComponent(this.mTabbedTopLevel);
        this.mEventTableModel = new EventTableModel();
        this.mEventTableView = new EventTableView(this.mEventTableModel);
        this.mEventTableView.setMinimumSize(new Dimension(200, 64));
        this.mEventTableView.setVisible(false);
        this.mEventTableController = new EventTableController(this.mEventTableModel, this.mEventTableView);
        this.leftPane.setBottomComponent(this.mEventTableView);
        pane.setLeftComponent(this.leftPane);
        return pane;
    }

    private void initTabCtrlPanel(JPanel ctrPanel) {
        ctrPanel.setLayout(new BorderLayout());
        ctrPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        JLabel intelLogo = new JLabel(UIImages.LOGO_32.getImageIcon());
        ctrPanel.add((Component)intelLogo, "East");
        Component toolbar = this.createTabToolbar();
        ctrPanel.add(toolbar, "Center");
    }

    protected Component createTabToolbar() {
        JPanel panel = new JPanel();
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.undoBtn = new JButton(UIImages.UNDO.getImageIcon());
        this.toolBar.add(this.undoBtn);
        this.redoBtn = new JButton(UIImages.REDO.getImageIcon());
        this.toolBar.add(this.redoBtn);
        this.refreshBtn = new JButton(STLConstants.K0107_REFRESH.getValue(), UIImages.REFRESH.getImageIcon()){
            private static final long serialVersionUID = 1L;

            @Override
            public void setEnabled(boolean b) {
                super.setEnabled(b);
                this.setForeground(b ? UIConstants.INTEL_MEDIUM_DARK_BLUE : UIConstants.INTEL_GRAY);
            }
        };
        this.refreshBtn.setFont(UIConstants.H4_FONT);
        this.refreshBtn.setForeground(UIConstants.INTEL_MEDIUM_DARK_BLUE);
        this.refreshBtn.setEnabled(false);
        this.toolBar.add(this.refreshBtn);
        panel.add(this.toolBar);
        return panel;
    }

    private JPanel createInitPanel() {
        JPanel pnlInit = new JPanel(new BorderLayout());
        pnlInit.setBackground(UIConstants.INTEL_BLUE);
        JLabel lblWelcome = ComponentFactory.getH2Label(UILabels.STL50093_WELCOME_FM_GUI.getDescription(), 1);
        lblWelcome.setForeground(UIConstants.INTEL_WHITE);
        lblWelcome.setHorizontalAlignment(0);
        pnlInit.add((Component)lblWelcome, "North");
        pnlInit.add(Box.createVerticalStrut(25));
        JPanel pnlInstructions = new JPanel((LayoutManager)new VerticalLayout(20));
        pnlInstructions.setBackground(UIConstants.INTEL_WHITE);
        pnlInstructions.add(Box.createVerticalStrut(50));
        JLabel lblSelectSubnet = ComponentFactory.getH3Label(UILabels.STL50091_CONNECT_TO_SUBNET.getDescription(), 2);
        lblSelectSubnet.setHorizontalAlignment(0);
        pnlInstructions.add(lblSelectSubnet);
        JLabel lblOr = ComponentFactory.getH3Label(STLConstants.K3040_OR.getValue(), 2);
        lblOr.setHorizontalAlignment(0);
        pnlInstructions.add(lblOr);
        JLabel lblConfigureSubnet = ComponentFactory.getH3Label(UILabels.STL50092_CONFIGURE_SUBNET.getDescription(), 2);
        lblConfigureSubnet.setHorizontalAlignment(0);
        pnlInstructions.add(lblConfigureSubnet);
        pnlInit.add((Component)pnlInstructions, "Center");
        return pnlInit;
    }

    private void installMenus() {
        JMenuBar menubar = new JMenuBar();
        this.setJMenuBar(menubar);
        JMenu subnet = new JMenu(STLConstants.K0007_SUBNET.getValue());
        menubar.add(subnet);
        this.connecttoMenu = new JMenu(STLConstants.K0069_CONNECT_TO.getValue());
        subnet.add(this.connecttoMenu);
        this.closeMenu = new JMenuItem(STLConstants.K0740_CLOSE.getValue());
        subnet.add(this.closeMenu);
        JMenu conf = new JMenu(STLConstants.K0054_CONFIGURE.getValue());
        menubar.add(conf);
        this.wizardMenu = new JMenuItem(STLConstants.K0689_WIZARD.getValue(), UIImages.SETTING_ICON.getImageIcon());
        conf.add(this.wizardMenu);
        this.loggingMenu = new JMenuItem(STLConstants.K0669_LOGGING.getValue(), UIImages.LOG_MENU_ICON.getImageIcon());
        conf.add(this.loggingMenu);
        this.emailMenu = new JMenuItem(STLConstants.K5001_EMAIL_MENU_ITEM_TEXT.getValue(), UIImages.EMAIL_ICON.getImageIcon());
        conf.add(this.emailMenu);
        if (FMGuiPlugin.IS_DEV) {
            this.randomMenu = ComponentFactory.getIntelCheckBoxMenuItem(STLConstants.K0057_RANDOM.getValue());
            conf.add(this.randomMenu);
        }
        this.hideNodesMenu = ComponentFactory.getIntelCheckBoxMenuItem(STLConstants.K5013_HIDE_INACTIVE_NODES_MENU_STR.getValue());
        conf.add(this.hideNodesMenu);
        JMenu help = new JMenu(STLConstants.K0037_HELP.getValue());
        this.onlineHelpMenu = new JMenuItem(STLConstants.K0112_ONLINE_HELP.getValue(), UIImages.HELP_ICON.getImageIcon());
        help.add(this.onlineHelpMenu);
        String aboutMenuStr = STLConstants.K3100_ABOUT_DIALOG.getValue();
        this.aboutMenu = new JMenuItem(aboutMenuStr);
        this.aboutMenu.setMnemonic(aboutMenuStr.charAt(0));
        help.add(this.aboutMenu);
        menubar.add(help);
    }

    private void installActions() {
        this.setAboutDialogAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FVMainFrame.this.controller.showAboutDialog();
            }
        });
        this.setWindowAction(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (FVMainFrame.this.listener == null || FVMainFrame.this.listener.canPageChange(FVMainFrame.this.currentTab, null)) {
                    FVMainFrame.this.dispose();
                    FVMainFrame.this.controller.onWindowClose();
                }
            }
        });
        this.setCloseAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FVMainFrame.this.listener == null || FVMainFrame.this.listener.canPageChange(FVMainFrame.this.currentTab, null)) {
                    FVMainFrame.this.controller.onMenuClose();
                }
            }
        });
        this.setWizardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FVMainFrame.this.controller.showSetupWizard(FVMainFrame.this.subnetName);
            }
        });
        this.setLoggingAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FVMainFrame.this.controller.showLoggingConfig();
            }
        });
        this.setEmailSettingsAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FVMainFrame.this.controller.showEmailSettingsDialog();
            }
        });
        if (FMGuiPlugin.IS_DEV) {
            this.setRandomAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean addRandomValues = ((JCheckBoxMenuItem)e.getSource()).isSelected();
                    if ((e.getModifiers() & 2) == 2) {
                        FVMainFrame.this.controller.startSimulatedFailover();
                    } else {
                        FVMainFrame.this.controller.applyRandomValue(addRandomValues);
                    }
                }
            });
        }
        this.setHideNodesAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FVMainFrame.this.controller.getCurrentSubnet() == null) {
                    return;
                }
                boolean hideInactiveNodes = ((JCheckBoxMenuItem)e.getSource()).isSelected();
                FVMainFrame.this.controller.onHideInactiveNodes(hideInactiveNodes);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent event) {
                if (!FVMainFrame.this.isFrameMaximized()) {
                    FVMainFrame.this.screenBounds = FVMainFrame.this.getBounds();
                }
            }

            @Override
            public void componentResized(ComponentEvent event) {
                if (!FVMainFrame.this.isFrameMaximized()) {
                    FVMainFrame.this.screenBounds = FVMainFrame.this.getBounds();
                }
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        String oldTab = this.currentTab;
        int index = this.mTabbedTopLevel.getSelectedIndex();
        this.currentTab = this.mTabbedTopLevel.getTitleAt(index);
        if (this.listener != null) {
            this.listener.onPageChanged(oldTab, this.currentTab);
        }
    }

    @Override
    public void showMessageAndExit(String message, String title) {
        Util.showErrorMessage(this, message);
        this.controller.onWindowClose();
    }

    @Override
    public void showMessage(String message, String title) {
        Util.showErrorMessage(this, message);
    }

    @Override
    public void showErrors(List<Throwable> errors) {
        this.mInitTopLevel.removeAll();
        BoxLayout layout = new BoxLayout(this.mInitTopLevel, 1);
        this.mInitTopLevel.setLayout(layout);
        int numErrors = errors.size();
        JLabel label = numErrors == 1 ? ComponentFactory.getIntelH1Label(UILabels.STL10101_ONE_ERROR_INIT_APP.getDescription(), 0) : ComponentFactory.getIntelH1Label(UILabels.STL10100_ERRORS_INIT_APP.getDescription(errors.size()), 0);
        this.mInitTopLevel.add(label);
        for (Throwable e : errors) {
            label = ComponentFactory.getIntelH3Label(this.getErrorMsg(e), 0);
            this.mInitTopLevel.add(label);
        }
        this.mCardLayout.show(this.getContentPane(), INIT_PANEL);
        this.validate();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    protected String getErrorMsg(Throwable e) {
        String res = StringUtils.getErrorMessage(e);
        return res;
    }

    @Override
    public void showContent(List<IPageController> pages) {
        this.mTabbedTopLevel.removeChangeListener(this);
        for (IPageController page : pages) {
            this.mTabbedTopLevel.addTab(page.getName(), page.getIcon(), page.getView(), page.getDescription());
        }
        int index = this.mTabbedTopLevel.getSelectedIndex();
        this.currentTab = this.mTabbedTopLevel.getTitleAt(index);
        this.mTabbedTopLevel.addChangeListener(this);
        this.mCardLayout.show(this.getContentPane(), CONTENT_PANEL);
        Dimension d1 = this.mTabbedTopLevel.getMinimumSize();
        Dimension d2 = this.mEventTableView.getMinimumSize();
        int other = this.getJMenuBar().getHeight() + 4;
        int newMinHeight = d1.height + d2.height + other;
        this.setMinimumSize(new Dimension(this.getMinimumSize().width, newMinHeight));
        this.validate();
    }

    @Override
    public void close() {
        if (this.listener == null || this.listener.canPageChange(this.currentTab, null)) {
            this.dispatchEvent(new WindowEvent(this, 201));
        }
    }

    @Override
    public void resetConnectMenu() {
        this.createConnectMenu();
        this.validate();
    }

    private void createConnectMenu() {
        this.connecttoMenu.removeAll();
        List<SubnetDescription> subnets = this.controller.getSubnets();
        if (subnets == null || subnets.size() == 0) {
            this.connecttoMenu.setEnabled(false);
        } else {
            this.connecttoMenu.setEnabled(true);
            for (SubnetDescription subnet : subnets) {
                JMenuItem subnetConnectTo = this.createMenuItem(subnet);
                this.connecttoMenu.add(subnetConnectTo);
            }
        }
    }

    private JMenuItem createMenuItem(SubnetDescription subnet) {
        String subnetName = subnet.getName();
        JMenuItem newMenuItem = new JMenuItem(subnetName);
        newMenuItem.putClientProperty(SUBNET_PROPERTY, subnetName);
        newMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem menuItem = (JMenuItem)e.getSource();
                String subnetName = (String)menuItem.getClientProperty(FVMainFrame.SUBNET_PROPERTY);
                FVMainFrame.this.controller.selectSubnet(subnetName);
            }
        });
        return newMenuItem;
    }

    @Override
    public void setCurrentTab(IPageController page) {
        int ix = this.mTabbedTopLevel.indexOfComponent(page.getView());
        if (ix >= 0) {
            this.mTabbedTopLevel.setSelectedIndex(ix);
            this.currentTab = this.mTabbedTopLevel.getTitleAt(ix);
        }
    }

    @Override
    public void setWizardAction(ActionListener listener) {
        this.wizardMenu.addActionListener(listener);
    }

    @Override
    public void setLoggingAction(ActionListener listener) {
        this.loggingMenu.addActionListener(listener);
    }

    @Override
    public void setAboutDialogAction(ActionListener listener) {
        this.aboutMenu.addActionListener(listener);
    }

    @Override
    public void setEmailSettingsAction(ActionListener listener) {
        this.emailMenu.addActionListener(listener);
    }

    @Override
    public void setRandomAction(ActionListener listener) {
        this.randomMenu.addActionListener(listener);
    }

    public void setHelpAction(ActionListener listener) {
        this.onlineHelpMenu.addActionListener(listener);
    }

    public JMenuItem getOnlineHelpMenu() {
        return this.onlineHelpMenu;
    }

    public void setHideNodesAction(ActionListener listener) {
        this.hideNodesMenu.addActionListener(listener);
    }

    @Override
    public void setWindowAction(WindowListener listener) {
        this.addWindowListener(listener);
    }

    public void setCloseAction(ActionListener listener) {
        this.closeMenu.addActionListener(listener);
    }

    @Override
    public void setPageListener(IPageListener listener) {
        this.listener = listener;
    }

    @Override
    public void setRefreshAction(ActionListener listener) {
        this.refreshBtn.addActionListener(listener);
    }

    @Override
    public void setRefreshRunning(boolean isRunning) {
        if (this.refreshBtn != null) {
            this.refreshBtn.setIcon(isRunning ? UIImages.RUNNING.getImageIcon() : UIImages.REFRESH.getImageIcon());
        }
    }

    @Override
    public void setUndoAction(Action action) {
        this.undoBtn.setAction(action);
    }

    @Override
    public void setRedoAction(Action action) {
        this.redoBtn.setAction(action);
    }

    @Override
    public void cleanup() {
        this.dispose();
    }

    @Override
    public void clear() {
        this.mCardLayout.show(this.getContentPane(), INIT_PANEL);
        this.subnetName = null;
        this.setTitle(STLConstants.K0001_FABRIC_VIEWER_TITLE.getValue());
        this.mTabbedTopLevel.removeChangeListener(this);
        this.mTabbedTopLevel.removeAll();
        this.currentTab = null;
        this.mTabbedTopLevel.addChangeListener(this);
    }

    @Override
    public void bringToFront() {
        super.setVisible(true);
    }

    @Override
    public Rectangle getFrameBounds() {
        if (this.isFrameMaximized()) {
            return this.screenBounds;
        }
        return this.getBounds();
    }

    @Override
    public boolean isFrameMaximized() {
        return (this.getExtendedState() & 6) == 6;
    }

    @Override
    public EventSummaryBarPanel getEventSummaryBarPanel() {
        return this.eventSummaryBarPanel;
    }

    @Override
    public void setReady(boolean ready) {
        this.mTabbedTopLevel.setEnabled(ready);
        this.refreshBtn.setEnabled(ready);
        if (ready) {
            this.controller.processPendingTasks();
        }
    }

    @Override
    public boolean isReady() {
        return this.refreshBtn.isEnabled();
    }

    @Override
    public void toggleEventSummaryTable() {
        if (this.mEventTableView.isVisible()) {
            this.mEventTableView.setVisible(false);
            this.leftPane.remove(this.mEventTableView);
        } else {
            this.mEventTableView.setVisible(true);
            this.leftPane.setRightComponent(this.mEventTableView);
        }
    }

    @Override
    public void showEventSummaryTable() {
        this.mEventTableView.setVisible(true);
        this.leftPane.setRightComponent(this.mEventTableView);
    }

    @Override
    public void hideEventSummaryTable() {
        this.mEventTableView.setVisible(false);
        this.leftPane.remove(this.mEventTableView);
    }

    @Override
    public EventTableController getEventTableController() {
        return this.mEventTableController;
    }

    @Override
    public void displayErrorMessage(String windowTitle, Exception exception) {
        Util.showError(this, exception);
    }

    @Override
    public void showProgress(String label, boolean visible) {
        if (visible) {
            this.progressLabels.add(label);
            this.progressPanel.setLabel(label);
        } else {
            int last = this.progressLabels.size() - 1;
            if (last >= 0) {
                this.progressLabels.remove(last);
                last = this.progressLabels.size() - 1;
                if (last >= 0) {
                    this.progressPanel.setLabel(this.progressLabels.get(last));
                } else {
                    this.progressPanel.setLabel("");
                }
            }
        }
        this.glassPanel.setVisible(visible);
    }

    @Override
    public void showFailoverProgress(String label, boolean visible) {
        if (visible) {
            this.progressPanel.setCancellable(true);
        } else {
            this.progressPanel.setCancellable(false);
        }
        this.showProgress(label, visible);
    }

    @Override
    public void setProgress(int progress) {
        if (!this.glassPanel.isVisible() && progress < 100) {
            this.glassPanel.setVisible(true);
        }
        this.progressPanel.setProgress(progress);
    }

    @Override
    public void setProgressNote(String note) {
        if (!this.glassPanel.isVisible() && this.progressPanel.getPercentComplete() < 1.0) {
            this.glassPanel.setVisible(true);
        }
        this.progressPanel.setProgressNote(note);
    }

    @Override
    public Component getView() {
        return this;
    }

    public PinBoardView getPinBoardView() {
        return this.pinBoardView;
    }

    @Override
    public Dimension getScreenSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    @Override
    public void setScreenSize(Dimension dimension) {
        this.setPreferredSize(dimension);
    }

    @Override
    public Point getScreenPosition() {
        return new Point(this.getX(), this.getY());
    }

    public void modelUpdateFailed(FabricModel model, Throwable caught) {
        this.showProgress(null, false);
        this.setReady(true);
        if (caught instanceof InterruptedException || caught instanceof CancellationException) {
            return;
        }
        if (caught instanceof StatementClosedException) {
            this.log.error(caught.getMessage(), caught);
            return;
        }
        caught.printStackTrace();
        Util.showErrorMessage(this, model.getErrorMessage());
    }

    public void modelChanged(FabricModel model) {
        this.showProgress(null, false);
        SubnetDescription subnet = model.getCurrentSubnet();
        if (subnet == null) {
            this.subnetName = null;
            this.setupContentPane();
            this.mCardLayout.show(this.getContentPane(), INIT_PANEL);
            this.setTitle(STLConstants.K0001_FABRIC_VIEWER_TITLE.getValue());
        } else {
            this.setReady(true);
            this.subnetName = subnet.getName();
            this.mCardLayout.show(this.getContentPane(), CONTENT_PANEL);
            this.setTitle(STLConstants.K0001_FABRIC_VIEWER_TITLE.getValue() + " - " + this.subnetName);
        }
    }

    private void setupContentPane() {
        JPanel panel = (JPanel)this.getContentPane();
        if (this.mSplPnTopLevel != null) {
            panel.remove(this.mSplPnTopLevel);
        }
        this.mSplPnTopLevel = this.createContentPane();
        panel.add(CONTENT_PANEL, this.mSplPnTopLevel);
        this.setRefreshAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FVMainFrame.this.controller.onRefresh();
            }
        });
        this.setPageListener(this.controller);
    }

    public Component installGlassPanel(Component comp) {
        Component oldComp = null;
        if (this.glassPanel.getComponentCount() == 1) {
            oldComp = this.glassPanel.getComponent(0);
        } else if (this.glassPanel.getComponentCount() > 1) {
            throw new RuntimeException("Invalid glass panel!");
        }
        this.glassPanel.removeAll();
        this.glassPanel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 0;
        gc.anchor = 10;
        this.glassPanel.add(comp, gc);
        this.glassPanel.updateUI();
        return oldComp;
    }

    @Override
    public void onCancel() {
        this.controller.cancelFailover();
    }
}

