/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.main.view.AbstractNodeStatesView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.PieDataset;

public class NodeStatesPie
extends AbstractNodeStatesView {
    private static final long serialVersionUID = -7808133310065940957L;
    private ChartPanel chartPanel;
    private JPanel legendPanel;
    private JLabel[] stateLabels;
    private final boolean concise;

    public NodeStatesPie(boolean concise) {
        this.concise = concise;
        this.initcomponent();
    }

    protected void initcomponent() {
        this.setLayout(new GridBagLayout());
        this.chartPanel = new ChartPanel(null);
        this.chartPanel.setName(WidgetName.HP_STU_DIST_CHART.name());
        this.chartPanel.setPreferredSize(new Dimension(120, 90));
        GridBagConstraints gc = new GridBagConstraints();
        if (this.concise) {
            gc.gridwidth = 0;
        }
        this.add((Component)this.chartPanel, gc);
        if (!this.concise) {
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.gridwidth = 0;
            this.legendPanel = new JPanel();
            this.legendPanel.setOpaque(false);
            this.legendPanel.setLayout(new GridBagLayout());
            this.add((Component)this.legendPanel, gc);
        }
    }

    public void setDataset(PieDataset dataset, Color[] colors) {
        JFreeChart chart = ComponentFactory.createPlainPieChart(dataset, colors);
        this.chartPanel.setChart(chart);
        if (!this.concise) {
            this.fillLengendPanel(this.legendPanel, dataset, colors);
        }
    }

    protected void fillLengendPanel(JPanel panel, PieDataset dataset, Color[] colors) {
        panel.removeAll();
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 1;
        int size = dataset.getItemCount();
        this.stateLabels = new JLabel[size];
        for (int i = 0; i < size; ++i) {
            gc.insets = new Insets(2, 5, 2, 2);
            gc.weightx = 0.0;
            gc.gridwidth = 1;
            JLabel label = new JLabel(dataset.getKey(i).toString(), Util.generateImageIcon(colors[i], 8, new Insets(1, 1, 1, 1)), 2);
            label.setFont(UIConstants.H5_FONT);
            label.setForeground(UIConstants.INTEL_DARK_GRAY);
            panel.add((Component)label, gc);
            gc.gridwidth = 0;
            gc.weightx = 0.0;
            this.stateLabels[i] = new JLabel();
            this.stateLabels[i].setName(WidgetName.HP_STU_DIST_LABEL_.name() + i);
            this.stateLabels[i].setForeground(UIConstants.INTEL_DARK_GRAY);
            this.stateLabels[i].setFont(UIConstants.H3_FONT);
            panel.add((Component)this.stateLabels[i], gc);
        }
    }

    @Override
    public void setStates(double[] values, String[] labels, String[] tooltips) {
        if (this.concise) {
            return;
        }
        if (values.length != this.stateLabels.length) {
            throw new IllegalArgumentException("Incorrect array size. Expected " + this.stateLabels.length + " values, got " + values.length + " values.");
        }
        if (labels.length != this.stateLabels.length) {
            throw new IllegalArgumentException("Incorrect array size. Expected " + this.stateLabels.length + " labels, got " + labels.length + " labels.");
        }
        if (tooltips.length != this.stateLabels.length) {
            throw new IllegalArgumentException("Incorrect array size. Expected " + this.stateLabels.length + " tooltips, got " + tooltips.length + " tooltips.");
        }
        for (int i = 0; i < values.length; ++i) {
            this.stateLabels[i].setText(labels[i]);
            this.stateLabels[i].setToolTipText(tooltips[i]);
        }
    }

    public void clear() {
        if (this.stateLabels != null) {
            for (int i = 0; i < this.stateLabels.length; ++i) {
                this.stateLabels[i].setText(STLConstants.K0039_NOT_AVAILABLE.getValue());
                this.stateLabels[i].setToolTipText(null);
            }
        }
    }
}

