/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main.view;

import com.intel.stl.ui.main.view.NodeStatesBar;
import com.intel.stl.ui.main.view.NodeStatesPie;
import com.intel.stl.ui.model.ChartStyle;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;
import org.jfree.data.general.PieDataset;

public class NodeStatusPanel
extends JPanel {
    private static final long serialVersionUID = -5896416689826992723L;
    private ChartStyle style = ChartStyle.PIE;
    private final CardLayout layout = new CardLayout();
    private final NodeStatesBar barPanel;
    private final NodeStatesPie piePanel;

    public NodeStatusPanel() {
        this(false);
    }

    public NodeStatusPanel(boolean concise) {
        this.setLayout(this.layout);
        this.barPanel = new NodeStatesBar(concise);
        this.barPanel.setOpaque(false);
        this.add((Component)this.barPanel, ChartStyle.BAR.name());
        this.piePanel = new NodeStatesPie(concise);
        this.piePanel.setOpaque(false);
        this.add((Component)this.piePanel, ChartStyle.PIE.name());
        this.layout.show(this, ChartStyle.PIE.name());
    }

    public void setStyle(ChartStyle style) {
        this.style = style;
        this.layout.show(this, style.name());
    }

    public void setDataset(PieDataset dataset, Color[] colors) {
        this.piePanel.setDataset(dataset, colors);
    }

    public void setStates(double[] values, String[] labels, String[] tooltips) {
        if (this.style == ChartStyle.PIE) {
            this.piePanel.setStates(values, labels, tooltips);
        } else if (this.style == ChartStyle.BAR) {
            this.barPanel.setStates(values, labels, tooltips);
        }
    }

    public void clear() {
        this.barPanel.clear();
        this.piePanel.clear();
    }
}

