/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main.view;

import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.ICardListener;
import com.intel.stl.ui.common.view.ILabelListener;
import com.intel.stl.ui.common.view.JCardView;
import com.intel.stl.ui.common.view.JScrollablePanel;
import com.intel.stl.ui.configuration.view.PropertyVizStyle;
import com.intel.stl.ui.main.view.PerfErrorsItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PerfErrorsCardView
extends JCardView<ICardListener> {
    private static final long serialVersionUID = 2L;
    Map<JLabel, String> keys = new LinkedHashMap<JLabel, String>();
    List<JLabel> values = new ArrayList<JLabel>();
    private JScrollPane scrollPane;
    private JPanel totalPanel;
    private JPanel propCardPanel;
    private PropertyVizStyle style = new PropertyVizStyle();
    private GroupLayout groupLayout;
    private Collection<PerfErrorsItem> itemList;
    private ILabelListener labelListener;
    private JLabel oldSelectedLabel;

    public PerfErrorsCardView() {
        this("");
    }

    public PerfErrorsCardView(String title) {
        super(title);
        this.getMainComponent();
    }

    public void initializeErrorsItems(Collection<PerfErrorsItem> itemList) {
        this.itemList = itemList;
        this.initializeErrorsItems();
    }

    public synchronized void setStyle(PropertyVizStyle style) {
        this.style = style;
        this.initializeErrorsItems();
    }

    @Override
    protected JComponent getMainComponent() {
        if (this.totalPanel == null) {
            this.totalPanel = new JPanel();
            this.totalPanel.setLayout(new BorderLayout());
            this.totalPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        if (this.propCardPanel == null) {
            this.propCardPanel = new JScrollablePanel(){
                private static final long serialVersionUID = 1015603074892983212L;

                @Override
                public boolean getScrollableTracksViewportWidth() {
                    return true;
                }
            };
            this.groupLayout = new GroupLayout(this.propCardPanel);
            this.propCardPanel.setLayout(this.groupLayout);
            this.propCardPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 12));
            this.propCardPanel.setBackground(UIConstants.INTEL_WHITE);
        }
        this.scrollPane = new JScrollPane(this.propCardPanel);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.totalPanel.add((Component)this.scrollPane, "Center");
        return this.totalPanel;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.scrollPane != null && this.scrollPane != null) {
            int width = this.propCardPanel.getPreferredSize().width + this.scrollPane.getVerticalScrollBar().getPreferredSize().width;
            int height = super.getPreferredSize().height;
            return new Dimension(width, height);
        }
        return super.getPreferredSize();
    }

    private void initializeErrorsItems() {
        int itemSize = this.itemList.size();
        this.propCardPanel.removeAll();
        this.oldSelectedLabel = null;
        this.keys.clear();
        this.values.clear();
        GroupLayout.SequentialGroup hGroup = this.groupLayout.createSequentialGroup();
        GroupLayout.SequentialGroup vGroup = this.groupLayout.createSequentialGroup();
        GroupLayout.ParallelGroup[] row = new GroupLayout.ParallelGroup[itemSize];
        for (int i = 0; i < itemSize; ++i) {
            row[i] = this.groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE);
            vGroup.addGroup(row[i]);
        }
        Iterator<PerfErrorsItem> itr = this.itemList.iterator();
        int itemCt = 0;
        GroupLayout.ParallelGroup keyCol = this.groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER);
        GroupLayout.ParallelGroup valCol = this.groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER);
        hGroup.addGap(35);
        hGroup.addGroup(keyCol);
        hGroup.addGroup(valCol);
        for (int j = 0; j < itemSize; ++j) {
            if (itemCt < itemSize) {
                JLabel value;
                JLabel key;
                PerfErrorsItem vItem = itr.next();
                if (vItem.isTtl()) {
                    key = this.createHeaderKey(vItem.getKeyStr(), j);
                    value = this.createHeaderValue("", j);
                } else {
                    String keyStr = vItem.getKeyStr();
                    if (vItem.isFromNeighbor()) {
                        keyStr = keyStr + "*";
                    }
                    key = this.createKey(keyStr, vItem.getHelpID(), j);
                    if (vItem.isFromNeighbor()) {
                        key.setToolTipText(UILabels.STL40014_BILL_NEIGHBOR.getDescription());
                    }
                    value = this.createValue(vItem.getValStr(), j);
                    if (this.oldSelectedLabel == null) {
                        this.oldSelectedLabel = key;
                    }
                }
                this.keys.put(key, vItem.getHelpID());
                this.values.add(value);
                row[j].addComponent(key);
                row[j].addComponent(value);
                keyCol.addComponent(key);
                valCol.addComponent(value);
            }
            ++itemCt;
        }
        this.groupLayout.linkSize(0, (Component[])this.keys.keySet().toArray(new JLabel[0]));
        this.groupLayout.linkSize(0, (Component[])this.values.toArray(new JLabel[0]));
        this.groupLayout.setHorizontalGroup(hGroup);
        this.groupLayout.setVerticalGroup(vGroup);
        this.propCardPanel.repaint();
        this.revalidate();
    }

    protected JLabel createKey(String text, final String helpID, int row) {
        final JLabel label = ComponentFactory.getH4Label(text, 0);
        label.setOpaque(true);
        label.setBackground(UIConstants.INTEL_WHITE);
        label.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 3));
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PerfErrorsCardView.this.selecteLabel(label, helpID);
            }
        });
        this.style.decorateKey(label, row);
        return label;
    }

    public void selectLabel(String name) {
        JLabel toSelect = this.oldSelectedLabel;
        for (JLabel label : this.keys.keySet()) {
            if (!label.getText().equals(name)) continue;
            toSelect = label;
            break;
        }
        if (toSelect != null) {
            this.selecteLabel(toSelect, this.keys.get(toSelect));
        }
    }

    protected void selecteLabel(JLabel label, String helpID) {
        this.labelListener.onLabelClick(label.getText(), helpID);
        label.setForeground(UIConstants.INTEL_WHITE);
        label.setBackground(UIConstants.INTEL_LIGHT_BLUE);
        if (label != this.oldSelectedLabel && this.oldSelectedLabel != null) {
            this.oldSelectedLabel.setForeground(UIConstants.INTEL_DARK_GRAY);
            this.oldSelectedLabel.setBackground(UIConstants.INTEL_WHITE);
        }
        this.propCardPanel.repaint();
        this.revalidate();
        this.oldSelectedLabel = label;
    }

    protected JLabel createValue(String text, int row) {
        JLabel label = ComponentFactory.getH4Label(text, 0);
        label.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 2));
        this.style.decorateValue(label, row);
        return label;
    }

    protected JLabel createHeaderKey(String text, int row) {
        JLabel label = ComponentFactory.getH4Label(text, 0);
        this.style.decorateHeaderKey(label, row);
        return label;
    }

    protected JLabel createHeaderValue(String text, int row) {
        JLabel label = ComponentFactory.getH4Label(text, 0);
        this.style.decorateHeaderValue(label);
        return label;
    }

    public synchronized void updateErrorsItems(Collection<PerfErrorsItem> itemList) {
        this.itemList = itemList;
        Iterator<PerfErrorsItem> itr = itemList.iterator();
        int i = 0;
        while (itr.hasNext()) {
            PerfErrorsItem vItem = itr.next();
            if (!vItem.isTtl()) {
                JLabel value = this.values.get(i);
                value.setText(vItem.getValStr());
            }
            ++i;
        }
        this.propCardPanel.repaint();
        this.revalidate();
    }

    public void setLabelListener(ILabelListener labelListener) {
        this.labelListener = labelListener;
    }
}

