/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.main.view;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.ICardListener;
import com.intel.stl.ui.common.view.JCardView;
import com.intel.stl.ui.common.view.JDuration;
import com.intel.stl.ui.main.view.StaDetailsPanel;
import com.intel.stl.ui.model.NodeTypeViz;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StatisticsView
extends JCardView<ICardListener> {
    private static final long serialVersionUID = -5447526254155197323L;
    private static Font NUM_FONT = UIConstants.H3_FONT.deriveFont(1);
    private static Color NUM_COLOR = UIConstants.INTEL_DARK_GRAY;
    private static Font LABEL_FONT = UIConstants.H4_FONT;
    private static Font SMALL_LABEL_FONT = UIConstants.H5_FONT;
    private static Color LABEL_COLOR = UIConstants.INTEL_DARK_GRAY;
    private JPanel mainPanel;
    private BaseInfoPanel baseInfoPanel;
    private StaDetailsPanel nodesPanel;
    private StaDetailsPanel portsPanel;

    public StatisticsView() {
        super(STLConstants.K0007_SUBNET.getValue());
        this.setName(WidgetName.HP_STA_TITLE.name());
        this.getMainComponent();
    }

    @Override
    protected JPanel getMainComponent() {
        if (this.mainPanel != null) {
            return this.mainPanel;
        }
        this.mainPanel = new JPanel(new BorderLayout(5, 5));
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 5));
        this.baseInfoPanel = new BaseInfoPanel();
        this.mainPanel.add((Component)this.baseInfoPanel, "West");
        JPanel body = new JPanel(new GridLayout(1, 2, 15, 1));
        body.setOpaque(false);
        NodeTypeViz[] nodeTypes = new NodeTypeViz[]{NodeTypeViz.SWITCH, NodeTypeViz.HFI};
        this.nodesPanel = new StaDetailsPanel(nodeTypes);
        this.nodesPanel.setName(WidgetName.HP_STA_NODES_SUM.name());
        body.add(this.nodesPanel);
        nodeTypes = new NodeTypeViz[]{NodeTypeViz.SWITCH, NodeTypeViz.HFI};
        this.portsPanel = new StaDetailsPanel(nodeTypes);
        this.portsPanel.setName(WidgetName.HP_STA_PORTS_SUM.name());
        body.add(this.portsPanel);
        this.mainPanel.add((Component)body, "Center");
        this.setHelpButtonName(WidgetName.HP_STA_HELP.name());
        this.setPinButtonName(WidgetName.HP_STA_PIN.name());
        return this.mainPanel;
    }

    public StaDetailsPanel getNodesPanel() {
        return this.nodesPanel;
    }

    public StaDetailsPanel getPortsPanel() {
        return this.portsPanel;
    }

    public void setDuration(long duration, TimeUnit unit) {
        this.baseInfoPanel.setDuration(duration, unit);
    }

    public void setMsmName(String name, String description) {
        this.baseInfoPanel.setMsmName(name, description);
    }

    public void setStandbySMNames(String[] names, String[] descriptions) {
        this.baseInfoPanel.setStandbySMNames(names, descriptions);
    }

    public void setNumSwitchLinks(String number) {
        this.baseInfoPanel.setNumSwitchLinks(number);
    }

    public void setNumHostLinks(String number) {
        this.baseInfoPanel.setNumHostLinks(number);
    }

    public void setOtherPorts(String number) {
        this.baseInfoPanel.setOtherPorts(number);
    }

    public void clear() {
        this.setTitle(STLConstants.K0007_SUBNET.getValue());
        this.baseInfoPanel.clear();
        this.repaint();
    }

    class BaseInfoPanel
    extends JPanel {
        private static final long serialVersionUID = 4249046807614016076L;
        private JLabel msmNameLabel;
        private JDuration durationLabel;
        private JPanel standbySMsPanel;
        private JLabel numberSwitchLinksLabel;
        private JLabel numberHostLinksLabel;
        private JLabel otherPortsLabel;

        public BaseInfoPanel() {
            this.initComponents();
        }

        protected void initComponents() {
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            GridBagConstraints gc = new GridBagConstraints();
            Insets labelInset = new Insets(2, 5, 1, 15);
            Insets contentInset = new Insets(0, 20, 3, 1);
            gc.insets = new Insets(0, 5, 1, 15);
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.gridwidth = 0;
            gc.weighty = 0.0;
            JLabel label = this.createNameLabel(STLConstants.K0025_MASTER_SM.getValue());
            this.add((Component)label, gc);
            gc.insets = contentInset;
            this.msmNameLabel = this.createNumberLabel(STLConstants.K0039_NOT_AVAILABLE.getValue());
            this.msmNameLabel.setName(WidgetName.HP_STA_MASTER_SM.name());
            this.add((Component)this.msmNameLabel, gc);
            gc.insets = labelInset;
            label = this.createNameLabel(STLConstants.K0008_UPTIME.getValue());
            this.add((Component)label, gc);
            gc.insets = contentInset;
            gc.fill = 0;
            gc.anchor = 17;
            this.durationLabel = new JDuration();
            this.durationLabel.setName(WidgetName.HP_STA_MSM_UPTIME.name());
            this.durationLabel.setOpaque(false);
            this.durationLabel.setLAF(NUM_FONT, NUM_COLOR, SMALL_LABEL_FONT, LABEL_COLOR);
            this.add((Component)this.durationLabel, gc);
            gc.insets = labelInset;
            gc.fill = 2;
            label = this.createNameLabel(STLConstants.K0059_STANDBY_SMS.getValue());
            this.add((Component)label, gc);
            gc.insets = contentInset;
            this.standbySMsPanel = new JPanel();
            this.standbySMsPanel.setName(WidgetName.HP_STA_STANDBY_SMS.name());
            this.standbySMsPanel.setOpaque(false);
            this.standbySMsPanel.setLayout(new BoxLayout(this.standbySMsPanel, 1));
            this.add((Component)this.standbySMsPanel, gc);
            gc.insets = labelInset;
            label = this.createNameLabel(STLConstants.K0013_LINKS.getValue());
            this.add((Component)label, gc);
            gc.insets = contentInset;
            gc.fill = 0;
            gc.anchor = 14;
            gc.gridwidth = 1;
            this.numberSwitchLinksLabel = this.createNumberLabel(STLConstants.K0039_NOT_AVAILABLE.getValue());
            this.numberSwitchLinksLabel.setName(WidgetName.HP_STA_ISL.name());
            this.add((Component)this.numberSwitchLinksLabel, gc);
            gc.insets = labelInset;
            gc.anchor = 16;
            gc.gridwidth = 0;
            label = this.createNameLabel(STLConstants.K0060_ISL.getValue(), SMALL_LABEL_FONT);
            this.add((Component)label, gc);
            gc.insets = contentInset;
            gc.anchor = 14;
            gc.gridwidth = 1;
            this.numberHostLinksLabel = this.createNumberLabel(STLConstants.K0039_NOT_AVAILABLE.getValue());
            this.numberHostLinksLabel.setName(WidgetName.HP_STA_HOST_LINKS.name());
            this.add((Component)this.numberHostLinksLabel, gc);
            gc.insets = labelInset;
            gc.anchor = 16;
            gc.gridwidth = 0;
            label = this.createNameLabel(STLConstants.K0061_HOST_LINKS.getValue(), SMALL_LABEL_FONT);
            this.add((Component)label, gc);
            gc.insets = labelInset;
            label = this.createNameLabel(STLConstants.K2071_OTHER_PORTS.getValue());
            this.add((Component)label, gc);
            gc.insets = contentInset;
            gc.fill = 0;
            gc.anchor = 14;
            gc.gridwidth = 1;
            this.otherPortsLabel = this.createNumberLabel(STLConstants.K0039_NOT_AVAILABLE.getValue());
            this.otherPortsLabel.setName(WidgetName.HP_STA_OTHER_PORTS.name());
            this.otherPortsLabel.setForeground(UIConstants.INTEL_GRAY);
            this.add((Component)this.otherPortsLabel, gc);
            gc.insets = labelInset;
            gc.anchor = 16;
            gc.gridwidth = 0;
            label = this.createNameLabel(STLConstants.K2077_NOT_IN_FABRIC.getValue(), SMALL_LABEL_FONT);
            this.add((Component)label, gc);
            gc.weighty = 1.0;
            this.add(Box.createGlue(), gc);
        }

        public void setDuration(long duration, TimeUnit unit) {
            this.durationLabel.setDuration(duration, unit);
        }

        public void setMsmName(String name, String description) {
            if (name == null) {
                this.msmNameLabel.setText(STLConstants.K0039_NOT_AVAILABLE.getValue());
            } else {
                this.msmNameLabel.setText(name);
                this.msmNameLabel.setToolTipText(description);
            }
        }

        public void setStandbySMNames(String[] names, String[] descriptions) {
            this.standbySMsPanel.removeAll();
            if (names == null || names.length == 0) {
                this.standbySMsPanel.add(this.createNumberLabel(STLConstants.K0039_NOT_AVAILABLE.getValue()));
            } else {
                for (int i = 0; i < names.length; ++i) {
                    JLabel label = this.createNumberLabel(names[i]);
                    label.setToolTipText(descriptions[i]);
                    this.standbySMsPanel.add(label);
                }
            }
            this.revalidate();
        }

        public void setNumSwitchLinks(String number) {
            if (number == null) {
                this.numberSwitchLinksLabel.setText(STLConstants.K0039_NOT_AVAILABLE.getValue());
            } else {
                this.numberSwitchLinksLabel.setText(number);
            }
        }

        public void setNumHostLinks(String number) {
            if (number == null) {
                this.numberHostLinksLabel.setText(STLConstants.K0039_NOT_AVAILABLE.getValue());
            } else {
                this.numberHostLinksLabel.setText(number);
            }
        }

        public void setOtherPorts(String number) {
            if (number == null) {
                this.otherPortsLabel.setText(STLConstants.K0039_NOT_AVAILABLE.getValue());
            } else {
                this.otherPortsLabel.setText(number);
            }
        }

        protected JLabel createNumberLabel(String text) {
            JLabel label = new JLabel(text);
            label.setFont(NUM_FONT);
            label.setForeground(NUM_COLOR);
            label.setHorizontalAlignment(2);
            label = ComponentFactory.deriveLabel(label, false, 250);
            return label;
        }

        protected JLabel createNameLabel(String text) {
            return this.createNameLabel(text, LABEL_FONT);
        }

        protected JLabel createNameLabel(String text, Font font) {
            JLabel label = new JLabel(text);
            label.setFont(font);
            label.setForeground(LABEL_COLOR);
            label.setHorizontalAlignment(2);
            return label;
        }

        protected void clear() {
            this.setMsmName(null, null);
            this.setStandbySMNames(null, null);
            this.setNumSwitchLinks(null);
            this.setNumHostLinks(null);
            this.setOtherPorts(null);
            this.durationLabel.clear();
        }
    }
}

