/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.configuration.PropertyCategory;
import com.intel.stl.api.configuration.ResourceCategory;
import com.intel.stl.ui.configuration.ICategoryProcessorContext;
import com.intel.stl.ui.configuration.ResourceCategoryMap;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyItem;
import com.intel.stl.ui.model.IPropertyCategory;
import com.intel.stl.ui.model.ModelCollection;
import java.util.Collection;
import java.util.EnumMap;

public class DevicePropertyCategory
extends ModelCollection<DevicePropertyItem>
implements IPropertyCategory<DevicePropertyItem> {
    private final EnumMap<DeviceProperty, DevicePropertyItem> propertyMap = new EnumMap(DeviceProperty.class);
    private final PropertyCategory category;
    private final ResourceCategoryMap categoryMap;

    public DevicePropertyCategory(PropertyCategory category) {
        this.category = category;
        ResourceCategory resourceCat = category.getResourceCategory();
        this.categoryMap = ResourceCategoryMap.getResourceCategoryMapFor(resourceCat);
    }

    public ResourceCategory getCategory() {
        return this.category.getResourceCategory();
    }

    @Override
    public String getKeyHeader() {
        String keyHeader = null;
        if (this.category.isShowHeader()) {
            String usrKeyHeader = this.category.getKeyHeader();
            keyHeader = usrKeyHeader == null || usrKeyHeader.length() == 0 ? this.categoryMap.getDefaultKeyHeader() : usrKeyHeader;
        }
        return keyHeader;
    }

    @Override
    public String getValueHeader() {
        String valueHeader = null;
        if (this.category.isShowHeader()) {
            String usrValueHeader = this.category.getKeyHeader();
            valueHeader = usrValueHeader == null || usrValueHeader.length() == 0 ? this.categoryMap.getDefaultValueHeader() : usrValueHeader;
        }
        return valueHeader;
    }

    public EnumMap<DeviceProperty, DevicePropertyItem> getProperties() {
        return this.propertyMap;
    }

    public int getNumProperties() {
        return this.propertyMap.size();
    }

    public DevicePropertyItem getProperty(DeviceProperty property) {
        DevicePropertyItem res = this.propertyMap.get(property);
        if (res != null) {
            return res;
        }
        throw new IllegalArgumentException("Couldn't find DeviceProperty " + property);
    }

    public void addPropertyItem(DevicePropertyItem item) {
        this.propertyMap.put((DeviceProperty)((Enum)item.getKey()), item);
        this.addItem(item);
    }

    public void populate(ICategoryProcessorContext context) {
        this.categoryMap.getProcessor().process(context, this);
    }

    @Override
    public Collection<DevicePropertyItem> getItems() {
        return this.getList();
    }
}

