/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.configuration.FocusStatus;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public enum FocusStatusViz {
    OK(FocusStatus.OK, STLConstants.K0645_OK.getValue(), UIConstants.INTEL_DARK_GRAY),
    PMA_IGNORE(FocusStatus.PMA_IGNORE, STLConstants.K0212_PMA_IGNORE.getValue(), UIConstants.INTEL_BLUE),
    PMA_NORESP(FocusStatus.PMA_NORESP, STLConstants.K0213_PMA_NORESP.getValue(), UIConstants.INTEL_DARK_YELLOW),
    TOPO_NORESP(FocusStatus.TOPO_NORESP, STLConstants.K0214_TOPO_NORESP.getValue(), UIConstants.INTEL_DARK_RED);

    private static final Map<Byte, FocusStatusViz> focusStatusMap;
    private final FocusStatus status;
    private final String value;
    private final Color color;

    private FocusStatusViz(FocusStatus status, String value, Color color) {
        this.status = status;
        this.value = value;
        this.color = color;
    }

    public FocusStatus getStatus() {
        return this.status;
    }

    public String getValue() {
        return this.value;
    }

    public Color getColor() {
        return this.color;
    }

    public static FocusStatusViz getFocusStatusViz(byte status) {
        FocusStatusViz res = focusStatusMap.get(status);
        if (res == null) {
            throw new IllegalArgumentException("Unknow status '" + status + "'!");
        }
        return res;
    }

    static {
        focusStatusMap = new HashMap<Byte, FocusStatusViz>();
        for (FocusStatusViz ffv : FocusStatusViz.values()) {
            focusStatusMap.put(ffv.status.getCode(), ffv);
        }
    }
}

