/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import java.awt.Color;
import java.util.EnumMap;

public final class NodeTypeViz
extends Enum<NodeTypeViz> {
    public static final /* enum */ NodeTypeViz HFI;
    public static final /* enum */ NodeTypeViz SWITCH;
    public static final /* enum */ NodeTypeViz ROUTER;
    public static final /* enum */ NodeTypeViz OTHER;
    public static final String[] names;
    public static final Color[] colors;
    private final NodeType type;
    private final String name;
    private final String pluralName;
    private final Color color;
    private final UIImages icon;
    private static final /* synthetic */ NodeTypeViz[] $VALUES;

    public static NodeTypeViz[] values() {
        return (NodeTypeViz[])$VALUES.clone();
    }

    public static NodeTypeViz valueOf(String name) {
        return Enum.valueOf(NodeTypeViz.class, name);
    }

    private NodeTypeViz(NodeType type, String name, String pluralName, Color color, UIImages icon) {
        this.type = type;
        this.name = name;
        this.pluralName = pluralName;
        this.color = color;
        this.icon = icon;
    }

    public NodeType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getPluralName() {
        return this.pluralName;
    }

    public Color getColor() {
        return this.color;
    }

    public UIImages getIcon() {
        return this.icon;
    }

    public static NodeTypeViz getNodeTypeViz(byte id) {
        NodeType type = NodeType.getNodeType(id);
        return NodeTypeViz.getNodeTypeViz(type);
    }

    public static NodeTypeViz getNodeTypeViz(NodeType type) {
        for (NodeTypeViz ntv : NodeTypeViz.values()) {
            if (ntv.type != type) continue;
            return ntv;
        }
        return null;
    }

    public static long[] getDistributionValues2(EnumMap<NodeType, Integer> counts) {
        NodeTypeViz[] all = NodeTypeViz.values();
        long[] res = new long[all.length];
        for (int i = 0; i < res.length; ++i) {
            Integer val = counts.get((Object)all[i].type);
            res[i] = val == null ? 0L : (long)val.intValue();
        }
        return res;
    }

    public static long[] getDistributionValues(EnumMap<NodeType, Long> counts) {
        NodeTypeViz[] all = NodeTypeViz.values();
        long[] res = new long[all.length];
        for (int i = 0; i < res.length; ++i) {
            Long val = counts.get((Object)all[i].type);
            res[i] = val == null ? 0L : val;
        }
        return res;
    }

    static {
        int i;
        HFI = new NodeTypeViz(NodeType.HFI, STLConstants.K0110_HFI.getValue(), STLConstants.K0111_HFIS.getValue(), UIConstants.INTEL_BLUE, UIImages.HFI_ICON);
        SWITCH = new NodeTypeViz(NodeType.SWITCH, STLConstants.K0017_SWITCH.getValue(), STLConstants.K0048_SWITCHES.getValue(), UIConstants.INTEL_GREEN, UIImages.SW_ICON);
        ROUTER = new NodeTypeViz(NodeType.ROUTER, STLConstants.K0019_ROUTER.getValue(), STLConstants.K0050_ROUTERS.getValue(), UIConstants.INTEL_ORANGE, UIImages.ROUTER_ICON);
        OTHER = new NodeTypeViz(NodeType.OTHER, STLConstants.K0109_OTHERS.getValue(), STLConstants.K0109_OTHERS.getValue(), UIConstants.INTEL_GRAY, null);
        $VALUES = new NodeTypeViz[]{HFI, SWITCH, ROUTER, OTHER};
        names = new String[NodeTypeViz.values().length];
        for (i = 0; i < names.length; ++i) {
            NodeTypeViz.names[i] = NodeTypeViz.values()[i].name;
        }
        colors = new Color[NodeTypeViz.values().length];
        for (i = 0; i < colors.length; ++i) {
            NodeTypeViz.colors[i] = NodeTypeViz.values()[i].color;
        }
    }
}

