/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.subnet.OutputModuleType;
import com.intel.stl.ui.common.STLConstants;

public enum OutputModuleTypeViz {
    SDR(OutputModuleType.SDR, STLConstants.K1139_CABLE_SDR.getValue()),
    DDR(OutputModuleType.DDR, STLConstants.K1140_CABLE_DDR.getValue()),
    QDR(OutputModuleType.QDR, STLConstants.K1141_CABLE_QDR.getValue()),
    FDR(OutputModuleType.FDR, STLConstants.K1142_CABLE_FDR.getValue()),
    EDR(OutputModuleType.EDR, STLConstants.K1143_CABLE_EDR.getValue()),
    UNKNOWN(OutputModuleType.UNKNOWN, STLConstants.K0016_UNKNOWN.getValue());

    private final OutputModuleType type;
    private final String name;

    private OutputModuleTypeViz(OutputModuleType type, String name) {
        this.type = type;
        this.name = name;
    }

    public OutputModuleType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public static String getOutputModuleTypeVizFor(OutputModuleType[] types) throws Exception {
        OutputModuleTypeViz[] values = OutputModuleTypeViz.values();
        StringBuffer sb = new StringBuffer();
        for (int i = values.length - 1; i >= 0; --i) {
            for (OutputModuleType type : types) {
                if (type != values[i].getType()) continue;
                sb.append(values[i].getName() + " ");
            }
        }
        return sb.toString();
    }
}

