/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.configuration.CapabilityMask;
import com.intel.stl.api.configuration.LinkSpeedMask;
import com.intel.stl.api.configuration.LinkWidthMask;
import com.intel.stl.api.configuration.MTUSize;
import com.intel.stl.api.configuration.PhysicalState;
import com.intel.stl.api.configuration.PortState;
import com.intel.stl.api.subnet.LinkRecordBean;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.api.subnet.PortInfoBean;
import com.intel.stl.api.subnet.PortRecordBean;
import com.intel.stl.api.subnet.PortStatesBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.model.LinkSpeedMaskViz;
import com.intel.stl.ui.model.LinkWidthMaskViz;
import com.intel.stl.ui.model.MTUSizeViz;
import com.intel.stl.ui.model.NodeProperties;
import com.intel.stl.ui.model.PhysicalStateViz;
import com.intel.stl.ui.model.PortStateViz;
import java.util.List;

@Deprecated
public class PortProperties
extends NodeProperties {
    private PortRecordBean portRec = null;
    private PortInfoBean portInfo = null;
    private NodeRecordBean nodeRec = null;
    private LinkRecordBean linkRec = null;
    private NodeType nodeType = null;
    private String neighborNodeDesc = null;
    boolean hasData = false;
    boolean isEndPort = false;

    public PortProperties() {
    }

    public PortProperties(PortRecordBean ptRec, NodeRecordBean ndRec, LinkRecordBean lnkRec) {
        super(ndRec, null);
        if (ptRec != null && ndRec != null) {
            this.portRec = ptRec;
            this.nodeRec = ndRec;
            this.linkRec = lnkRec;
            if (this.portRec.getPortInfo() != null) {
                this.portInfo = this.portRec.getPortInfo();
                this.nodeType = NodeType.getNodeType(this.nodeRec.getNodeInfo().getNodeType());
                short portIdx = this.nodeRec.getNodeInfo().getLocalPortNum();
                if (this.nodeType != NodeType.SWITCH || portIdx == 0) {
                    this.isEndPort = true;
                }
            }
        }
        this.hasData = this.portInfo != null;
    }

    public String getLID() {
        String retVal = "";
        if (this.hasData) {
            retVal = this.isEndPort ? StringUtils.intHexString(this.portInfo.getLid()) : STLConstants.K0383_NA.getValue();
        }
        return retVal;
    }

    public String getState() {
        String retVal = "";
        if (this.hasData) {
            if (this.portInfo == null) {
                throw new RuntimeException("portInfo is null in getState.");
            }
            PortStatesBean portState = this.portInfo.getPortStates();
            if (portState != null) {
                PortState ptState = portState.getPortState();
                retVal = ptState != null ? PortStateViz.getPortStateStr(ptState) : STLConstants.K0387_UNKNOWN.getValue();
            }
        }
        return retVal;
    }

    public String getPhysicalState() {
        PortStatesBean PortState2;
        String retVal = "";
        if (this.hasData && (PortState2 = this.portInfo.getPortStates()) != null) {
            PhysicalState phyState = PortState2.getPortPhysicalState();
            retVal = phyState != null ? PhysicalStateViz.getPhysicalStateStr(phyState) : STLConstants.K0387_UNKNOWN.getValue();
        }
        return retVal;
    }

    public String getSubnetPrefix() {
        String retVal = "";
        if (this.hasData) {
            retVal = this.isEndPort ? StringUtils.longHexString(this.portInfo.getSubnetPrefix()) : STLConstants.K0383_NA.getValue();
        }
        return retVal;
    }

    public String getUniversalDiagCode() {
        String retVal = "";
        if (this.hasData) {
            if (this.isEndPort) {
                byte val = this.portInfo.getUniversalDiagCode();
                retVal = Integer.toString(val);
            } else {
                retVal = STLConstants.K0383_NA.getValue();
            }
        }
        return retVal;
    }

    public String getVendorDiagCode() {
        String retVal = "";
        if (this.hasData) {
            if (this.isEndPort) {
                short val = this.portInfo.getVendorDiagCode();
                retVal = Integer.toString(val);
            } else {
                retVal = STLConstants.K0383_NA.getValue();
            }
        }
        return retVal;
    }

    public String getNeighborMTUSize() {
        String retVal = "";
        if (this.hasData) {
            byte val = this.portInfo.getNeighborVL0MTU()[0];
            MTUSize mtusize = MTUSize.getMTUSize(val);
            retVal = mtusize != null ? MTUSizeViz.getMTUSizeStr(mtusize) : STLConstants.K0387_UNKNOWN.getValue();
        }
        return retVal;
    }

    public String getMTUCapability() {
        String retVal = "";
        if (this.hasData) {
            MTUSize mtusize = this.portInfo.getMtuCap();
            retVal = mtusize != null ? MTUSizeViz.getMTUSizeStr(mtusize) : STLConstants.K0387_UNKNOWN.getValue();
        }
        return retVal;
    }

    public String getLinkWidthEnabled() {
        String retVal = "";
        if (this.hasData) {
            short val = this.portInfo.getLinkWidthEnabled();
            retVal = this.getLinkWidthString(val);
        }
        return retVal;
    }

    public String getLinkWidthSupported() {
        String retVal = "";
        if (this.hasData) {
            short val = this.portInfo.getLinkWidthSupported();
            retVal = this.getLinkWidthString(val);
        }
        return retVal;
    }

    public String getLinkWidthActive() {
        String retVal = "";
        if (this.hasData) {
            short val = this.portInfo.getLinkWidthActive();
            retVal = this.getLinkWidthString(val);
        }
        return retVal;
    }

    public String getLinkWidthDnGrdEnabled() {
        String retVal = "";
        if (this.hasData) {
            short val = this.portInfo.getLinkWidthDownEnabled();
            retVal = this.getLinkWidthString(val);
        }
        return retVal;
    }

    public String getLinkWidthDnGrdSupported() {
        String retVal = "";
        if (this.hasData) {
            short val = this.portInfo.getLinkWidthDownSupported();
            retVal = this.getLinkWidthString(val);
        }
        return retVal;
    }

    public String getLinkWidthDnGrdTx() {
        String retVal = "";
        if (this.hasData) {
            short val = this.portInfo.getLinkWidthDownTxActive();
            retVal = this.getLinkWidthString(val);
        }
        return retVal;
    }

    public String getLinkWidthDnGrdRx() {
        String retVal = "";
        if (this.hasData) {
            short val = this.portInfo.getLinkWidthDownRxActive();
            retVal = this.getLinkWidthString(val);
        }
        return retVal;
    }

    private String getLinkWidthString(short val) {
        StringBuilder lwStr = new StringBuilder();
        String join = "";
        String or = " " + STLConstants.K0388_OR.getValue() + " ";
        List<LinkWidthMask> masks = LinkWidthMask.getWidthMasks(val);
        for (LinkWidthMask mask : masks) {
            lwStr.append(join);
            lwStr.append(LinkWidthMaskViz.getLinkWidthMaskStr(mask));
            join = or;
        }
        return lwStr.toString();
    }

    public String getLinkSpeedEnabled() {
        String retVal = "";
        if (this.hasData) {
            short val = this.portInfo.getLinkSpeedEnabled();
            retVal = this.getLinkSpeedString(val);
        }
        return retVal;
    }

    public String getLinkSpeedSupported() {
        String retVal = "";
        if (this.hasData) {
            short val = this.portInfo.getLinkSpeedSupported();
            retVal = this.getLinkSpeedString(val);
        }
        return retVal;
    }

    public String getLinkSpeedActive() {
        String retVal = "";
        if (this.hasData) {
            short val = this.portInfo.getLinkSpeedActive();
            retVal = this.getLinkSpeedString(val);
        }
        return retVal;
    }

    private String getLinkSpeedString(short val) {
        StringBuffer ret = new StringBuffer();
        String or = " " + STLConstants.K0388_OR.getValue() + " ";
        String orConn = "";
        List<LinkSpeedMask> masks = LinkSpeedMask.getSpeedMasks(val);
        for (LinkSpeedMask mask : masks) {
            ret.append(orConn);
            ret.append(LinkSpeedMaskViz.getLinkSpeedMaskStr(mask));
            orConn = or;
        }
        return ret.toString();
    }

    public void setNeighborNodeDesc(String neighborNodeDesc) {
        this.neighborNodeDesc = neighborNodeDesc;
    }

    public String getLinkToNodeDesc() {
        String retVal = "";
        if (this.hasData) {
            retVal = this.linkRec == null ? STLConstants.K0383_NA.getValue() : this.neighborNodeDesc;
        }
        return retVal;
    }

    public String getLinkToGUID() {
        String retVal = "";
        if (this.hasData) {
            retVal = this.linkRec == null ? STLConstants.K0383_NA.getValue() : StringUtils.longHexString(this.portInfo.getNeighborNodeGUID());
        }
        return retVal;
    }

    public String getLinkToPortIndex() {
        String retVal = "";
        if (this.hasData) {
            retVal = this.linkRec == null ? STLConstants.K0383_NA.getValue() : Integer.toString(this.linkRec.getToPortIndex());
        }
        return retVal;
    }

    public String getSMCapability() {
        String retVal = "";
        if (this.hasData) {
            int val;
            retVal = this.isEndPort ? (CapabilityMask.HAS_SM.hasThisMask(val = this.portInfo.getCapabilityMask()) ? STLConstants.K0385_TRUE.getValue() : STLConstants.K0386_FALSE.getValue()) : STLConstants.K0383_NA.getValue();
        }
        return retVal;
    }

    public String getNoticeCapability() {
        String retVal = "";
        if (this.hasData) {
            int val;
            retVal = this.isEndPort ? (CapabilityMask.HAS_NOTICE.hasThisMask(val = this.portInfo.getCapabilityMask()) ? STLConstants.K0385_TRUE.getValue() : STLConstants.K0386_FALSE.getValue()) : STLConstants.K0383_NA.getValue();
        }
        return retVal;
    }

    public String getVendorCapability() {
        String retVal = "";
        if (this.hasData) {
            int val;
            retVal = this.isEndPort ? (CapabilityMask.HAS_VENDORCLASS.hasThisMask(val = this.portInfo.getCapabilityMask()) ? STLConstants.K0385_TRUE.getValue() : STLConstants.K0386_FALSE.getValue()) : STLConstants.K0383_NA.getValue();
        }
        return retVal;
    }

    public String getDeviceManCapability() {
        String retVal = "";
        if (this.hasData) {
            int val;
            retVal = this.isEndPort ? (CapabilityMask.HAS_DEVICEMANAGEMENT.hasThisMask(val = this.portInfo.getCapabilityMask()) ? STLConstants.K0385_TRUE.getValue() : STLConstants.K0386_FALSE.getValue()) : STLConstants.K0383_NA.getValue();
        }
        return retVal;
    }

    public String getConnManCapability() {
        String retVal = "";
        if (this.hasData) {
            int val;
            retVal = this.isEndPort ? (CapabilityMask.HAS_CONNECTIONMANAGEMENT.hasThisMask(val = this.portInfo.getCapabilityMask()) ? STLConstants.K0385_TRUE.getValue() : STLConstants.K0386_FALSE.getValue()) : STLConstants.K0383_NA.getValue();
        }
        return retVal;
    }

    public String getAutoMigCapability() {
        String retVal = "";
        if (this.hasData) {
            int val;
            retVal = this.isEndPort ? (CapabilityMask.HAS_AUTOMIGRATION.hasThisMask(val = this.portInfo.getCapabilityMask()) ? STLConstants.K0385_TRUE.getValue() : STLConstants.K0386_FALSE.getValue()) : STLConstants.K0383_NA.getValue();
        }
        return retVal;
    }

    public String getVLCap() {
        String retVal = "";
        if (this.hasData) {
            byte cap = this.portInfo.getVl().getCap();
            retVal = Byte.toString(cap);
        }
        return retVal;
    }

    public String getHighLimit() {
        if (this.hasData) {
            return Integer.toString(this.portInfo.getVl().getHighLimit());
        }
        return "";
    }

    public String getHiArbitrationCap() {
        if (this.hasData) {
            return Short.toString(this.portInfo.getVl().getArbitrationHighCap());
        }
        return "";
    }

    public String getLowArbitrationCap() {
        if (this.hasData) {
            return Short.toString(this.portInfo.getVl().getArbitrationLowCap());
        }
        return "";
    }

    public String getVLStallCount() {
        String retVal = "";
        if (this.hasData) {
            retVal = this.nodeType == NodeType.SWITCH ? Byte.toString(this.portInfo.getVlStallCount()[0]) : STLConstants.K0383_NA.getValue();
        }
        return retVal;
    }

    public String getHOQlifeLabel() {
        String retVal = "";
        if (this.hasData) {
            retVal = this.nodeType != NodeType.HFI ? Byte.toString(this.portInfo.getHoqLife()[0]) : STLConstants.K0383_NA.getValue();
        }
        return retVal;
    }

    public String getOperationalVLs() {
        String retVal = "";
        if (this.hasData) {
            byte cap = this.portInfo.getOperationalVL();
            retVal = Byte.toString(cap);
        }
        return retVal;
    }

    public String getMastersSMSL() {
        String retVal = "";
        if (this.hasData) {
            retVal = this.isEndPort ? Byte.toString(this.portInfo.getMasterSMSL()) : STLConstants.K0383_NA.getValue();
        }
        return retVal;
    }

    public String getMKeyViolations() {
        String retVal = "";
        if (this.hasData) {
            retVal = this.isEndPort ? Short.toString(this.portInfo.getMKeyViolation()) : STLConstants.K0383_NA.getValue();
        }
        return retVal;
    }

    public String getPKeyViolations() {
        String retVal = "";
        if (this.hasData) {
            retVal = this.isEndPort ? Short.toString(this.portInfo.getPKeyViolation()) : STLConstants.K0383_NA.getValue();
        }
        return retVal;
    }

    public String getQKeyViolations() {
        String retVal = "";
        if (this.hasData) {
            retVal = this.isEndPort ? Short.toString(this.portInfo.getQKeyViolation()) : STLConstants.K0383_NA.getValue();
        }
        return retVal;
    }

    public String getSubnetTimeout() {
        String retVal = "";
        if (this.hasData) {
            if (this.isEndPort) {
                double exp = Math.pow(2.0, this.portInfo.getSubnetTimeout());
                double val = 4.096 * exp;
                retVal = Double.toString(val);
            } else {
                retVal = STLConstants.K0383_NA.getValue();
            }
        }
        return retVal;
    }

    public String getRespTime() {
        String retVal = "";
        if (this.hasData) {
            if (this.isEndPort) {
                double exp = Math.pow(2.0, this.portInfo.getRespTimeValue());
                double val = 4.096 * exp;
                retVal = Double.toString(val);
            } else {
                retVal = STLConstants.K0383_NA.getValue();
            }
        }
        return retVal;
    }

    public String getPartEnforceIn() {
        String retVal = "";
        if (this.hasData) {
            retVal = this.nodeType == NodeType.SWITCH ? (this.portInfo.isPartitionEnforcementInbound() ? STLConstants.K0385_TRUE.getValue() : STLConstants.K0386_FALSE.getValue()) : STLConstants.K0383_NA.getValue();
        }
        return retVal;
    }

    public String getPartEnforceOut() {
        String retVal = "";
        if (this.hasData) {
            retVal = this.nodeType == NodeType.SWITCH ? (this.portInfo.isPartitionEnforcementOutbound() ? STLConstants.K0385_TRUE.getValue() : STLConstants.K0386_FALSE.getValue()) : STLConstants.K0383_NA.getValue();
        }
        return retVal;
    }

    public String getMKey() {
        String retVal = "";
        if (this.hasData) {
            retVal = this.isEndPort ? Long.toString(this.portInfo.getMKey()) : STLConstants.K0383_NA.getValue();
        }
        return retVal;
    }

    public String getMasterLID() {
        String retVal = "";
        if (this.hasData) {
            retVal = this.isEndPort ? StringUtils.intHexString(this.portInfo.getMasterSMLID()) : STLConstants.K0383_NA.getValue();
        }
        return retVal;
    }

    public String getMKeyLeasePeriod() {
        String retVal = "";
        if (this.hasData) {
            retVal = this.isEndPort ? Integer.toString(this.portInfo.getMKeyLeasePeriod()) : STLConstants.K0383_NA.getValue();
        }
        return retVal;
    }
}

