/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.notice.NoticeSeverity;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.model.NodeScore;
import com.intel.stl.ui.model.TimedScore;
import com.intel.stl.ui.publisher.IEventFilter;
import com.intel.stl.ui.publisher.NodeEvents;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class StateSummary
implements Serializable {
    private static final long serialVersionUID = 8192055300607833656L;
    private final Map<NodeType, Integer> baseNodesDist;
    private int baseTotalSWs;
    private int baseTotalHFIs;
    private int baseTotalNodes;
    private TimedScore healthScore;
    private EnumMap<NoticeSeverity, Integer> switchStates;
    private EnumMap<NoticeSeverity, Integer> hfiStates;
    private NodeScore[] worstNodes;
    private List<NodeEvents> events;

    public StateSummary(Map<NodeType, Integer> baseNodesDist) {
        this.baseNodesDist = baseNodesDist;
        for (NodeType type : baseNodesDist.keySet()) {
            Integer count = baseNodesDist.get((Object)type);
            if (type == NodeType.SWITCH) {
                this.baseTotalSWs = count;
            } else if (type == NodeType.HFI) {
                this.baseTotalHFIs = count;
            }
            this.baseTotalNodes += count.intValue();
        }
    }

    public Map<NodeType, Integer> getBaseNodesDist() {
        return this.baseNodesDist;
    }

    public int getBaseTotalSWs() {
        return this.baseTotalSWs;
    }

    public int getBaseTotalHFIs() {
        return this.baseTotalHFIs;
    }

    public int getBaseTotalNodes() {
        return this.baseTotalNodes;
    }

    public TimedScore getHealthScore() {
        return this.healthScore;
    }

    public void setHealthScore(TimedScore healthScore) {
        this.healthScore = healthScore;
    }

    public EnumMap<NoticeSeverity, Integer> getSwitchStates() {
        return this.switchStates;
    }

    public void setSwitchStates(EnumMap<NoticeSeverity, Integer> switchStates) {
        this.switchStates = switchStates;
    }

    public EnumMap<NoticeSeverity, Integer> getHfiStates() {
        return this.hfiStates;
    }

    public void setHfiStates(EnumMap<NoticeSeverity, Integer> hfiStates) {
        this.hfiStates = hfiStates;
    }

    public NodeScore[] getWorstNodes() {
        return this.worstNodes;
    }

    public void setWorstNodes(NodeScore[] worstNodes) {
        this.worstNodes = worstNodes;
    }

    public List<NodeEvents> getEvents() {
        return this.events;
    }

    public void setEvents(List<NodeEvents> events) {
        this.events = events;
    }

    public EnumMap<NoticeSeverity, Integer> getStates(IEventFilter filter) {
        EnumMap<NoticeSeverity, Integer> res = new EnumMap<NoticeSeverity, Integer>(NoticeSeverity.class);
        int[] counts = new int[NoticeSeverity.values().length];
        for (NodeEvents e : this.events) {
            NoticeSeverity overallSeverity;
            if (filter != null && !filter.accept(e.getLid(), e.getNodeType()) || (overallSeverity = e.getOverallSeverity()) == null) continue;
            int n = overallSeverity.ordinal();
            counts[n] = counts[n] + 1;
        }
        for (int i = 0; i < counts.length; ++i) {
            res.put(NoticeSeverity.values()[i], counts[i]);
        }
        return res;
    }

    public String toString() {
        return "StateSummary [healthScore=" + this.healthScore + ", switchStates=" + this.switchStates + ", hfiStates=" + this.hfiStates + ", worstNodes=" + Arrays.toString(this.worstNodes) + ", events=" + this.events + "]";
    }
}

