/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.model;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.subnet.LFTRecordBean;
import com.intel.stl.api.subnet.MFTRecordBean;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.SwitchRecordBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.model.NodeProperties;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class SwitchProperties
extends NodeProperties {
    private SwitchRecordBean swRec = null;
    private NodeRecordBean nodeRec = null;
    private List<LFTRecordBean> lftRecs = null;
    private List<MFTRecordBean> mftRecs = null;
    private List<String> deviceGrp = null;
    boolean hasData = false;

    public SwitchProperties(SwitchRecordBean swR, NodeRecordBean nodeR, List<LFTRecordBean> lftR, List<MFTRecordBean> mftR, List<String> grp) {
        super(nodeR, grp);
        this.swRec = swR;
        this.lftRecs = lftR;
        this.mftRecs = mftR;
        this.nodeRec = nodeR;
        this.deviceGrp = grp;
        if (this.swRec != null && this.nodeRec != null && this.lftRecs != null && this.mftRecs != null && this.swRec.getSwitchInfo() != null && this.deviceGrp != null) {
            this.hasData = true;
        }
    }

    public String getIPChassisName() {
        String retVal = STLConstants.K0383_NA.getValue();
        return retVal;
    }

    public String getNumEntries() {
        if (this.hasData) {
            return Integer.toString(this.swRec.getSwitchInfo().getPartitionEnforcementCap());
        }
        return "";
    }

    public String getEnhancedPort0Support() {
        String retVal = "";
        if (this.hasData) {
            retVal = this.swRec.getSwitchInfo().isEnhancedPort0() ? STLConstants.K0385_TRUE.getValue() : STLConstants.K0386_FALSE.getValue();
        }
        return retVal;
    }

    public List<String[]> getLIDsAndForwardedPorts() {
        ArrayList<String[]> retVal = new ArrayList<String[]>();
        if (this.hasData) {
            for (LFTRecordBean lft : this.lftRecs) {
                int lid = lft.getBlockNum() * 64;
                byte[] retPts = lft.getLinearFdbData();
                int i = 0;
                while (i < retPts.length) {
                    if (retPts[i] != -1) {
                        retVal.add(new String[]{StringUtils.intHexString(lid), Short.toString((short)(retPts[i] & 0xFF))});
                    }
                    ++i;
                    ++lid;
                }
            }
        }
        return retVal;
    }

    public List<String[]> getLIDsAndMultiForwardedPorts() {
        ArrayList<String[]> retVal = new ArrayList<String[]>();
        if (this.hasData) {
            for (MFTRecordBean mft : this.mftRecs) {
                int lid = mft.getBlockNum() * 8 + 49152;
                long[] retMasks = mft.getMftTable();
                int i = 0;
                while (i < retMasks.length) {
                    if (retMasks[i] > 0L) {
                        retVal.add(new String[]{StringUtils.intHexString(lid), StringUtils.longHexString(retMasks[i])});
                    }
                    ++i;
                    ++lid;
                }
            }
        }
        return retVal;
    }
}

