/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor;

import com.intel.stl.api.configuration.PropertyCategory;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.configuration.CableInfoProcessor;
import com.intel.stl.ui.configuration.CategoryProcessorContext;
import com.intel.stl.ui.configuration.ResourceCategoryMap;
import com.intel.stl.ui.configuration.view.PropertyGroupPanel;
import com.intel.stl.ui.configuration.view.PropertyVizStyle;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.model.DeviceProperty;
import com.intel.stl.ui.model.DevicePropertyCategory;
import com.intel.stl.ui.model.DevicePropertyGroup;
import com.intel.stl.ui.model.DevicePropertyItem;
import com.intel.stl.ui.model.PropertySet;
import com.intel.stl.ui.monitor.ICableInfoListener;
import com.intel.stl.ui.monitor.view.CableInfoPopupView;
import com.intel.stl.ui.publisher.CallbackAdapter;
import com.intel.stl.ui.publisher.CancellableCall;
import com.intel.stl.ui.publisher.SingleTaskManager;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CableInfoPopupController
implements ICableInfoListener {
    private static final Logger log = LoggerFactory.getLogger(CableInfoPopupController.class);
    private Context context;
    private DevicePropertyCategory category;
    private final CableInfoProcessor cableInfoProcessor;
    private final SingleTaskManager taskMgr;
    private List<DevicePropertyItem> itemList;
    private final PropertyVizStyle style = new PropertyVizStyle(true, false);
    private final CableInfoPopupView view;

    public CableInfoPopupController(CableInfoPopupView view) {
        this.cableInfoProcessor = new CableInfoProcessor();
        this.taskMgr = new SingleTaskManager();
        this.view = view;
    }

    public void setContext(Context context, IProgressObserver observer) {
        this.context = context;
    }

    protected PropertySet<DevicePropertyGroup> updateModel(List<DevicePropertyItem> itemList) {
        PropertySet<DevicePropertyGroup> cableInfoModel = null;
        PropertyCategory propCategory = new PropertyCategory();
        propCategory.setResourceCategory(ResourceCategoryMap.CABLE_INFO.getResourceCategory());
        DevicePropertyCategory cat = new DevicePropertyCategory(propCategory);
        if (itemList == null) {
            String NA = STLConstants.K0039_NOT_AVAILABLE.getValue();
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_ID, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_POWER_CLASS, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_TX_CDR_SUP, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_RX_CDR_SUP, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_CONNECTOR, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_NOMINAL_BR, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_SMF_LEN, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_OM3_LEN, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_OM2_LEN, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_OM1_LEN, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_COPPER_LEN, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_DEVICE_TECH, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_VENDOR_NAME, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_EXT_MODULE, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_VENDOR_OUI, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_VENDOR_PN, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_VENDOR_REV, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_OPTICAL_WL, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_MAXCASE_TEMP, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_CC_BASE, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_CC_BASE, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_TX_INP_EQ_AUTO_ADP, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_TX_INP_EQ_FIX_PROG, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_RX_OUTP_EMPH_FIX_PROG, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_RX_OUTP_AMPL_FIX_PROG, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_TX_CDR_ON_OFF_CTRL, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_RX_CDR_ON_OFF_CTRL, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_MEM_PAGE02_PROV, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_MEM_PAGE01_PROV, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_VENDOR_SN, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_DATE_CODE, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_LOT_CODE, (Object)NA));
            cat.addPropertyItem(new DevicePropertyItem(DeviceProperty.CABLE_CC_EXT, (Object)NA));
        } else {
            cat.setList(itemList);
        }
        DevicePropertyGroup propertyGroup = new DevicePropertyGroup();
        propertyGroup.addPropertyCategory(cat);
        cableInfoModel = new PropertySet<DevicePropertyGroup>();
        cableInfoModel.addPropertyGroup(propertyGroup);
        PropertyGroupPanel groupPanel = new PropertyGroupPanel(this.style);
        for (DevicePropertyGroup group : cableInfoModel.getGroups()) {
            groupPanel.setModel(group);
            groupPanel.enableHelp(false);
        }
        return cableInfoModel;
    }

    @Override
    public void onCableInfoSelection(final int lid, long portGuid, final short portNum, NodeType nodeType) {
        CancellableCall<Void> caller = new CancellableCall<Void>(){

            @Override
            public Void call(ICancelIndicator cancelIndicator) throws Exception {
                PropertySet<DevicePropertyGroup> cableInfoModel = CableInfoPopupController.this.updateModel(null);
                CableInfoPopupController.this.view.updatePopup(cableInfoModel, false);
                CategoryProcessorContext categoryCtx = new CategoryProcessorContext(lid, portNum, CableInfoPopupController.this.context);
                PropertyCategory propCategory = new PropertyCategory();
                propCategory.setResourceCategory(ResourceCategoryMap.CABLE_INFO.getResourceCategory());
                CableInfoPopupController.this.category = new DevicePropertyCategory(propCategory);
                CableInfoPopupController.this.cableInfoProcessor.process(categoryCtx, CableInfoPopupController.this.category);
                return null;
            }
        };
        CallbackAdapter<Void> callback = new CallbackAdapter<Void>(){

            @Override
            public void onDone(Void result) {
                if (CableInfoPopupController.this.category != null) {
                    CableInfoPopupController.this.itemList = CableInfoPopupController.this.category.getList();
                    PropertySet<DevicePropertyGroup> cableInfoModel = CableInfoPopupController.this.updateModel(CableInfoPopupController.this.itemList);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    CableInfoPopupController.this.view.updatePopup(cableInfoModel, true);
                }
            }
        };
        this.taskMgr.submit(caller, callback);
    }
}

