/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor;

import com.intel.stl.api.notice.NoticeSeverity;
import com.intel.stl.ui.common.BaseSectionController;
import com.intel.stl.ui.common.ICardController;
import com.intel.stl.ui.common.view.ISectionListener;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.HelpAction;
import com.intel.stl.ui.model.DevicesStatistics;
import com.intel.stl.ui.monitor.PSEventsCard;
import com.intel.stl.ui.monitor.PSStatisticsCard;
import com.intel.stl.ui.monitor.view.PSInfoSectionView;
import java.util.Date;
import java.util.EnumMap;
import net.engio.mbassy.bus.MBassador;

public class PSInfoSection
extends BaseSectionController<ISectionListener, PSInfoSectionView> {
    private final PSStatisticsCard statisticsCard;
    private final PSEventsCard eventsCard;

    public PSInfoSection(PSInfoSectionView view, MBassador<IAppEvent> eventBus) {
        super(view, eventBus);
        this.statisticsCard = new PSStatisticsCard(view.getStatisticsCardView(), eventBus);
        this.eventsCard = new PSEventsCard(view.getEventsCardView(), eventBus);
    }

    @Override
    public String getHelpID() {
        return HelpAction.getInstance().getPerfSubnetSummary();
    }

    @Override
    public ICardController<?>[] getCards() {
        return new ICardController[]{this.statisticsCard, this.eventsCard};
    }

    @Override
    public void onHelp() {
    }

    public void updateStatistics(DevicesStatistics dgStats) {
        this.statisticsCard.updateStatistics(dgStats);
    }

    public void updateStates(EnumMap<NoticeSeverity, Integer> switchStates, int switchTotal) {
        Date date = new Date();
        this.eventsCard.updateStates(switchStates, switchTotal, date);
    }

    @Override
    public void clear() {
        this.statisticsCard.clear();
        this.eventsCard.clear();
    }

    @Override
    protected ISectionListener getSectionListener() {
        return this;
    }
}

