/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.monitor;

import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.model.NodeTypeViz;
import com.intel.stl.ui.monitor.view.PSNodesDetailsPanel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import javax.swing.Timer;
import org.jfree.data.general.DefaultPieDataset;

public class PSNodesDetailsController {
    private final String name;
    private final DefaultPieDataset typeDataset;
    private final PSNodesDetailsPanel view;
    private Timer viewClearTimer;

    public PSNodesDetailsController(String name, PSNodesDetailsPanel view) {
        this.view = view;
        this.name = name;
        view.setName(name);
        this.typeDataset = new DefaultPieDataset();
        this.typeDataset.setValue((Comparable)((Object)NodeType.SWITCH), 0.0);
        this.typeDataset.setValue((Comparable)((Object)NodeType.HFI), 0.0);
        Color[] colors = new Color[]{NodeTypeViz.SWITCH.getColor(), NodeTypeViz.HFI.getColor()};
        view.setTypeDataset(this.typeDataset, colors);
    }

    public PSNodesDetailsPanel getView() {
        return this.view;
    }

    public String getName() {
        return this.name;
    }

    public DefaultPieDataset getTypeDataset() {
        return this.typeDataset;
    }

    public void setTypes(int total, long other, EnumMap<NodeType, Integer> types) {
        if (this.viewClearTimer != null) {
            if (this.viewClearTimer.isRunning()) {
                this.viewClearTimer.stop();
            }
            this.viewClearTimer = null;
        }
        final long[] counts = NodeTypeViz.getDistributionValues2(types);
        final String totalNumber = UIConstants.INTEGER.format(total);
        final String caNumber = UIConstants.INTEGER.format(counts[0]);
        final String caLabel = counts[0] == 1L ? STLConstants.K0051_HOST.getValue() : STLConstants.K0052_HOSTS.getValue();
        final String swNumber = UIConstants.INTEGER.format(counts[1]);
        final String swLabel = counts[1] == 1L ? STLConstants.K0017_SWITCH.getValue() : STLConstants.K0048_SWITCHES.getValue();
        final String otherPorts = UIConstants.INTEGER.format(other);
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                PSNodesDetailsController.this.typeDataset.setValue((Comparable)((Object)NodeType.HFI), (double)counts[0]);
                PSNodesDetailsController.this.typeDataset.setValue((Comparable)((Object)NodeType.SWITCH), (double)counts[1]);
                PSNodesDetailsController.this.view.setTotalNumber(totalNumber);
                PSNodesDetailsController.this.view.setSwitches(swNumber, swLabel);
                PSNodesDetailsController.this.view.setFabricInterfaes(caNumber, caLabel);
                PSNodesDetailsController.this.view.setOtherPorts(otherPorts);
            }
        });
    }

    public void clear() {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                PSNodesDetailsController.this.typeDataset.clear();
            }
        });
        if (this.viewClearTimer == null) {
            this.viewClearTimer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PSNodesDetailsController.this.viewClearTimer != null) {
                        PSNodesDetailsController.this.view.clear();
                    }
                }
            });
            this.viewClearTimer.setRepeats(false);
        }
        this.viewClearTimer.restart();
    }
}

